/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzao;
import com.google.android.gms.internal.firebase-perf.zzcb;
import com.google.android.gms.internal.firebase-perf.zzce;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzaq
extends zzao<Boolean>
implements zzce<Boolean>,
RandomAccess {
    private static final zzaq zzgh = new zzaq();
    private boolean[] zzgi;
    private int size;

    zzaq() {
        this(new boolean[10], 0);
    }

    private zzaq(boolean[] blArray, int n) {
        this.zzgi = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzgi, n2, this.zzgi, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzaq)) {
            return super.equals(object);
        }
        zzaq zzaq2 = (zzaq)object;
        if (this.size != zzaq2.size) {
            return false;
        }
        boolean[] blArray = zzaq2.zzgi;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzgi[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzcb.zzf(this.zzgi[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzaw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
        if (this.size < this.zzgi.length) {
            System.arraycopy(this.zzgi, n, this.zzgi, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzgi, 0, blArray, 0, n);
            System.arraycopy(this.zzgi, n, blArray, n + 1, this.size - n);
            this.zzgi = blArray;
        }
        this.zzgi[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzaw();
        zzcb.checkNotNull(collection);
        if (!(collection instanceof zzaq)) {
            return super.addAll(collection);
        }
        zzaq zzaq2 = (zzaq)collection;
        if (zzaq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzaq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzaq2.size;
        if (n > this.zzgi.length) {
            this.zzgi = Arrays.copyOf(this.zzgi, n);
        }
        System.arraycopy(zzaq2.zzgi, 0, this.zzgi, this.size, zzaq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzgi[i])) continue;
            System.arraycopy(this.zzgi, i + 1, this.zzgi, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzaq zzaq2 = this;
        zzaq2.zzaw();
        zzaq2.zzf(n);
        boolean bl3 = zzaq2.zzgi[n];
        zzaq2.zzgi[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzaq zzaq2 = this;
        zzaq2.zzaw();
        zzaq2.zzf(n);
        boolean bl = zzaq2.zzgi[n];
        if (n < zzaq2.size - 1) {
            System.arraycopy(zzaq2.zzgi, n + 1, zzaq2.zzgi, n, zzaq2.size - n);
        }
        --zzaq2.size;
        ++zzaq2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzce zzh(int n) {
        int n2 = n;
        zzaq zzaq2 = this;
        if (n2 < zzaq2.size) {
            throw new IllegalArgumentException();
        }
        return new zzaq(Arrays.copyOf(zzaq2.zzgi, n2), zzaq2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzaq zzaq2 = this;
        zzaq2.zzf(n);
        return zzaq2.zzgi[n];
    }

    static {
        zzgh.zzav();
    }
}

