/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzal;
import com.google.android.gms.internal.firebase-perf.zzar;
import com.google.android.gms.internal.firebase-perf.zzas;
import com.google.android.gms.internal.firebase-perf.zzbh;
import com.google.android.gms.internal.firebase-perf.zzbi;
import com.google.android.gms.internal.firebase-perf.zzcb;
import com.google.android.gms.internal.firebase-perf.zzcm;
import com.google.android.gms.internal.firebase-perf.zzdf;
import com.google.android.gms.internal.firebase-perf.zzdt;
import com.google.android.gms.internal.firebase-perf.zzer;
import com.google.android.gms.internal.firebase-perf.zzet;
import com.google.android.gms.internal.firebase-perf.zzew;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzbg
extends zzar {
    private static final Logger logger = Logger.getLogger(zzbg.class.getName());
    private static final boolean zzhf = zzer.zzfd();
    zzbi zzhg;

    public static zzbg zzc(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzbg zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzer.zzfe()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzbg() {
    }

    public abstract void zzb(int var1, int var2) throws IOException;

    public abstract void zzc(int var1, int var2) throws IOException;

    public abstract void zzd(int var1, int var2) throws IOException;

    public final void zze(int n, int n2) throws IOException {
        this.zzd(n, zzbg.zzaf(n2));
    }

    public abstract void zzf(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzbg.zzs(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzf(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zza(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzas var2) throws IOException;

    public abstract void zza(int var1, zzdf var2) throws IOException;

    abstract void zza(int var1, zzdf var2, zzdt var3) throws IOException;

    public abstract void zzb(int var1, zzdf var2) throws IOException;

    public abstract void zzb(int var1, zzas var2) throws IOException;

    public abstract void zzu(int var1) throws IOException;

    public abstract void zzv(int var1) throws IOException;

    public final void zzw(int n) throws IOException {
        this.zzv(zzbg.zzaf(n));
    }

    public abstract void zzx(int var1) throws IOException;

    public abstract void zzk(long var1) throws IOException;

    public final void zzl(long l) throws IOException {
        this.zzk(zzbg.zzs(l));
    }

    public abstract void zzm(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzx(Float.floatToRawIntBits(f));
    }

    public final void zza(double d) throws IOException {
        this.zzm(Double.doubleToRawLongBits(d));
    }

    public final void zzd(boolean bl) throws IOException {
        this.zza((byte)(bl ? 1 : 0));
    }

    public abstract void zzm(String var1) throws IOException;

    public abstract void zza(zzas var1) throws IOException;

    public abstract void zzb(zzdf var1) throws IOException;

    abstract void zza(zzdf var1, zzdt var2) throws IOException;

    public abstract void zza(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzg(int n, int n2) {
        return zzbg.zzy(n) + zzbg.zzz(n2);
    }

    public static int zzh(int n, int n2) {
        return zzbg.zzy(n) + zzbg.zzaa(n2);
    }

    public static int zzi(int n, int n2) {
        return zzbg.zzy(n) + zzbg.zzaa(zzbg.zzaf(n2));
    }

    public static int zzj(int n, int n2) {
        return zzbg.zzy(n) + 4;
    }

    public static int zzk(int n, int n2) {
        return zzbg.zzy(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzbg.zzy(n) + zzbg.zzo(l);
    }

    public static int zze(int n, long l) {
        return zzbg.zzy(n) + zzbg.zzo(l);
    }

    public static int zzf(int n, long l) {
        return zzbg.zzy(n) + zzbg.zzo(zzbg.zzs(l));
    }

    public static int zzg(int n, long l) {
        return zzbg.zzy(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzbg.zzy(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzbg.zzy(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzbg.zzy(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzbg.zzy(n) + 1;
    }

    public static int zzl(int n, int n2) {
        return zzbg.zzy(n) + zzbg.zzz(n2);
    }

    public static int zzb(int n, String string) {
        return zzbg.zzy(n) + zzbg.zzn(string);
    }

    public static int zzc(int n, zzas zzas2) {
        int n2 = zzas2.size();
        return zzbg.zzy(n) + (zzbg.zzaa(n2) + n2);
    }

    public static int zza(int n, zzcm zzcm2) {
        int n2 = zzcm2.zzct();
        return zzbg.zzy(n) + (zzbg.zzaa(n2) + n2);
    }

    public static int zzc(int n, zzdf zzdf2) {
        return zzbg.zzy(n) + zzbg.zzc(zzdf2);
    }

    static int zzb(int n, zzdf zzdf2, zzdt zzdt2) {
        return zzbg.zzy(n) + zzbg.zzb(zzdf2, zzdt2);
    }

    public static int zzd(int n, zzdf zzdf2) {
        return (zzbg.zzy(1) << 1) + zzbg.zzh(2, n) + zzbg.zzc(3, zzdf2);
    }

    public static int zzd(int n, zzas zzas2) {
        return (zzbg.zzy(1) << 1) + zzbg.zzh(2, n) + zzbg.zzc(3, zzas2);
    }

    public static int zzb(int n, zzcm zzcm2) {
        return (zzbg.zzy(1) << 1) + zzbg.zzh(2, n) + zzbg.zza(3, zzcm2);
    }

    public static int zzy(int n) {
        return zzbg.zzaa(n << 3);
    }

    public static int zzz(int n) {
        if (n >= 0) {
            return zzbg.zzaa(n);
        }
        return 10;
    }

    public static int zzaa(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzab(int n) {
        return zzbg.zzaa(zzbg.zzaf(n));
    }

    public static int zzac(int n) {
        return 4;
    }

    public static int zzad(int n) {
        return 4;
    }

    public static int zzn(long l) {
        return zzbg.zzo(l);
    }

    public static int zzo(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzp(long l) {
        return zzbg.zzo(zzbg.zzs(l));
    }

    public static int zzq(long l) {
        return 8;
    }

    public static int zzr(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zzb(double d) {
        return 8;
    }

    public static int zze(boolean bl) {
        return 1;
    }

    public static int zzae(int n) {
        return zzbg.zzz(n);
    }

    public static int zzn(String string) {
        int n;
        try {
            n = zzet.zza(string);
        }
        catch (zzew zzew2) {
            n = string.getBytes(zzcb.UTF_8).length;
        }
        int n2 = n;
        return zzbg.zzaa(n2) + n2;
    }

    public static int zza(zzcm zzcm2) {
        int n = zzcm2.zzct();
        return zzbg.zzaa(n) + n;
    }

    public static int zzb(zzas zzas2) {
        int n = zzas2.size();
        return zzbg.zzaa(n) + n;
    }

    public static int zzd(byte[] byArray) {
        int n = byArray.length;
        return zzbg.zzaa(n) + n;
    }

    public static int zzc(zzdf zzdf2) {
        int n = zzdf2.zzct();
        return zzbg.zzaa(n) + n;
    }

    static int zzb(zzdf zzdf2, zzdt zzdt2) {
        zzdt zzdt3 = zzdt2;
        zzal zzal2 = (zzal)zzdf2;
        int n = zzal2.zzas();
        if (n == -1) {
            n = zzdt3.zzm(zzal2);
            zzal2.zze(n);
        }
        int n2 = n;
        return zzbg.zzaa(n2) + n2;
    }

    private static int zzaf(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzs(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzcf();

    abstract void zze(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzew zzew2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzew2);
        byte[] byArray = string.getBytes(zzcb.UTF_8);
        try {
            this.zzv(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzdf zzdf2, zzdt zzdt2) {
        zzdt zzdt3;
        int n2 = zzbg.zzy(n) << 1;
        zzdt zzdt4 = zzdt3 = zzdt2;
        zzal zzal2 = (zzal)zzdf2;
        int n3 = zzal2.zzas();
        if (n3 == -1) {
            n3 = zzdt4.zzm(zzal2);
            zzal2.zze(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzdf zzdf2) {
        return zzdf2.zzct();
    }

    @Deprecated
    public static int zzag(int n) {
        return zzbg.zzaa(n);
    }

    /* synthetic */ zzbg(zzbh zzbh2) {
        this();
    }

    static final class zze
    extends zzbg {
        private final ByteBuffer zzhj;
        private final ByteBuffer zzhk;
        private final long zzhl;
        private final long zzhm;
        private final long zzhn;
        private final long zzho;
        private long zzhp;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzhj = byteBuffer;
            this.zzhk = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhl = zzer.zzb(byteBuffer);
            this.zzhm = this.zzhl + (long)byteBuffer.position();
            this.zzhn = this.zzhl + (long)byteBuffer.limit();
            this.zzho = this.zzhn - 10L;
            this.zzhp = this.zzhm;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbg)this).zzv(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zzu(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zzv(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzbg)this).zzb(n, 5);
            ((zzbg)this).zzx(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zzk(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzbg)this).zzb(n, 1);
            ((zzbg)this).zzm(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zzm(string);
        }

        @Override
        public final void zza(int n, zzas zzas2) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zza(zzas2);
        }

        @Override
        public final void zza(int n, zzdf zzdf2) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zzb(zzdf2);
        }

        @Override
        final void zza(int n, zzdf zzdf2, zzdt zzdt2) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zza(zzdf2, zzdt2);
        }

        @Override
        public final void zzb(int n, zzdf zzdf2) throws IOException {
            ((zzbg)this).zzb(1, 3);
            ((zzbg)this).zzd(2, n);
            ((zzbg)this).zza(3, zzdf2);
            ((zzbg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzas zzas2) throws IOException {
            ((zzbg)this).zzb(1, 3);
            ((zzbg)this).zzd(2, n);
            ((zzbg)this).zza(3, zzas2);
            ((zzbg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzdf zzdf2) throws IOException {
            ((zzbg)this).zzv(zzdf2.zzct());
            zzdf2.zzb(this);
        }

        @Override
        final void zza(zzdf zzdf2, zzdt zzdt2) throws IOException {
            zzdt zzdt3 = zzdt2;
            zzal zzal2 = (zzal)zzdf2;
            int n = zzal2.zzas();
            if (n == -1) {
                n = zzdt3.zzm(zzal2);
                zzal2.zze(n);
            }
            ((zzbg)this).zzv(n);
            zzdt2.zza(zzdf2, this.zzhg);
        }

        @Override
        public final void zza(byte by) throws IOException {
            if (this.zzhp >= this.zzhn) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzhp, this.zzhn, 1));
            }
            zzer.zza(this.zzhp++, by);
        }

        @Override
        public final void zza(zzas zzas2) throws IOException {
            ((zzbg)this).zzv(zzas2.size());
            zzas2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzbg)this).zzv(n2);
            ((zzbg)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzu(int n) throws IOException {
            if (n >= 0) {
                ((zzbg)this).zzv(n);
                return;
            }
            ((zzbg)this).zzk(n);
        }

        @Override
        public final void zzv(int n) throws IOException {
            if (this.zzhp <= this.zzho) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzer.zza(this.zzhp++, (byte)n);
                        return;
                    }
                    zzer.zza(this.zzhp++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzhp < this.zzhn) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzer.zza(this.zzhp++, (byte)n);
                    return;
                }
                zzer.zza(this.zzhp++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzhp, this.zzhn, 1));
        }

        @Override
        public final void zzx(int n) throws IOException {
            long l = this.zzhp;
            zze zze2 = this;
            this.zzhk.putInt((int)(l - zze2.zzhl), n);
            this.zzhp += 4L;
        }

        @Override
        public final void zzk(long l) throws IOException {
            if (this.zzhp <= this.zzho) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzer.zza(this.zzhp++, (byte)l);
                        return;
                    }
                    zzer.zza(this.zzhp++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzhp < this.zzhn) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzer.zza(this.zzhp++, (byte)l);
                    return;
                }
                zzer.zza(this.zzhp++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzhp, this.zzhn, 1));
        }

        @Override
        public final void zzm(long l) throws IOException {
            long l2 = this.zzhp;
            zze zze2 = this;
            this.zzhk.putLong((int)(l2 - zze2.zzhl), l);
            this.zzhp += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzhn - (long)n2 < this.zzhp) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzhp, this.zzhn, n2));
            }
            zzer.zza(byArray, n, this.zzhp, n2);
            this.zzhp += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzbg)this).write(byArray, n, n2);
        }

        @Override
        public final void zzm(String string) throws IOException {
            long l = this.zzhp;
            try {
                int n = zze.zzaa(string.length() * 3);
                int n2 = zze.zzaa(string.length());
                if (n2 == n) {
                    long l2 = this.zzhp;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzhl) + n2;
                    this.zzhk.position(n3);
                    zzet.zza(string, this.zzhk);
                    int n4 = this.zzhk.position() - n3;
                    ((zzbg)this).zzv(n4);
                    this.zzhp += (long)n4;
                    return;
                }
                int n5 = zzet.zza(string);
                ((zzbg)this).zzv(n5);
                this.zzt(this.zzhp);
                zzet.zza(string, this.zzhk);
                this.zzhp += (long)n5;
                return;
            }
            catch (zzew zzew2) {
                this.zzhp = l;
                this.zzt(this.zzhp);
                this.zza(string, zzew2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzhp;
            zze zze2 = this;
            this.zzhj.position((int)(l - zze2.zzhl));
        }

        @Override
        public final int zzcf() {
            return (int)(this.zzhn - this.zzhp);
        }

        private final void zzt(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzhk.position((int)(l2 - zze2.zzhl));
        }
    }

    static final class zzd
    extends zzbg {
        private final ByteBuffer zzhj;
        private final ByteBuffer zzhk;
        private final int zzhi;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzhj = byteBuffer;
            this.zzhk = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhi = byteBuffer.position();
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbg)this).zzv(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zzu(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zzv(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzbg)this).zzb(n, 5);
            ((zzbg)this).zzx(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zzk(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzbg)this).zzb(n, 1);
            ((zzbg)this).zzm(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zzm(string);
        }

        @Override
        public final void zza(int n, zzas zzas2) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zza(zzas2);
        }

        @Override
        public final void zza(int n, zzdf zzdf2) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zzb(zzdf2);
        }

        @Override
        final void zza(int n, zzdf zzdf2, zzdt zzdt2) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zza(zzdf2, zzdt2);
        }

        @Override
        public final void zzb(int n, zzdf zzdf2) throws IOException {
            ((zzbg)this).zzb(1, 3);
            ((zzbg)this).zzd(2, n);
            ((zzbg)this).zza(3, zzdf2);
            ((zzbg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzas zzas2) throws IOException {
            ((zzbg)this).zzb(1, 3);
            ((zzbg)this).zzd(2, n);
            ((zzbg)this).zza(3, zzas2);
            ((zzbg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzdf zzdf2) throws IOException {
            ((zzbg)this).zzv(zzdf2.zzct());
            zzdf2.zzb(this);
        }

        @Override
        final void zza(zzdf zzdf2, zzdt zzdt2) throws IOException {
            zzdt zzdt3 = zzdt2;
            zzal zzal2 = (zzal)zzdf2;
            int n = zzal2.zzas();
            if (n == -1) {
                n = zzdt3.zzm(zzal2);
                zzal2.zze(n);
            }
            ((zzbg)this).zzv(n);
            zzdt2.zza(zzdf2, this.zzhg);
        }

        @Override
        public final void zza(byte by) throws IOException {
            try {
                this.zzhk.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzas zzas2) throws IOException {
            ((zzbg)this).zzv(zzas2.size());
            zzas2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzbg)this).zzv(n2);
            ((zzbg)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzu(int n) throws IOException {
            if (n >= 0) {
                ((zzbg)this).zzv(n);
                return;
            }
            ((zzbg)this).zzk(n);
        }

        @Override
        public final void zzv(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzhk.put((byte)n);
                        return;
                    }
                    this.zzhk.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzx(int n) throws IOException {
            try {
                this.zzhk.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzk(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzhk.put((byte)l);
                        return;
                    }
                    this.zzhk.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzm(long l) throws IOException {
            try {
                this.zzhk.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzhk.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzbg)this).write(byArray, n, n2);
        }

        @Override
        public final void zzm(String string) throws IOException {
            int n = this.zzhk.position();
            try {
                int n2 = zzd.zzaa(string.length() * 3);
                int n3 = zzd.zzaa(string.length());
                if (n3 == n2) {
                    int n4 = this.zzhk.position() + n3;
                    this.zzhk.position(n4);
                    this.zzo(string);
                    int n5 = this.zzhk.position();
                    this.zzhk.position(n);
                    ((zzbg)this).zzv(n5 - n4);
                    this.zzhk.position(n5);
                    return;
                }
                int n6 = zzet.zza(string);
                ((zzbg)this).zzv(n6);
                this.zzo(string);
                return;
            }
            catch (zzew zzew2) {
                this.zzhk.position(n);
                this.zza(string, zzew2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzhj.position(this.zzhk.position());
        }

        @Override
        public final int zzcf() {
            return this.zzhk.remaining();
        }

        private final void zzo(String string) throws IOException {
            try {
                zzet.zza(string, this.zzhk);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzhh;
        private int zzhi;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzhh = byteBuffer;
            this.zzhi = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzhh.position(this.zzhi + this.zzch());
        }
    }

    static class zza
    extends zzbg {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbg)this).zzv(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zzu(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zzv(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzbg)this).zzb(n, 5);
            ((zzbg)this).zzx(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zzk(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzbg)this).zzb(n, 1);
            ((zzbg)this).zzm(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzbg)this).zzb(n, 0);
            ((zzbg)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zzm(string);
        }

        @Override
        public final void zza(int n, zzas zzas2) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zza(zzas2);
        }

        @Override
        public final void zza(zzas zzas2) throws IOException {
            ((zzbg)this).zzv(zzas2.size());
            zzas2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzbg)this).zzv(n2);
            ((zzbg)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzdf zzdf2) throws IOException {
            ((zzbg)this).zzb(n, 2);
            ((zzbg)this).zzb(zzdf2);
        }

        @Override
        final void zza(int n, zzdf zzdf2, zzdt zzdt2) throws IOException {
            ((zzbg)this).zzb(n, 2);
            zzdt zzdt3 = zzdt2;
            zzal zzal2 = (zzal)zzdf2;
            int n2 = zzal2.zzas();
            if (n2 == -1) {
                n2 = zzdt3.zzm(zzal2);
                zzal2.zze(n2);
            }
            ((zzbg)this).zzv(n2);
            zzdt2.zza(zzdf2, this.zzhg);
        }

        @Override
        public final void zzb(int n, zzdf zzdf2) throws IOException {
            ((zzbg)this).zzb(1, 3);
            ((zzbg)this).zzd(2, n);
            ((zzbg)this).zza(3, zzdf2);
            ((zzbg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzas zzas2) throws IOException {
            ((zzbg)this).zzb(1, 3);
            ((zzbg)this).zzd(2, n);
            ((zzbg)this).zza(3, zzas2);
            ((zzbg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzdf zzdf2) throws IOException {
            ((zzbg)this).zzv(zzdf2.zzct());
            zzdf2.zzb(this);
        }

        @Override
        final void zza(zzdf zzdf2, zzdt zzdt2) throws IOException {
            zzdt zzdt3 = zzdt2;
            zzal zzal2 = (zzal)zzdf2;
            int n = zzal2.zzas();
            if (n == -1) {
                n = zzdt3.zzm(zzal2);
                zzal2.zze(n);
            }
            ((zzbg)this).zzv(n);
            zzdt2.zza(zzdf2, this.zzhg);
        }

        @Override
        public final void zza(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzu(int n) throws IOException {
            if (n >= 0) {
                ((zzbg)this).zzv(n);
                return;
            }
            ((zzbg)this).zzk(n);
        }

        @Override
        public final void zzv(int n) throws IOException {
            if (zzhf && ((zzbg)this).zzcf() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzer.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzer.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzx(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzk(long l) throws IOException {
            if (zzhf && ((zzbg)this).zzcf() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzer.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzer.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzm(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzbg)this).write(byArray, n, n2);
        }

        @Override
        public final void zzm(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzaa(string.length() * 3);
                int n3 = zza.zzaa(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzet.zza(string, this.buffer, this.position, ((zzbg)this).zzcf());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzbg)this).zzv(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzet.zza(string);
                ((zzbg)this).zzv(n6);
                this.position = zzet.zza(string, this.buffer, this.position, ((zzbg)this).zzcf());
                return;
            }
            catch (zzew zzew2) {
                this.position = n;
                this.zza(string, zzew2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzcf() {
            return this.limit - this.position;
        }

        public final int zzch() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

