/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzao;
import com.google.android.gms.internal.firebase-perf.zzcb;
import com.google.android.gms.internal.firebase-perf.zzce;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbj
extends zzao<Double>
implements zzce<Double>,
RandomAccess {
    private static final zzbj zzhq = new zzbj();
    private double[] zzhr;
    private int size;

    zzbj() {
        this(new double[10], 0);
    }

    private zzbj(double[] dArray, int n) {
        this.zzhr = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhr, n2, this.zzhr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbj)) {
            return super.equals(object);
        }
        zzbj zzbj2 = (zzbj)object;
        if (this.size != zzbj2.size) {
            return false;
        }
        double[] dArray = zzbj2.zzhr;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhr[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzhr[i]);
            n = n * 31 + zzcb.zzu(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzaw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
        if (this.size < this.zzhr.length) {
            System.arraycopy(this.zzhr, n, this.zzhr, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhr, 0, dArray, 0, n);
            System.arraycopy(this.zzhr, n, dArray, n + 1, this.size - n);
            this.zzhr = dArray;
        }
        this.zzhr[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzaw();
        zzcb.checkNotNull(collection);
        if (!(collection instanceof zzbj)) {
            return super.addAll(collection);
        }
        zzbj zzbj2 = (zzbj)collection;
        if (zzbj2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbj2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbj2.size;
        if (n > this.zzhr.length) {
            this.zzhr = Arrays.copyOf(this.zzhr, n);
        }
        System.arraycopy(zzbj2.zzhr, 0, this.zzhr, this.size, zzbj2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhr[i])) continue;
            System.arraycopy(this.zzhr, i + 1, this.zzhr, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzbj zzbj2 = this;
        zzbj2.zzaw();
        zzbj2.zzf(n);
        double d3 = zzbj2.zzhr[n];
        zzbj2.zzhr[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbj zzbj2 = this;
        zzbj2.zzaw();
        zzbj2.zzf(n);
        double d = zzbj2.zzhr[n];
        if (n < zzbj2.size - 1) {
            System.arraycopy(zzbj2.zzhr, n + 1, zzbj2.zzhr, n, zzbj2.size - n);
        }
        --zzbj2.size;
        ++zzbj2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzce zzh(int n) {
        int n2 = n;
        zzbj zzbj2 = this;
        if (n2 < zzbj2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbj(Arrays.copyOf(zzbj2.zzhr, n2), zzbj2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbj zzbj2 = this;
        zzbj2.zzf(n);
        return zzbj2.zzhr[n];
    }

    static {
        zzhq.zzav();
    }
}

