/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzao;
import com.google.android.gms.internal.firebase-perf.zzcb;
import com.google.android.gms.internal.firebase-perf.zzce;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbw
extends zzao<Float>
implements zzce<Float>,
RandomAccess {
    private static final zzbw zzkt = new zzbw();
    private float[] zzku;
    private int size;

    zzbw() {
        this(new float[10], 0);
    }

    private zzbw(float[] fArray, int n) {
        this.zzku = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzku, n2, this.zzku, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbw)) {
            return super.equals(object);
        }
        zzbw zzbw2 = (zzbw)object;
        if (this.size != zzbw2.size) {
            return false;
        }
        float[] fArray = zzbw2.zzku;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzku[i] == fArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzku[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzaw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
        if (this.size < this.zzku.length) {
            System.arraycopy(this.zzku, n, this.zzku, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzku, 0, fArray, 0, n);
            System.arraycopy(this.zzku, n, fArray, n + 1, this.size - n);
            this.zzku = fArray;
        }
        this.zzku[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzaw();
        zzcb.checkNotNull(collection);
        if (!(collection instanceof zzbw)) {
            return super.addAll(collection);
        }
        zzbw zzbw2 = (zzbw)collection;
        if (zzbw2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbw2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbw2.size;
        if (n > this.zzku.length) {
            this.zzku = Arrays.copyOf(this.zzku, n);
        }
        System.arraycopy(zzbw2.zzku, 0, this.zzku, this.size, zzbw2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzku[i]))) continue;
            System.arraycopy(this.zzku, i + 1, this.zzku, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzbw zzbw2 = this;
        zzbw2.zzaw();
        zzbw2.zzf(n);
        float f3 = zzbw2.zzku[n];
        zzbw2.zzku[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbw zzbw2 = this;
        zzbw2.zzaw();
        zzbw2.zzf(n);
        float f = zzbw2.zzku[n];
        if (n < zzbw2.size - 1) {
            System.arraycopy(zzbw2.zzku, n + 1, zzbw2.zzku, n, zzbw2.size - n);
        }
        --zzbw2.size;
        ++zzbw2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzce zzh(int n) {
        int n2 = n;
        zzbw zzbw2 = this;
        if (n2 < zzbw2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbw(Arrays.copyOf(zzbw2.zzku, n2), zzbw2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbw zzbw2 = this;
        zzbw2.zzf(n);
        return Float.valueOf(zzbw2.zzku[n]);
    }

    static {
        zzkt.zzav();
    }
}

