/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzao;
import com.google.android.gms.internal.firebase-perf.zzcb;
import com.google.android.gms.internal.firebase-perf.zzce;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzca
extends zzao<Integer>
implements zzce<Integer>,
RandomAccess {
    private static final zzca zzls = new zzca();
    private int[] zzlt;
    private int size;

    zzca() {
        this(new int[10], 0);
    }

    private zzca(int[] nArray, int n) {
        this.zzlt = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzlt, n2, this.zzlt, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzca)) {
            return super.equals(object);
        }
        zzca zzca2 = (zzca)object;
        if (this.size != zzca2.size) {
            return false;
        }
        int[] nArray = zzca2.zzlt;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzlt[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzlt[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzf(n);
        return this.zzlt[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzaj(int n) {
        this.zzo(this.size, n);
    }

    private final void zzo(int n, int n2) {
        this.zzaw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
        if (this.size < this.zzlt.length) {
            System.arraycopy(this.zzlt, n, this.zzlt, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzlt, 0, nArray, 0, n);
            System.arraycopy(this.zzlt, n, nArray, n + 1, this.size - n);
            this.zzlt = nArray;
        }
        this.zzlt[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzaw();
        zzcb.checkNotNull(collection);
        if (!(collection instanceof zzca)) {
            return super.addAll(collection);
        }
        zzca zzca2 = (zzca)collection;
        if (zzca2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzca2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzca2.size;
        if (n > this.zzlt.length) {
            this.zzlt = Arrays.copyOf(this.zzlt, n);
        }
        System.arraycopy(zzca2.zzlt, 0, this.zzlt, this.size, zzca2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzlt[i])) continue;
            System.arraycopy(this.zzlt, i + 1, this.zzlt, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzca zzca2 = this;
        zzca2.zzaw();
        zzca2.zzf(n);
        int n4 = zzca2.zzlt[n];
        zzca2.zzlt[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzca zzca2 = this;
        zzca2.zzaw();
        zzca2.zzf(n);
        int n2 = zzca2.zzlt[n];
        if (n < zzca2.size - 1) {
            System.arraycopy(zzca2.zzlt, n + 1, zzca2.zzlt, n, zzca2.size - n);
        }
        --zzca2.size;
        ++zzca2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzo(n, n2);
    }

    @Override
    public final /* synthetic */ zzce zzh(int n) {
        int n2 = n;
        zzca zzca2 = this;
        if (n2 < zzca2.size) {
            throw new IllegalArgumentException();
        }
        return new zzca(Arrays.copyOf(zzca2.zzlt, n2), zzca2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzls.zzav();
    }
}

