/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzao;
import com.google.android.gms.internal.firebase-perf.zzcb;
import com.google.android.gms.internal.firebase-perf.zzce;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzct
extends zzao<Long>
implements zzce<Long>,
RandomAccess {
    private static final zzct zzmw = new zzct();
    private long[] zzmx;
    private int size;

    zzct() {
        this(new long[10], 0);
    }

    private zzct(long[] lArray, int n) {
        this.zzmx = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzmx, n2, this.zzmx, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzct)) {
            return super.equals(object);
        }
        zzct zzct2 = (zzct)object;
        if (this.size != zzct2.size) {
            return false;
        }
        long[] lArray = zzct2.zzmx;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzmx[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzcb.zzu(this.zzmx[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzf(n);
        return this.zzmx[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzv(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzaw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
        if (this.size < this.zzmx.length) {
            System.arraycopy(this.zzmx, n, this.zzmx, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzmx, 0, lArray, 0, n);
            System.arraycopy(this.zzmx, n, lArray, n + 1, this.size - n);
            this.zzmx = lArray;
        }
        this.zzmx[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzaw();
        zzcb.checkNotNull(collection);
        if (!(collection instanceof zzct)) {
            return super.addAll(collection);
        }
        zzct zzct2 = (zzct)collection;
        if (zzct2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzct2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzct2.size;
        if (n > this.zzmx.length) {
            this.zzmx = Arrays.copyOf(this.zzmx, n);
        }
        System.arraycopy(zzct2.zzmx, 0, this.zzmx, this.size, zzct2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzmx[i])) continue;
            System.arraycopy(this.zzmx, i + 1, this.zzmx, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzct zzct2 = this;
        zzct2.zzaw();
        zzct2.zzf(n);
        long l3 = zzct2.zzmx[n];
        zzct2.zzmx[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzct zzct2 = this;
        zzct2.zzaw();
        zzct2.zzf(n);
        long l = zzct2.zzmx[n];
        if (n < zzct2.size - 1) {
            System.arraycopy(zzct2.zzmx, n + 1, zzct2.zzmx, n, zzct2.size - n);
        }
        --zzct2.size;
        ++zzct2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzce zzh(int n) {
        int n2 = n;
        zzct zzct2 = this;
        if (n2 < zzct2.size) {
            throw new IllegalArgumentException();
        }
        return new zzct(Arrays.copyOf(zzct2.zzmx, n2), zzct2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzmw.zzav();
    }
}

