/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FrameMetricsAggregator;
import android.util.Log;
import android.util.SparseIntArray;
import com.google.android.gms.internal.firebase-perf.zzaa;
import com.google.android.gms.internal.firebase-perf.zzai;
import com.google.android.gms.internal.firebase-perf.zzaj;
import com.google.android.gms.internal.firebase-perf.zzg;
import com.google.android.gms.internal.firebase-perf.zzq;
import com.google.android.gms.internal.firebase-perf.zzt;
import com.google.android.gms.internal.firebase-perf.zzu;
import com.google.android.gms.internal.firebase-perf.zzv;
import com.google.android.gms.internal.firebase-perf.zzw;
import com.google.firebase.perf.metrics.Trace;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class zzd
implements Application.ActivityLifecycleCallbacks {
    private static volatile zzd zzag;
    private boolean mRegistered = false;
    private zzg zzq = null;
    private final zzt zzah;
    private boolean zzai = true;
    private final WeakHashMap<Activity, Boolean> zzaj = new WeakHashMap();
    private zzw zzak;
    private zzw zzal;
    private final Map<String, Long> zzam = new HashMap<String, Long>();
    private AtomicInteger zzan = new AtomicInteger(0);
    private int zzao = 2;
    private Set<WeakReference<zza>> zzap = new HashSet<WeakReference<zza>>();
    private boolean zzaq = false;
    private FrameMetricsAggregator zzar;
    private final WeakHashMap<Activity, Trace> zzas = new WeakHashMap();

    public static zzd zzg() {
        if (zzag != null) {
            return zzag;
        }
        return zzd.zza(null, new zzt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static zzd zza(zzg zzg2, zzt zzt2) {
        if (zzag != null) return zzag;
        Class<zzd> clazz = zzd.class;
        synchronized (zzd.class) {
            if (zzag != null) return zzag;
            zzag = new zzd(null, zzt2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzag;
        }
    }

    private zzd(zzg zzg2, zzt zzt2) {
        this.zzah = zzt2;
        this.zzaq = zzd.zzk();
        if (this.zzaq) {
            this.zzar = new FrameMetricsAggregator();
        }
    }

    public final synchronized void zzc(Context context) {
        if (this.mRegistered) {
            return;
        }
        Context context2 = context.getApplicationContext();
        if (context2 instanceof Application) {
            ((Application)context2).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mRegistered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull String string, long l) {
        Map<String, Long> map = this.zzam;
        synchronized (map) {
            Long l2 = this.zzam.get(string);
            if (l2 == null) {
                this.zzam.put(string, 1L);
            } else {
                this.zzam.put(string, l2 + 1L);
            }
            return;
        }
    }

    public final void zzb(int n) {
        this.zzan.addAndGet(1);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.zzj()) {
            this.zzar.add(activity);
            this.zzi();
            Trace trace = new Trace(zzd.zza(activity), this.zzq, this.zzah, this);
            trace.start();
            this.zzas.put(activity, trace);
        }
    }

    public synchronized void onActivityStopped(Activity activity) {
        if (this.zzj()) {
            Trace trace;
            Activity activity2 = activity;
            zzd zzd2 = this;
            if (zzd2.zzas.containsKey(activity2) && (trace = zzd2.zzas.get(activity2)) != null) {
                int n;
                int n2;
                int n3;
                Object object;
                zzd2.zzas.remove(activity2);
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                SparseIntArray[] sparseIntArrayArray = zzd2.zzar.remove(activity2);
                if (sparseIntArrayArray != null && (object = sparseIntArrayArray[0]) != null) {
                    for (n3 = 0; n3 < object.size(); ++n3) {
                        n2 = object.keyAt(n3);
                        n = object.valueAt(n3);
                        n4 += n;
                        if (n2 > 700) {
                            n6 += n;
                        }
                        if (n2 <= 16) continue;
                        n5 += n;
                    }
                }
                if (n4 > 0) {
                    trace.incrementCounter(zzu.zzec.toString(), n4);
                }
                if (n5 > 0) {
                    trace.incrementCounter(zzu.zzed.toString(), n5);
                }
                if (n6 > 0) {
                    trace.incrementCounter(zzu.zzee.toString(), n6);
                }
                if (zzaa.zzf(activity2.getApplicationContext())) {
                    object = zzd.zza(activity2);
                    n3 = n4;
                    n2 = n5;
                    n = n6;
                    Log.d((String)"FirebasePerformance", (String)new StringBuilder(81 + String.valueOf(object).length()).append("sendScreenTrace name:").append((String)object).append(" _fr_tot:").append(n3).append(" _fr_slo:").append(n2).append(" _fr_fzn:").append(n).toString());
                }
                trace.stop();
            }
        }
        if (this.zzaj.containsKey(activity)) {
            this.zzaj.remove(activity);
            if (this.zzaj.isEmpty()) {
                this.zzak = new zzw();
                this.zzc(2);
                this.zza(false);
                this.zza(zzv.zzek.toString(), this.zzal, this.zzak);
            }
        }
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.zzaj.isEmpty()) {
            this.zzal = new zzw();
            this.zzaj.put(activity, true);
            if (this.zzai) {
                this.zzai = false;
                this.zzc(1);
                this.zza(true);
                return;
            }
            this.zzc(1);
            this.zza(true);
            this.zza(zzv.zzel.toString(), this.zzak, this.zzal);
            return;
        }
        this.zzaj.put(activity, true);
    }

    public final int zzh() {
        return this.zzao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(WeakReference<zza> weakReference) {
        Set<WeakReference<zza>> set = this.zzap;
        synchronized (set) {
            this.zzap.add(weakReference);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(WeakReference<zza> weakReference) {
        Set<WeakReference<zza>> set = this.zzap;
        synchronized (set) {
            this.zzap.remove(weakReference);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzc(int n) {
        this.zzao = n;
        Set<WeakReference<zza>> set = this.zzap;
        synchronized (set) {
            Iterator<WeakReference<zza>> iterator = this.zzap.iterator();
            while (iterator.hasNext()) {
                zza zza2 = (zza)iterator.next().get();
                if (zza2 != null) {
                    zza2.zzd(this.zzao);
                    continue;
                }
                iterator.remove();
            }
            return;
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityPaused(Activity activity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string, zzw zzw2, zzw zzw3) {
        this.zzi();
        zzai zzai2 = new zzai();
        new zzai().name = string;
        zzai2.zzfj = zzw2.zzaj();
        zzai2.zzfu = zzw2.zza(zzw3);
        int n = this.zzan.getAndSet(0);
        Map<String, Long> map = this.zzam;
        synchronized (map) {
            if (!this.zzam.isEmpty() || n != 0) {
                int n2 = n != 0 ? this.zzam.size() + 1 : this.zzam.size();
                zzai2.zzfv = new zzaj[n2];
                int n3 = 0;
                for (String string2 : this.zzam.keySet()) {
                    long l = this.zzam.get(string2);
                    zzaj zzaj2 = new zzaj();
                    new zzaj().key = string2;
                    zzaj2.zzfz = l;
                    zzai2.zzfv[n3++] = zzaj2;
                }
                if (n != 0) {
                    zzaj zzaj3 = new zzaj();
                    new zzaj().key = zzu.zzeb.toString();
                    zzaj3.zzfz = n;
                    zzai2.zzfv[n3] = zzaj3;
                }
            }
            this.zzam.clear();
        }
        if (this.zzq != null) {
            this.zzq.zza(zzai2, 3);
        }
    }

    private final void zza(boolean bl) {
        this.zzi();
        if (this.zzq != null) {
            this.zzq.zzb(bl);
        }
    }

    private final void zzi() {
        if (this.zzq == null) {
            this.zzq = zzg.zzo();
        }
    }

    private final boolean zzj() {
        return this.zzaq && com.google.android.gms.internal.firebase-perf.zzq.zzr();
    }

    private static boolean zzk() {
        try {
            Class.forName("android.support.v4.app.FrameMetricsAggregator");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static String zza(Activity activity) {
        String string = String.valueOf("_st_");
        String string2 = String.valueOf(activity.getClass().getSimpleName());
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    public static interface zza {
        public void zzd(int var1);
    }
}

