/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzbb;
import com.google.android.gms.internal.firebase-perf.zzbm;
import com.google.android.gms.internal.firebase-perf.zzbz;
import com.google.android.gms.internal.firebase-perf.zzcf;
import com.google.android.gms.internal.firebase-perf.zzdp;
import com.google.android.gms.internal.firebase-perf.zzfn;
import com.google.android.gms.internal.firebase-perf.zzfo;
import com.google.android.gms.internal.firebase-perf.zzfp;
import com.google.android.gms.internal.firebase-perf.zzfs;
import java.io.IOException;

public final class zzfg {
    private final byte[] buffer;
    private final int zzrf;
    private final int zzrg;
    private int zzrh;
    private int zzgx;
    private int zzri;
    private int zzgz;
    private int zzha = Integer.MAX_VALUE;
    private int zzgr;
    private int zzgs = 64;
    private int zzgt = 0x4000000;
    private zzbb zzrj;

    public static zzfg zzi(byte[] byArray, int n, int n2) {
        return new zzfg(byArray, 0, n2);
    }

    public final int zzbf() throws IOException {
        zzfg zzfg2 = this;
        if (zzfg2.zzri == zzfg2.zzrh) {
            this.zzgz = 0;
            return 0;
        }
        this.zzgz = this.zzbx();
        if (this.zzgz == 0) {
            throw new zzfo("Protocol message contained an invalid tag (zero).");
        }
        return this.zzgz;
    }

    public final void zzk(int n) throws zzfo {
        if (this.zzgz != n) {
            throw new zzfo("Protocol message end-group tag did not match expected tag.");
        }
    }

    public final boolean zzl(int n) throws IOException {
        switch (n & 7) {
            case 0: {
                this.zzbx();
                return true;
            }
            case 1: {
                zzfg zzfg2 = this;
                zzfg2.zzcc();
                zzfg2.zzcc();
                zzfg2.zzcc();
                zzfg2.zzcc();
                zzfg2.zzcc();
                zzfg2.zzcc();
                zzfg2.zzcc();
                zzfg2.zzcc();
                return true;
            }
            case 2: {
                this.zzp(this.zzbx());
                return true;
            }
            case 3: {
                int n2;
                zzfg zzfg3 = this;
                while ((n2 = zzfg3.zzbf()) != 0 && zzfg3.zzl(n2)) {
                }
                this.zzk(n >>> 3 << 3 | 4);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                zzfg zzfg4 = this;
                zzfg4.zzcc();
                zzfg4.zzcc();
                zzfg4.zzcc();
                zzfg4.zzcc();
                return true;
            }
        }
        throw new zzfo("Protocol message tag had invalid wire type.");
    }

    public final String readString() throws IOException {
        int n = this.zzbx();
        if (n < 0) {
            throw zzfo.zzfq();
        }
        if (n > this.zzrh - this.zzri) {
            throw zzfo.zzfp();
        }
        String string = new String(this.buffer, this.zzri, n, zzfn.UTF_8);
        this.zzri += n;
        return string;
    }

    public final void zza(zzfp zzfp2) throws IOException {
        int n = this.zzbx();
        if (this.zzgr >= this.zzgs) {
            throw new zzfo("Protocol message had too many levels of nesting.  May be malicious.  Use CodedInputStream.setRecursionLimit() to increase the depth limit.");
        }
        int n2 = n;
        zzfg zzfg2 = this;
        if (n2 < 0) {
            throw zzfo.zzfq();
        }
        int n3 = zzfg2.zzha;
        if ((n2 += zzfg2.zzri) > n3) {
            throw zzfo.zzfp();
        }
        zzfg2.zzha = n2;
        zzfg2.zzcb();
        int n4 = n3;
        ++this.zzgr;
        zzfp2.zza(this);
        this.zzk(0);
        --this.zzgr;
        n2 = n4;
        zzfg2 = this;
        this.zzha = n2;
        zzfg2.zzcb();
    }

    public final int zzbx() throws IOException {
        byte by = this.zzcc();
        if (by >= 0) {
            return by;
        }
        int n = by & 0x7F;
        by = this.zzcc();
        if (by >= 0) {
            n |= by << 7;
        } else {
            n |= (by & 0x7F) << 7;
            by = this.zzcc();
            if (by >= 0) {
                n |= by << 14;
            } else {
                n |= (by & 0x7F) << 14;
                by = this.zzcc();
                if (by >= 0) {
                    n |= by << 21;
                } else {
                    int n2 = n | (by & 0x7F) << 21;
                    by = this.zzcc();
                    n = n2 | by << 28;
                    if (by < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.zzcc() < 0) continue;
                            return n;
                        }
                        throw zzfo.zzfr();
                    }
                }
            }
        }
        return n;
    }

    public final long zzby() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.zzcc();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzfo.zzfr();
    }

    private zzfg(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.zzrf = n;
        this.zzrg = this.zzrh = n + n2;
        this.zzri = n;
    }

    public final <T extends zzbz<T, ?>> T zza(zzdp<T> zzdp2) throws IOException {
        try {
            int n;
            int n2;
            zzfg zzfg2 = this;
            if (zzfg2.zzrj == null) {
                zzfg2.zzrj = zzbb.zzd(zzfg2.buffer, zzfg2.zzrf, zzfg2.zzrg);
            }
            if ((n2 = zzfg2.zzrj.zzbw()) > (n = zzfg2.zzri - zzfg2.zzrf)) {
                throw new IOException(String.format("CodedInputStream read ahead of CodedInputByteBufferNano: %s > %s", n2, n));
            }
            zzfg2.zzrj.zzp(n - n2);
            zzfg2.zzrj.zzm(zzfg2.zzgs - zzfg2.zzgr);
            zzbz zzbz2 = (zzbz)zzfg2.zzrj.zza(zzdp2, zzbm.zzco());
            this.zzl(this.zzgz);
            return (T)zzbz2;
        }
        catch (zzcf zzcf2) {
            throw new zzfo("", zzcf2);
        }
    }

    private final void zzcb() {
        this.zzrh += this.zzgx;
        int n = this.zzrh;
        if (n > this.zzha) {
            this.zzgx = n - this.zzha;
            this.zzrh -= this.zzgx;
            return;
        }
        this.zzgx = 0;
    }

    public final int getPosition() {
        return this.zzri - this.zzrf;
    }

    public final byte[] zzr(int n, int n2) {
        if (n2 == 0) {
            return zzfs.zzsf;
        }
        byte[] byArray = new byte[n2];
        int n3 = this.zzrf + n;
        System.arraycopy(this.buffer, n3, byArray, 0, n2);
        return byArray;
    }

    public final void zzaw(int n) {
        this.zzs(n, this.zzgz);
    }

    final void zzs(int n, int n2) {
        if (n > this.zzri - this.zzrf) {
            int n3 = this.zzri - this.zzrf;
            throw new IllegalArgumentException(new StringBuilder(50).append("Position ").append(n).append(" is beyond current ").append(n3).toString());
        }
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Bad position ").append(n).toString());
        }
        this.zzri = this.zzrf + n;
        this.zzgz = n2;
    }

    private final byte zzcc() throws IOException {
        if (this.zzri == this.zzrh) {
            throw zzfo.zzfp();
        }
        return this.buffer[this.zzri++];
    }

    private final void zzp(int n) throws IOException {
        if (n < 0) {
            throw zzfo.zzfq();
        }
        if (this.zzri + n > this.zzha) {
            this.zzp(this.zzha - this.zzri);
            throw zzfo.zzfp();
        }
        if (n <= this.zzrh - this.zzri) {
            this.zzri += n;
            return;
        }
        throw zzfo.zzfp();
    }
}

