/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.clearcut.ClearcutLogger;
import com.google.android.gms.internal.firebase-perf.zzaa;
import com.google.android.gms.internal.firebase-perf.zzab;
import com.google.android.gms.internal.firebase-perf.zzac;
import com.google.android.gms.internal.firebase-perf.zzad;
import com.google.android.gms.internal.firebase-perf.zzaf;
import com.google.android.gms.internal.firebase-perf.zzah;
import com.google.android.gms.internal.firebase-perf.zzai;
import com.google.android.gms.internal.firebase-perf.zzd;
import com.google.android.gms.internal.firebase-perf.zzf;
import com.google.android.gms.internal.firebase-perf.zzfo;
import com.google.android.gms.internal.firebase-perf.zzfp;
import com.google.android.gms.internal.firebase-perf.zzh;
import com.google.android.gms.internal.firebase-perf.zzi;
import com.google.android.gms.internal.firebase-perf.zzj;
import com.google.android.gms.internal.firebase-perf.zzk;
import com.google.android.gms.internal.firebase-perf.zzl;
import com.google.android.gms.internal.firebase-perf.zzm;
import com.google.android.gms.internal.firebase-perf.zzn;
import com.google.android.gms.internal.firebase-perf.zzq;
import com.google.android.gms.internal.firebase-perf.zzu;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.perf.FirebasePerformance;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class zzg {
    private static volatile zzg zzax;
    private final ThreadPoolExecutor zzay;
    private FirebaseApp zzaz;
    private FirebasePerformance zzba;
    private Context mContext;
    private ClearcutLogger zzbb;
    private String zzbc;
    private zzac zzaw;
    private zzq zzbd;
    private zzd zzat;
    private boolean zzbe;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static zzg zzo() {
        if (zzax != null) return zzax;
        Class<zzg> clazz = zzg.class;
        synchronized (zzg.class) {
            if (zzax != null) return zzax;
            try {
                FirebaseApp.getInstance();
            }
            catch (IllegalStateException illegalStateException) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            zzax = new zzg(threadPoolExecutor);
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzax;
        }
    }

    private zzg(@NonNull ThreadPoolExecutor threadPoolExecutor) {
        this.zzay = threadPoolExecutor;
        this.zzay.execute(new zzh(this));
    }

    public final void zza(@NonNull zzai zzai2, int n) {
        try {
            byte[] byArray = zzfp.zzb(zzai2);
            zzai zzai3 = new zzai();
            zzfp.zza(zzai3, byArray);
            this.zzay.execute(new zzi(this, zzai3, n));
            return;
        }
        catch (zzfo zzfo2) {
            String string = String.valueOf(zzfo2);
            Log.w((String)"FirebasePerformance", (String)new StringBuilder(35 + String.valueOf(string).length()).append("Clone TraceMetric throws exception ").append(string).toString());
            return;
        }
    }

    public final void zza(@NonNull zzaf zzaf2, int n) {
        try {
            byte[] byArray = zzfp.zzb(zzaf2);
            zzaf zzaf3 = new zzaf();
            zzfp.zza(zzaf3, byArray);
            this.zzay.execute(new zzj(this, zzaf3, n));
            return;
        }
        catch (zzfo zzfo2) {
            Log.w((String)"FirebasePerformance", (String)"Clone NetworkRequestMetric throws exception", (Throwable)zzfo2);
            return;
        }
    }

    public final void zzb(boolean bl) {
        this.zzay.execute(new zzk(this, bl));
    }

    private final void zzp() {
        this.zzaz = FirebaseApp.getInstance();
        this.zzba = FirebasePerformance.getInstance();
        this.mContext = this.zzaz.getApplicationContext();
        this.zzbc = this.zzaz.getOptions().getApplicationId();
        this.zzaw = new zzac();
        this.zzaw.zzet = this.zzbc;
        this.zzaw.zzeu = this.zzq();
        this.zzaw.zzev = new zzab();
        this.zzaw.zzev.packageName = this.mContext.getPackageName();
        this.zzaw.zzev.zzes = "1.0.0.196558987";
        this.zzaw.zzev.versionName = zzg.zzd(this.mContext);
        try {
            this.zzbb = ClearcutLogger.anonymousLogger((Context)this.mContext, (String)"FIREPERF");
        }
        catch (SecurityException securityException) {
            Log.i((String)"FirebasePerformance", (String)"Caught SecurityException while init ClearcutLogger.");
            this.zzbb = null;
        }
        this.zzbd = new zzq(this.mContext, this.zzbc, 100L, 500L);
        this.zzat = zzd.zzg();
        this.zzbe = zzaa.zzf(this.mContext);
    }

    private final void zza(@NonNull zzah zzah2) {
        if (this.zzbb == null) {
            return;
        }
        if (this.zzba.isPerformanceCollectionEnabled()) {
            boolean bl;
            zzg zzg2;
            block16: {
                ArrayList<zzn> arrayList;
                zzg2 = this;
                if (zzg2.zzaw.zzeu == null || zzg2.zzaw.zzeu.isEmpty()) {
                    zzg2.zzaw.zzeu = zzg2.zzq();
                }
                if (zzg2.zzaw.zzeu == null || zzg2.zzaw.zzeu.isEmpty()) {
                    Log.w((String)"FirebasePerformance", (String)"App Instance ID is null or empty, dropping the log.");
                    return;
                }
                Context context = this.mContext;
                zzah zzah3 = zzah2;
                Context context2 = context;
                zzah zzah4 = zzah3;
                ArrayList<zzn> arrayList2 = new ArrayList<zzn>();
                if (zzah4.zzfq != null) {
                    arrayList2.add(new zzm(zzah4.zzfq));
                }
                if (zzah4.zzfr != null) {
                    arrayList2.add(new zzl(zzah4.zzfr, context2));
                }
                if (zzah4.zzfp != null) {
                    arrayList2.add(new zzf(zzah4.zzfp));
                }
                if ((arrayList = arrayList2).isEmpty()) {
                    Log.d((String)"FirebasePerformance", (String)"No validators found for PerfMetric.");
                    bl = false;
                } else {
                    ArrayList<zzn> arrayList3 = arrayList;
                    int n = arrayList3.size();
                    Object var8_12 = null;
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList3.get(i);
                        if (((zzn)e).zzn()) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                Log.i((String)"FirebasePerformance", (String)"Unable to process an HTTP request/response due to missing or invalid values. See earlier log statements for additional information on the specific invalid/missing values.");
                return;
            }
            if (!this.zzbd.zzb(zzah2)) {
                zzah zzah5 = zzah2;
                zzg2 = this;
                if (zzah5.zzfr != null) {
                    zzg2.zzat.zza(zzu.zzea.toString(), 1L);
                    return;
                }
                if (zzah5.zzfq != null) {
                    zzg2.zzat.zza(zzu.zzdz.toString(), 1L);
                }
                return;
            }
            byte[] byArray = zzfp.zzb(zzah2);
            try {
                this.zzbb.newEvent(byArray).log();
                return;
            }
            catch (SecurityException securityException) {}
        }
    }

    private final void zzb(@NonNull zzai zzai2, int n) {
        if (this.zzba.isPerformanceCollectionEnabled()) {
            if (this.zzbe) {
                long l = zzai2.zzfu == null ? 0L : zzai2.zzfu;
                Log.i((String)"FirebasePerformance", (String)String.format("Logging TraceMetric - %s %dms", zzai2.name, l / 1000L));
            }
            zzah zzah2 = new zzah();
            new zzah().zzfp = this.zzaw;
            zzah2.zzfp.zzex = n;
            zzah2.zzfq = zzai2;
            zzah zzah3 = zzah2;
            Map<String, String> map = FirebasePerformance.getInstance().getAttributes();
            if (!map.isEmpty()) {
                zzah3.zzfp.zzey = new zzad[map.size()];
                int n2 = 0;
                for (String string : map.keySet()) {
                    String string2 = map.get(string);
                    zzad zzad2 = new zzad();
                    new zzad().key = string;
                    zzad2.value = string2;
                    zzah3.zzfp.zzey[n2++] = zzad2;
                }
            }
            this.zza(zzah2);
        }
    }

    private final void zzb(@NonNull zzaf zzaf2, int n) {
        if (this.zzba.isPerformanceCollectionEnabled()) {
            if (this.zzbe) {
                long l = zzaf2.zzfm == null ? 0L : zzaf2.zzfm;
                long l2 = zzaf2.zzff == null ? 0L : zzaf2.zzff;
                Log.i((String)"FirebasePerformance", (String)String.format("Logging NetworkRequestMetric - %s %db %dms,", zzaf2.url, l2, l / 1000L));
            }
            zzah zzah2 = new zzah();
            new zzah().zzfp = this.zzaw;
            zzah2.zzfp.zzex = n;
            zzah2.zzfr = zzaf2;
            this.zza(zzah2);
        }
    }

    public final void zzc(boolean bl) {
        this.zzbd.zzb(bl);
    }

    private static String zzd(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return "";
        }
    }

    private final String zzq() {
        if (this.zzba.isPerformanceCollectionEnabled()) {
            return FirebaseInstanceId.getInstance().getId();
        }
        return null;
    }

    static /* synthetic */ void zzb(zzg zzg2) {
        zzg2.zzp();
    }

    static /* synthetic */ void zza(zzg zzg2, zzai zzai2, int n) {
        zzg2.zzb(zzai2, n);
    }

    static /* synthetic */ void zza(zzg zzg2, zzaf zzaf2, int n) {
        zzg2.zzb(zzaf2, n);
    }
}

