/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzaf;
import com.google.android.gms.internal.firebase-perf.zzn;
import com.google.android.gms.internal.firebase-perf.zzy;
import java.net.URI;

final class zzl
extends zzn {
    private final zzaf zzbk;
    private final Context zzbl;

    zzl(@NonNull zzaf zzaf2, Context context) {
        this.zzbl = context;
        this.zzbk = zzaf2;
    }

    @Override
    public final boolean zzn() {
        String string = this.zzbk.url;
        if (zzl.zze(string)) {
            String string2 = String.valueOf(this.zzbk.url);
            Log.i((String)"FirebasePerformance", (String)(string2.length() != 0 ? "URL is missing:".concat(string2) : new String("URL is missing:")));
            return false;
        }
        URI uRI = zzl.zzd(this.zzbk.url);
        if (uRI == null) {
            Log.i((String)"FirebasePerformance", (String)"URL cannot be parsed");
            return false;
        }
        string = this.zzbl;
        Object object = uRI;
        if (!(object == null ? false : zzy.zza((URI)object, (Context)string))) {
            String string3 = String.valueOf(uRI);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(26 + String.valueOf(string3).length()).append("URL fails whitelist rule: ").append(string3).toString());
            return false;
        }
        string = uRI.getHost();
        if (!(string != null && !zzl.zze(string) && string.length() <= 255)) {
            Log.i((String)"FirebasePerformance", (String)"URL host is null or invalid");
            return false;
        }
        object = uRI.getScheme();
        if (!(object != null && ("http".equalsIgnoreCase((String)object) || "https".equalsIgnoreCase((String)object)))) {
            Log.i((String)"FirebasePerformance", (String)"URL scheme is null or invalid");
            return false;
        }
        if (!(uRI.getUserInfo() == null)) {
            Log.i((String)"FirebasePerformance", (String)"URL user info is null");
            return false;
        }
        int n = uRI.getPort();
        if (!(n == -1 || n > 0)) {
            Log.i((String)"FirebasePerformance", (String)"URL port is less than or equal to 0");
            return false;
        }
        Object object2 = this.zzbk.zzfd;
        if (!(object2 != null && (Integer)object2 != 0)) {
            String string4 = String.valueOf(this.zzbk.zzfd);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(32 + String.valueOf(string4).length()).append("HTTP Method is null or invalid: ").append(string4).toString());
            return false;
        }
        if (this.zzbk.zzfh != null && !(this.zzbk.zzfh > 0)) {
            String string5 = String.valueOf(this.zzbk.zzfh);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(38 + String.valueOf(string5).length()).append("HTTP ResponseCode is a negative value:").append(string5).toString());
            return false;
        }
        if (this.zzbk.zzfe != null && !zzl.zzh(this.zzbk.zzfe)) {
            String string6 = String.valueOf(this.zzbk.zzfe);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(36 + String.valueOf(string6).length()).append("Request Payload is a negative value:").append(string6).toString());
            return false;
        }
        if (this.zzbk.zzff != null && !zzl.zzh(this.zzbk.zzff)) {
            String string7 = String.valueOf(this.zzbk.zzff);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(37 + String.valueOf(string7).length()).append("Response Payload is a negative value:").append(string7).toString());
            return false;
        }
        if (this.zzbk.zzfj == null || this.zzbk.zzfj <= 0L) {
            String string8 = String.valueOf(this.zzbk.zzfj);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(64 + String.valueOf(string8).length()).append("Start time of the request is null, or zero, or a negative value:").append(string8).toString());
            return false;
        }
        if (this.zzbk.zzfk != null && !zzl.zzg(this.zzbk.zzfk)) {
            String string9 = String.valueOf(this.zzbk.zzfk);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(49 + String.valueOf(string9).length()).append("Time to complete the request is a negative value:").append(string9).toString());
            return false;
        }
        if (this.zzbk.zzfl != null && !zzl.zzg(this.zzbk.zzfl)) {
            String string10 = String.valueOf(this.zzbk.zzfl);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(92 + String.valueOf(string10).length()).append("Time from the start of the request to the start of the response is null or a negative value:").append(string10).toString());
            return false;
        }
        if (this.zzbk.zzfm == null || this.zzbk.zzfm <= 0L) {
            String string11 = String.valueOf(this.zzbk.zzfm);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(88 + String.valueOf(string11).length()).append("Time from the start of the request to the end of the response is null, negative or zero:").append(string11).toString());
            return false;
        }
        if (this.zzbk.zzfh == null) {
            Log.i((String)"FirebasePerformance", (String)"Did not receive a HTTP Response Code");
            return false;
        }
        if (this.zzbk.zzfi != null) {
            boolean bl;
            block21: {
                object2 = this.zzbk.zzfi;
                if (((String)object2).length() > 128) {
                    bl = false;
                } else {
                    for (int i = 0; i < ((String)object2).length(); ++i) {
                        char c = ((String)object2).charAt(i);
                        if (c > '\u001f' && c <= '\u007f') continue;
                        bl = false;
                        break block21;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                String string12 = String.valueOf(this.zzbk.zzfi);
                Log.i((String)"FirebasePerformance", (String)(string12.length() != 0 ? "The content type of the response is not a valid content-type:".concat(string12) : new String("The content type of the response is not a valid content-type:")));
                this.zzbk.zzfi = null;
            }
        }
        return true;
    }

    @Nullable
    private static URI zzd(@Nullable String string) {
        if (string == null) {
            return null;
        }
        try {
            return URI.create(string);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            Log.w((String)"FirebasePerformance", (String)"getResultUrl throws exception", (Throwable)runtimeException);
            return null;
        }
    }

    private static boolean zzg(long l) {
        return l >= 0L;
    }

    private static boolean zzh(long l) {
        return l >= 0L;
    }

    private static boolean zze(@Nullable String string) {
        if (string == null) {
            return true;
        }
        return string.trim().isEmpty();
    }
}

