/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.firebase-perf.zzo;
import com.google.android.gms.internal.firebase-perf.zzu;
import java.util.AbstractMap;
import java.util.Locale;

public abstract class zzn {
    public static String zza(@Nullable String string, int n) {
        if (string == null) {
            switch (zzo.zzbn[n - 1]) {
                case 1: {
                    return "Counter name must not be null";
                }
                case 2: {
                    return "Metric name must not be null";
                }
            }
        } else if (string.length() > 100) {
            switch (zzo.zzbn[n - 1]) {
                case 1: {
                    return String.format(Locale.US, "Counter name must not exceed %d characters", 100);
                }
                case 2: {
                    return String.format(Locale.US, "Metric name must not exceed %d characters", 100);
                }
            }
        } else if (string.startsWith("_")) {
            zzu[] zzuArray = zzu.values();
            int n2 = zzuArray.length;
            for (int i = 0; i < n2; ++i) {
                if (!zzuArray[i].toString().equals(string)) continue;
                return null;
            }
            switch (zzo.zzbn[n - 1]) {
                case 1: {
                    return "Counter name must not start with '_'";
                }
                case 2: {
                    return "Metric name must not start with '_'";
                }
            }
        }
        return null;
    }

    public static String zza(@NonNull AbstractMap.SimpleEntry<String, String> simpleEntry) {
        String string = simpleEntry.getKey();
        String string2 = simpleEntry.getValue();
        if (string == null) {
            return "Attribute key must not be null";
        }
        if (string2 == null) {
            return "Attribute value must not be null";
        }
        if (string.length() > 40) {
            return String.format(Locale.US, "Attribute key length must not exceed %d characters", 40);
        }
        if (string2.length() > 100) {
            return String.format(Locale.US, "Attribute value length must not exceed %d characters", 100);
        }
        if (!string.matches("^(?!(firebase_|google_|ga_))[A-Za-z][A-Za-z_0-9]*")) {
            return "Attribute key must start with letter, must only contain alphanumeric characters and underscore and must not start with \"firebase_\", \"google_\" and \"ga_";
        }
        return null;
    }

    public abstract boolean zzn();
}

