/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzg;
import com.google.android.gms.internal.firebase-perf.zzw;
import com.google.firebase.FirebaseApp;
import com.google.firebase.perf.metrics.HttpMetric;
import com.google.firebase.perf.metrics.Trace;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FirebasePerformance {
    public static final int MAX_TRACE_NAME_LENGTH = 100;
    private static volatile FirebasePerformance zzm;
    private final Map<String, String> zzn = new ConcurrentHashMap<String, String>();
    private boolean zzo = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirebasePerformance getInstance() {
        if (zzm != null) return zzm;
        Class<FirebasePerformance> clazz = FirebasePerformance.class;
        synchronized (FirebasePerformance.class) {
            if (zzm != null) return zzm;
            zzm = (FirebasePerformance)FirebaseApp.getInstance().get(FirebasePerformance.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzm;
        }
    }

    public FirebasePerformance(FirebaseApp firebaseApp) {
        if (firebaseApp == null) {
            this.zzo = false;
            return;
        }
        Context context = firebaseApp.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("FirebasePerfSharedPrefs", 0);
        this.zzo = FirebasePerformance.zza(context, sharedPreferences);
    }

    @NonNull
    public static Trace startTrace(@NonNull String string) {
        Trace trace = Trace.zzh(string);
        trace.start();
        return trace;
    }

    public void setPerformanceCollectionEnabled(boolean bl) {
        SharedPreferences sharedPreferences;
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        SharedPreferences sharedPreferences2 = sharedPreferences = context.getSharedPreferences("FirebasePerfSharedPrefs", 0);
        Context context2 = context;
        FirebasePerformance firebasePerformance = this;
        if (!FirebasePerformance.zzb(context2)) {
            sharedPreferences2.edit().putBoolean("isEnabled", bl).apply();
            firebasePerformance.zzo = bl;
            if (bl) {
                Log.i((String)"FirebasePerformance", (String)"Firebase Performance is Enabled");
                return;
            }
            Log.i((String)"FirebasePerformance", (String)"Firebase Performance is Disabled");
            return;
        }
        Log.i((String)"FirebasePerformance", (String)"Firebase Performance is permanently disabled");
    }

    public boolean isPerformanceCollectionEnabled() {
        return this.zzo;
    }

    @NonNull
    public final Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzn);
    }

    private static boolean zza(@NonNull Context context, @NonNull SharedPreferences sharedPreferences) {
        if (FirebasePerformance.zzb(context)) {
            return false;
        }
        try {
            if (sharedPreferences.contains("isEnabled")) {
                return sharedPreferences.getBoolean("isEnabled", true);
            }
        }
        catch (ClassCastException classCastException) {
            String string = String.valueOf(classCastException.getMessage());
            Log.d((String)"FirebasePerformance", (String)(string.length() != 0 ? "Unable to access enable value: ".concat(string) : new String("Unable to access enable value: ")));
        }
        return FirebasePerformance.zza(context);
    }

    @NonNull
    public Trace newTrace(@NonNull String string) {
        return Trace.zzh(string);
    }

    @NonNull
    public HttpMetric newHttpMetric(@NonNull String string, String string2) {
        return new HttpMetric(string, string2, zzg.zzo(), new zzw());
    }

    @NonNull
    public HttpMetric newHttpMetric(@NonNull URL uRL, String string) {
        return new HttpMetric(uRL, string, zzg.zzo(), new zzw());
    }

    private static boolean zza(@NonNull Context context) {
        try {
            return context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData.getBoolean("firebase_performance_collection_enabled", true);
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            String string = String.valueOf(throwable.getMessage());
            Log.d((String)"isEnabled", (String)(string.length() != 0 ? "No perf enable meta data found ".concat(string) : new String("No perf enable meta data found ")));
            return true;
        }
    }

    private static boolean zzb(@NonNull Context context) {
        try {
            return context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData.getBoolean("firebase_performance_collection_deactivated", false);
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            String string = String.valueOf(throwable.getMessage());
            Log.d((String)"isEnabled", (String)(string.length() != 0 ? "No perf enable meta data found ".concat(string) : new String("No perf enable meta data found ")));
            return false;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HttpMethod {
        public static final String GET = "GET";
        public static final String PUT = "PUT";
        public static final String POST = "POST";
        public static final String DELETE = "DELETE";
        public static final String HEAD = "HEAD";
        public static final String PATCH = "PATCH";
        public static final String OPTIONS = "OPTIONS";
        public static final String TRACE = "TRACE";
        public static final String CONNECT = "CONNECT";
    }
}

