/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzai;
import com.google.android.gms.internal.firebase-perf.zzg;
import com.google.android.gms.internal.firebase-perf.zzt;
import com.google.android.gms.internal.firebase-perf.zzv;
import com.google.android.gms.internal.firebase-perf.zzw;
import com.google.firebase.perf.provider.FirebasePerfProvider;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;

public class AppStartTrace
implements Application.ActivityLifecycleCallbacks {
    private static final long zzco = TimeUnit.MINUTES.toMicros(1L);
    private static volatile AppStartTrace zzcp;
    private boolean mRegistered = false;
    private zzg zzq = null;
    private final zzt zzah;
    private Context zzcq;
    private WeakReference<Activity> zzcr;
    private WeakReference<Activity> zzcs;
    private boolean zzct = false;
    private zzw zzcu = null;
    private zzw zzcv = null;
    private zzw zzcw = null;
    private boolean zzcx = false;

    @Keep
    public static void setLauncherActivityOnCreateTime(String string) {
    }

    @Keep
    public static void setLauncherActivityOnStartTime(String string) {
    }

    @Keep
    public static void setLauncherActivityOnResumeTime(String string) {
    }

    public static AppStartTrace zzaa() {
        if (zzcp != null) {
            return zzcp;
        }
        return AppStartTrace.zzb(null, new zzt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AppStartTrace zzb(zzg zzg2, zzt zzt2) {
        if (zzcp != null) return zzcp;
        Class<AppStartTrace> clazz = AppStartTrace.class;
        synchronized (AppStartTrace.class) {
            if (zzcp != null) return zzcp;
            zzcp = new AppStartTrace(null, zzt2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzcp;
        }
    }

    private AppStartTrace(@Nullable zzg zzg2, @NonNull zzt zzt2) {
        this.zzah = zzt2;
    }

    public final synchronized void zzc(@NonNull Context context) {
        if (this.mRegistered) {
            return;
        }
        Context context2 = context.getApplicationContext();
        if (context2 instanceof Application) {
            ((Application)context2).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mRegistered = true;
            this.zzcq = context2;
        }
    }

    private final synchronized void zzab() {
        if (!this.mRegistered) {
            return;
        }
        ((Application)this.zzcq).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.mRegistered = false;
    }

    public synchronized void onActivityCreated(Activity activity, Bundle bundle) {
        if (this.zzcx || this.zzcu != null) {
            return;
        }
        this.zzcr = new WeakReference<Activity>(activity);
        this.zzcu = new zzw();
        if (FirebasePerfProvider.zzai().zza(this.zzcu) > zzco) {
            this.zzct = true;
        }
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.zzcx || this.zzcv != null || this.zzct) {
            return;
        }
        this.zzcv = new zzw();
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.zzcx || this.zzcw != null || this.zzct) {
            return;
        }
        this.zzcs = new WeakReference<Activity>(activity);
        this.zzcw = new zzw();
        zzw zzw2 = FirebasePerfProvider.zzai();
        Object object = activity.getClass().getName();
        long l = zzw2.zza(this.zzcw);
        Log.d((String)"FirebasePerformance", (String)new StringBuilder(30 + String.valueOf(object).length()).append("onResume ").append((String)object).append(":").append(l).toString());
        object = new zzai();
        new zzai().name = zzv.zzeg.toString();
        ((zzai)object).zzfj = zzw2.zzaj();
        ((zzai)object).zzfu = zzw2.zza(this.zzcw);
        zzai[] zzaiArray = new zzai[3];
        zzai zzai2 = new zzai();
        new zzai().name = zzv.zzeh.toString();
        zzai2.zzfj = zzw2.zzaj();
        zzai2.zzfu = zzw2.zza(this.zzcu);
        zzaiArray[0] = zzai2;
        zzai2 = new zzai();
        new zzai().name = zzv.zzei.toString();
        zzai2.zzfj = this.zzcu.zzaj();
        zzai2.zzfu = this.zzcu.zza(this.zzcv);
        zzaiArray[1] = zzai2;
        zzai2 = new zzai();
        new zzai().name = zzv.zzej.toString();
        zzai2.zzfj = this.zzcv.zzaj();
        zzai2.zzfu = this.zzcv.zza(this.zzcw);
        zzaiArray[2] = zzai2;
        ((zzai)object).zzfw = zzaiArray;
        if (this.zzq == null) {
            this.zzq = zzg.zzo();
        }
        if (this.zzq != null) {
            this.zzq.zza((zzai)object, 3);
        }
        if (this.mRegistered) {
            this.zzab();
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public synchronized void onActivityStopped(Activity activity) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    static /* synthetic */ boolean zza(AppStartTrace appStartTrace, boolean bl) {
        appStartTrace.zzcx = true;
        return true;
    }

    public static final class zza
    implements Runnable {
        private final AppStartTrace zzcy;

        public zza(AppStartTrace appStartTrace) {
            this.zzcy = appStartTrace;
        }

        @Override
        public final void run() {
            if (this.zzcy.zzcu == null) {
                AppStartTrace.zza(this.zzcy, true);
            }
        }
    }
}

