/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzc;
import com.google.android.gms.internal.firebase-perf.zzg;
import com.google.android.gms.internal.firebase-perf.zzn;
import com.google.android.gms.internal.firebase-perf.zzw;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpMetric {
    private zzc zzda;
    private zzw zzdb;
    private final Map<String, String> zzdc;
    private boolean zzdd = false;

    public HttpMetric(String string, String string2, zzg zzg2, zzw zzw2) {
        this.zzda = zzc.zza(zzg2);
        this.zzda.zza(string);
        this.zzda.zzb(string2);
        this.zzdb = zzw2;
        this.zzda.zzb();
        this.zzdc = new ConcurrentHashMap<String, String>();
    }

    public HttpMetric(URL uRL, String string, zzg zzg2, zzw zzw2) {
        this.zzda = zzc.zza(zzg2);
        this.zzda.zza(uRL.toString());
        this.zzda.zzb(string);
        this.zzdb = zzw2;
        this.zzda.zzb();
        this.zzdc = new ConcurrentHashMap<String, String>();
    }

    public void setHttpResponseCode(int n) {
        this.zzda.zza(n);
    }

    public void setRequestPayloadSize(long l) {
        this.zzda.zza(l);
    }

    public void setResponsePayloadSize(long l) {
        this.zzda.zzb(l);
    }

    public void setResponseContentType(@Nullable String string) {
        this.zzda.zzc(string);
    }

    public void start() {
        this.zzdb.reset();
        this.zzda.zzc(this.zzdb.zzaj());
    }

    public void stop() {
        this.zzda.zzf(this.zzdb.zzak());
        this.zzda.zza(this.zzdc);
        this.zzda.zzf();
        this.zzdd = true;
    }

    public void putAttribute(@NonNull String string, @NonNull String string2) {
        boolean bl = true;
        try {
            string = string.trim();
            String string3 = string2 = string2.trim();
            String string4 = string;
            HttpMetric httpMetric = this;
            if (httpMetric.zzdd) {
                throw new IllegalArgumentException("HttpMetric has been logged already so unable to modify attributes");
            }
            if (string4 == null || string3 == null) {
                throw new IllegalArgumentException("Attribute must not have null key or value.");
            }
            if (!httpMetric.zzdc.containsKey(string4) && httpMetric.zzdc.size() >= 5) {
                throw new IllegalArgumentException(String.format(Locale.US, "Exceeds max limit of number of attributes - %d", 5));
            }
            String string5 = zzn.zza(new AbstractMap.SimpleEntry<String, String>(string4, string3));
            if (string5 != null) {
                throw new IllegalArgumentException(string5);
            }
        }
        catch (Exception exception) {
            Log.e((String)"FirebasePerformance", (String)String.format("Can not set attribute %s with value %s (%s)", string, string2, exception.getMessage()));
            bl = false;
        }
        if (bl) {
            this.zzdc.put(string, string2);
        }
    }

    public void removeAttribute(@NonNull String string) {
        if (this.zzdd) {
            Log.e((String)"FirebasePerformance", (String)"Can't remove a attribute from a HttpMetric that's stopped.");
            return;
        }
        this.zzdc.remove(string);
    }

    @Nullable
    public String getAttribute(@NonNull String string) {
        return this.zzdc.get(string);
    }

    @NonNull
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzdc);
    }
}

