/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zzg;
import com.google.android.gms.internal.firebase-perf.zzn;
import com.google.android.gms.internal.firebase-perf.zzp;
import com.google.android.gms.internal.firebase-perf.zzt;
import com.google.android.gms.internal.firebase-perf.zzv;
import com.google.android.gms.internal.firebase-perf.zzw;
import com.google.firebase.perf.metrics.zza;
import com.google.firebase.perf.metrics.zzc;
import com.google.firebase.perf.metrics.zzd;
import com.google.firebase.perf.metrics.zze;
import com.google.firebase.perf.metrics.zzf;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Trace
extends com.google.android.gms.internal.firebase-perf.zze
implements Parcelable {
    private static final Map<String, Trace> zzde = new ConcurrentHashMap<String, Trace>();
    private final Trace zzdf;
    private final String mName;
    private final List<Trace> zzdg;
    private final Map<String, zza> zzam;
    private final zzt zzah;
    private final zzg zzax;
    private final Map<String, String> zzdc;
    private zzw zzdh;
    private zzw zzdi;
    @Keep
    public static final Parcelable.Creator<Trace> CREATOR = new zzc();
    @VisibleForTesting
    private static final Parcelable.Creator<Trace> zzdj = new zzd();

    @NonNull
    public static Trace zzh(@NonNull String string) {
        return new Trace(string);
    }

    private Trace(@NonNull String string) {
        this(string, zzg.zzo(), new zzt(), com.google.android.gms.internal.firebase-perf.zzd.zzg());
    }

    public Trace(@NonNull String string, @NonNull zzg zzg2, @NonNull zzt zzt2, @NonNull com.google.android.gms.internal.firebase-perf.zzd zzd2) {
        super(zzd2);
        this.zzdf = null;
        this.mName = string.trim();
        this.zzdg = new ArrayList<Trace>();
        this.zzam = new ConcurrentHashMap<String, zza>();
        this.zzdc = new ConcurrentHashMap<String, String>();
        this.zzah = zzt2;
        this.zzax = zzg2;
    }

    /*
     * Unable to fully structure code
     */
    @Keep
    public void start() {
        block7: {
            block8: {
                block6: {
                    var2_1 = this.mName;
                    if (var2_1 != null) break block6;
                    v0 = "Trace name must not be null";
                    break block7;
                }
                if (var2_1.length() <= 100) break block8;
                v0 = String.format(Locale.US, "Trace name must not exceed %d characters", new Object[]{100});
                break block7;
            }
            if (!var2_1.startsWith("_")) ** GOTO lbl-1000
            var3_2 = zzv.values();
            var4_3 = var3_2.length;
            for (var5_4 = 0; var5_4 < var4_3; ++var5_4) {
                if (!var3_2[var5_4].toString().equals(var2_1)) {
                    continue;
                }
                ** GOTO lbl-1000
            }
            if (!var2_1.startsWith("_st_")) {
                v0 = "Trace name must not start with '_'";
            } else lbl-1000:
            // 3 sources

            {
                v0 = var1_5 = null;
            }
        }
        if (v0 != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Cannot start trace %s. Trace name is invalid.(%s)", new Object[]{this.mName, var1_5}));
            return;
        }
        if (this.zzdh != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has already started, should not start again!", new Object[]{this.mName}));
            return;
        }
        this.zzdh = new zzw();
        this.zzl();
    }

    @Keep
    public void stop() {
        if (!this.hasStarted()) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has not been started so unable to stop!", this.mName));
            return;
        }
        if (this.isStopped()) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has already stopped, should not stop again!", this.mName));
            return;
        }
        this.zzm();
        this.zzdi = new zzw();
        if (this.zzdf == null) {
            zzw zzw2 = this.zzdi;
            Trace trace = this;
            if (!trace.zzdg.isEmpty()) {
                int n = trace.zzdg.size() - 1;
                Trace trace2 = trace.zzdg.get(n);
                if (trace2.zzdi == null) {
                    trace2.zzdi = zzw2;
                }
            }
            if (!this.mName.isEmpty()) {
                if (this.zzax != null) {
                    this.zzax.zza(new zzf(this).zzag(), this.zzh());
                    return;
                }
            } else {
                Log.e((String)"FirebasePerformance", (String)"Trace name is empty, no log is sent to server");
            }
        }
    }

    @NonNull
    private final zza zzi(@NonNull String string) {
        zza zza2 = this.zzam.get(string);
        if (zza2 == null) {
            zza2 = new zza(string);
            this.zzam.put(string, zza2);
        }
        return zza2;
    }

    @Deprecated
    @Keep
    public void incrementCounter(@NonNull String string, long l) {
        this.zza(string, l, zzp.zzbo);
    }

    private final void zza(String string, long l, int n) {
        String string2 = zzn.zza(string, n);
        if (string2 != null) {
            switch (zze.zzbn[n - 1]) {
                case 1: {
                    Log.e((String)"FirebasePerformance", (String)String.format("Cannot increment counter %s. Counter name is invalid.(%s)", string, string2));
                    return;
                }
                case 2: {
                    Log.e((String)"FirebasePerformance", (String)String.format("Cannot increment metric %s. Metric name is invalid.(%s)", string, string2));
                }
            }
            return;
        }
        if (!this.hasStarted()) {
            switch (zze.zzbn[n - 1]) {
                case 1: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment counter '%s' for trace '%s' because it's not started", string, this.mName));
                    return;
                }
                case 2: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment metric '%s' for trace '%s' because it's not started", string, this.mName));
                }
            }
            return;
        }
        if (this.isStopped()) {
            switch (zze.zzbn[n - 1]) {
                case 1: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment counter '%s' for trace '%s' because it's been stopped", string, this.mName));
                    return;
                }
                case 2: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment metric '%s' for trace '%s' because it's been stopped", string, this.mName));
                }
            }
            return;
        }
        this.zzi(string.trim()).zzi(l);
    }

    @Deprecated
    @Keep
    public void incrementCounter(@NonNull String string) {
        this.incrementCounter(string, 1L);
    }

    @Keep
    public void incrementMetric(@NonNull String string, long l) {
        this.zza(string, l, zzp.zzbp);
    }

    @Keep
    public long getLongMetric(@NonNull String string) {
        zza zza2 = null;
        if (string != null) {
            zza2 = this.zzam.get(string.trim());
        }
        if (zza2 == null) {
            return 0L;
        }
        return zza2.getCount();
    }

    @Keep
    public void putMetric(@NonNull String string, long l) {
        String string2 = zzn.zza(string, zzp.zzbp);
        if (string2 != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Cannot set value for metric %s. Metric name is invalid.(%s)", string, string2));
            return;
        }
        if (!this.hasStarted()) {
            Log.w((String)"FirebasePerformance", (String)String.format("Cannot set value for metric '%s' for trace '%s' because it's not started", string, this.mName));
            return;
        }
        if (this.isStopped()) {
            Log.w((String)"FirebasePerformance", (String)String.format("Cannot set value for metric '%s' for trace '%s' because it's been stopped", string, this.mName));
            return;
        }
        this.zzi(string.trim()).zzj(l);
    }

    protected void finalize() throws Throwable {
        try {
            Trace trace = this;
            if (trace.hasStarted() && !trace.isStopped()) {
                Log.w((String)"FirebasePerformance", (String)String.format("Trace '%s' is started but not stopped when it is destructed!", this.mName));
                this.zzb(1);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @VisibleForTesting
    @NonNull
    final String getName() {
        return this.mName;
    }

    @VisibleForTesting
    @NonNull
    final Map<String, zza> zzac() {
        return this.zzam;
    }

    @VisibleForTesting
    final zzw zzad() {
        return this.zzdh;
    }

    @VisibleForTesting
    final zzw zzae() {
        return this.zzdi;
    }

    @VisibleForTesting
    @NonNull
    final List<Trace> zzaf() {
        return this.zzdg;
    }

    @VisibleForTesting
    private final boolean isStopped() {
        return this.zzdi != null;
    }

    @VisibleForTesting
    private final boolean hasStarted() {
        return this.zzdh != null;
    }

    @Keep
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        parcel.writeParcelable((Parcelable)this.zzdf, 0);
        parcel.writeString(this.mName);
        parcel.writeList(this.zzdg);
        parcel.writeMap(this.zzam);
        parcel.writeParcelable((Parcelable)this.zzdh, 0);
        parcel.writeParcelable((Parcelable)this.zzdi, 0);
    }

    private Trace(@NonNull Parcel parcel, boolean bl) {
        super(bl ? null : com.google.android.gms.internal.firebase-perf.zzd.zzg());
        this.zzdf = (Trace)parcel.readParcelable(Trace.class.getClassLoader());
        this.mName = parcel.readString();
        this.zzdg = new ArrayList<Trace>();
        parcel.readList(this.zzdg, Trace.class.getClassLoader());
        this.zzam = new ConcurrentHashMap<String, zza>();
        this.zzdc = new ConcurrentHashMap<String, String>();
        parcel.readMap(this.zzam, zza.class.getClassLoader());
        this.zzdh = (zzw)parcel.readParcelable(zzw.class.getClassLoader());
        this.zzdi = (zzw)parcel.readParcelable(zzw.class.getClassLoader());
        if (bl) {
            this.zzax = null;
            this.zzah = null;
            return;
        }
        this.zzax = zzg.zzo();
        this.zzah = new zzt();
    }

    @Keep
    public void putAttribute(@NonNull String string, @NonNull String string2) {
        boolean bl = true;
        try {
            string = string.trim();
            String string3 = string2 = string2.trim();
            String string4 = string;
            Trace trace = this;
            if (trace.isStopped()) {
                throw new IllegalArgumentException(String.format(Locale.US, "Trace %s has been stopped", trace.mName));
            }
            if (!trace.zzdc.containsKey(string4) && trace.zzdc.size() >= 5) {
                throw new IllegalArgumentException(String.format(Locale.US, "Exceeds max limit of number of attributes - %d", 5));
            }
            String string5 = zzn.zza(new AbstractMap.SimpleEntry<String, String>(string4, string3));
            if (string5 != null) {
                throw new IllegalArgumentException(string5);
            }
        }
        catch (Exception exception) {
            Log.e((String)"FirebasePerformance", (String)String.format("Can not set attribute %s with value %s (%s)", string, string2, exception.getMessage()));
            bl = false;
        }
        if (bl) {
            this.zzdc.put(string, string2);
        }
    }

    @Keep
    public void removeAttribute(@NonNull String string) {
        if (this.isStopped()) {
            Log.e((String)"FirebasePerformance", (String)"Can't remove a attribute from a Trace that's stopped.");
            return;
        }
        this.zzdc.remove(string);
    }

    @Nullable
    @Keep
    public String getAttribute(@NonNull String string) {
        return this.zzdc.get(string);
    }

    @NonNull
    @Keep
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzdc);
    }

    @Keep
    public int describeContents() {
        return 0;
    }

    /* synthetic */ Trace(Parcel parcel, boolean bl, zzc zzc2) {
        this(parcel, bl);
    }
}

