/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzai;
import com.google.android.gms.internal.firebase-perf.zzao;
import com.google.android.gms.internal.firebase-perf.zzap;
import com.google.android.gms.internal.firebase-perf.zzbu;
import com.google.android.gms.internal.firebase-perf.zzeo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class zzan {
    private static final long zzat = TimeUnit.SECONDS.toMicros(1L);
    @Nullable
    private static zzan zzau = null;
    @Nullable
    private ScheduledFuture zzav = null;
    private final ScheduledExecutorService zzaw;
    private long zzax = -1L;
    private final long zzay;
    private final String zzaz;
    public final ConcurrentLinkedQueue<zzbu> zzba = new ConcurrentLinkedQueue();

    private zzan() {
        this.zzaw = Executors.newSingleThreadScheduledExecutor();
        int n = Process.myPid();
        String string = Integer.toString(n);
        this.zzaz = new StringBuilder(11 + String.valueOf(string).length()).append("/proc/").append(string).append("/stat").toString();
        this.zzay = Build.VERSION.SDK_INT >= 21 ? Os.sysconf((int)OsConstants._SC_CLK_TCK) : -1L;
    }

    public static zzan zzs() {
        if (zzau == null) {
            zzau = new zzan();
        }
        return zzau;
    }

    public final void zzb(long l) {
        if (this.zzay == -1L || this.zzay == 0L) {
            return;
        }
        if (l <= 0L) {
            return;
        }
        if (this.zzav != null) {
            if (this.zzax != l) {
                this.zzt();
                this.zzc(l);
            }
            return;
        }
        this.zzc(l);
    }

    public final void zzt() {
        if (this.zzav == null) {
            return;
        }
        this.zzav.cancel(false);
        this.zzav = null;
        this.zzax = -1L;
    }

    public final void zzu() {
        this.zzv();
    }

    private final synchronized void zzc(long l) {
        this.zzax = l;
        try {
            this.zzav = this.zzaw.scheduleAtFixedRate(new zzap(this), 0L, l, TimeUnit.MILLISECONDS);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            String string = String.valueOf(rejectedExecutionException.getMessage());
            Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Unable to start collecting Cpu Metrics: ".concat(string) : new String("Unable to start collecting Cpu Metrics: ")));
            return;
        }
    }

    private final synchronized void zzv() {
        try {
            this.zzaw.schedule(new zzao(this), 0L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            String string = String.valueOf(rejectedExecutionException.getMessage());
            Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Unable to collect Cpu Metric: ".concat(string) : new String("Unable to collect Cpu Metric: ")));
            return;
        }
    }

    @Nullable
    private final zzbu zzw() {
        block12: {
            zzbu zzbu2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.zzaz));
            Throwable throwable = null;
            try {
                long l = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
                String[] stringArray = bufferedReader.readLine().split(" ");
                long l2 = Long.parseLong(stringArray[13]);
                long l3 = Long.parseLong(stringArray[15]);
                long l4 = Long.parseLong(stringArray[14]);
                long l5 = Long.parseLong(stringArray[16]);
                zzbu2 = (zzbu)((zzeo)zzbu.zzdr().zzu(l).zzw(this.zzd(l4 + l5)).zzv(this.zzd(l2 + l3)).zzhp());
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable5) {
                                zzai.zza(throwable, throwable5);
                            }
                        } else {
                            bufferedReader.close();
                        }
                        throw throwable4;
                    }
                }
                catch (IOException iOException) {
                    String string = String.valueOf(iOException.getMessage());
                    Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Unable to read 'proc/[pid]/stat' file: ".concat(string) : new String("Unable to read 'proc/[pid]/stat' file: ")));
                    break block12;
                }
                catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException runtimeException) {
                    String string = String.valueOf(runtimeException.getMessage());
                    Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Unexpected '/proc/[pid]/stat' file format encountered: ".concat(string) : new String("Unexpected '/proc/[pid]/stat' file format encountered: ")));
                }
            }
            bufferedReader.close();
            return zzbu2;
        }
        return null;
    }

    private final long zzd(long l) {
        return Math.round((double)l / (double)this.zzay * (double)zzat);
    }

    final /* synthetic */ void zzx() {
        zzbu zzbu2 = this.zzw();
        if (zzbu2 != null) {
            this.zzba.add(zzbu2);
        }
    }

    final /* synthetic */ void zzy() {
        zzbu zzbu2 = this.zzw();
        if (zzbu2 != null) {
            this.zzba.add(zzbu2);
        }
    }
}

