/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzdg;
import com.google.android.gms.internal.firebase-perf.zzer;
import com.google.android.gms.internal.firebase-perf.zzev;
import com.google.android.gms.internal.firebase-perf.zzex;
import com.google.android.gms.internal.firebase-perf.zzgj;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzep
extends zzdg<Integer>
implements zzev,
zzgj,
RandomAccess {
    private static final zzep zzra = new zzep(new int[0], 0);
    private int[] zzrb;
    private int size;

    public static zzep zzhx() {
        return zzra;
    }

    zzep() {
        this(new int[10], 0);
    }

    private zzep(int[] nArray, int n) {
        this.zzrb = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzgj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzrb, n2, this.zzrb, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzep)) {
            return super.equals(object);
        }
        zzep zzep2 = (zzep)object;
        if (this.size != zzep2.size) {
            return false;
        }
        int[] nArray = zzep2.zzrb;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzrb[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzrb[i];
        }
        return n;
    }

    @Override
    public final zzev zzak(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzep(Arrays.copyOf(this.zzrb, n), this.size);
    }

    @Override
    public final int getInt(int n) {
        this.zzam(n);
        return this.zzrb[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzal(int n) {
        this.zzs(this.size, n);
    }

    private final void zzs(int n, int n2) {
        this.zzgj();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzan(n));
        }
        if (this.size < this.zzrb.length) {
            System.arraycopy(this.zzrb, n, this.zzrb, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzrb, 0, nArray, 0, n);
            System.arraycopy(this.zzrb, n, nArray, n + 1, this.size - n);
            this.zzrb = nArray;
        }
        this.zzrb[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzgj();
        zzer.checkNotNull(collection);
        if (!(collection instanceof zzep)) {
            return super.addAll(collection);
        }
        zzep zzep2 = (zzep)collection;
        if (zzep2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzep2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzep2.size;
        if (n > this.zzrb.length) {
            this.zzrb = Arrays.copyOf(this.zzrb, n);
        }
        System.arraycopy(zzep2.zzrb, 0, this.zzrb, this.size, zzep2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzgj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzrb[i])) continue;
            System.arraycopy(this.zzrb, i + 1, this.zzrb, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzam(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzan(n));
        }
    }

    private final String zzan(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzep zzep2 = this;
        zzep2.zzgj();
        zzep2.zzam(n);
        int n4 = zzep2.zzrb[n];
        zzep2.zzrb[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzep zzep2 = this;
        zzep2.zzgj();
        zzep2.zzam(n);
        int n2 = zzep2.zzrb[n];
        if (n < zzep2.size - 1) {
            System.arraycopy(zzep2.zzrb, n + 1, zzep2.zzrb, n, zzep2.size - n - 1);
        }
        --zzep2.size;
        ++zzep2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzs(n, n2);
    }

    @Override
    public final /* synthetic */ zzex zzao(int n) {
        return this.zzak(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzra.zzgi();
    }
}

