/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzdg;
import com.google.android.gms.internal.firebase-perf.zzer;
import com.google.android.gms.internal.firebase-perf.zzex;
import com.google.android.gms.internal.firebase-perf.zzgj;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfk
extends zzdg<Long>
implements zzex<Long>,
zzgj,
RandomAccess {
    private static final zzfk zzss = new zzfk(new long[0], 0);
    private long[] zzst;
    private int size;

    zzfk() {
        this(new long[10], 0);
    }

    private zzfk(long[] lArray, int n) {
        this.zzst = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzgj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzst, n2, this.zzst, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfk)) {
            return super.equals(object);
        }
        zzfk zzfk2 = (zzfk)object;
        if (this.size != zzfk2.size) {
            return false;
        }
        long[] lArray = zzfk2.zzst;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzst[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzer.zzav(this.zzst[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzam(n);
        return this.zzst[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzgj();
        zzer.checkNotNull(collection);
        if (!(collection instanceof zzfk)) {
            return super.addAll(collection);
        }
        zzfk zzfk2 = (zzfk)collection;
        if (zzfk2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfk2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfk2.size;
        if (n > this.zzst.length) {
            this.zzst = Arrays.copyOf(this.zzst, n);
        }
        System.arraycopy(zzfk2.zzst, 0, this.zzst, this.size, zzfk2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzgj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzst[i])) continue;
            System.arraycopy(this.zzst, i + 1, this.zzst, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzam(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzan(n));
        }
    }

    private final String zzan(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzfk zzfk2 = this;
        zzfk2.zzgj();
        zzfk2.zzam(n);
        long l3 = zzfk2.zzst[n];
        zzfk2.zzst[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfk zzfk2 = this;
        zzfk2.zzgj();
        zzfk2.zzam(n);
        long l = zzfk2.zzst[n];
        if (n < zzfk2.size - 1) {
            System.arraycopy(zzfk2.zzst, n + 1, zzfk2.zzst, n, zzfk2.size - n - 1);
        }
        --zzfk2.size;
        ++zzfk2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        int n2 = n;
        zzfk zzfk2 = this;
        zzfk2.zzgj();
        if (n2 < 0 || n2 > zzfk2.size) {
            throw new IndexOutOfBoundsException(zzfk2.zzan(n2));
        }
        if (zzfk2.size < zzfk2.zzst.length) {
            System.arraycopy(zzfk2.zzst, n2, zzfk2.zzst, n2 + 1, zzfk2.size - n2);
        } else {
            long[] lArray = new long[zzfk2.size * 3 / 2 + 1];
            System.arraycopy(zzfk2.zzst, 0, lArray, 0, n2);
            System.arraycopy(zzfk2.zzst, n2, lArray, n2 + 1, zzfk2.size - n2);
            zzfk2.zzst = lArray;
        }
        zzfk2.zzst[n2] = l2;
        ++zzfk2.size;
        ++zzfk2.modCount;
    }

    @Override
    public final /* synthetic */ zzex zzao(int n) {
        int n2 = n;
        zzfk zzfk2 = this;
        if (n2 < zzfk2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfk(Arrays.copyOf(zzfk2.zzst, n2), zzfk2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzss.zzgi();
    }
}

