/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.support.annotation.Keep;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zzaf;
import com.google.android.gms.internal.firebase-perf.zzay;
import com.google.firebase.perf.internal.RemoteConfigManager;
import java.util.concurrent.TimeUnit;

@Keep
public class FeatureControl {
    private static final FeatureControl zzce = new FeatureControl();
    private final RemoteConfigManager zzcf;
    private zzay zzcg;
    private static final long zzch = TimeUnit.HOURS.toMinutes(4L);

    private FeatureControl() {
        this(RemoteConfigManager.zzbz(), null);
    }

    public final void zza(zzay zzay2) {
        this.zzcg = zzay2;
    }

    @VisibleForTesting
    private FeatureControl(RemoteConfigManager remoteConfigManager, zzay zzay2) {
        this.zzcf = remoteConfigManager;
        this.zzcg = new zzay();
    }

    public static synchronized FeatureControl zzao() {
        return zzce;
    }

    public final boolean zzap() {
        return this.zzb("sessions_feature_enabled", 1L) != 0L;
    }

    public final boolean zzaq() {
        return this.zzb("sessions_cpu_capture_enabled", 1L) != 0L;
    }

    public final boolean zzar() {
        return this.zzb("sessions_memory_capture_enabled", 1L) != 0L;
    }

    public final float zzas() {
        String string = "sessions_sampling_percentage";
        FeatureControl featureControl = this;
        float f = featureControl.zzcf.zza(string, 1.0f);
        return featureControl.zzcg.getFloat(string, f);
    }

    public final long zzat() {
        return this.zzb("sessions_cpu_capture_frequency_fg_ms", 100L);
    }

    public final long zzau() {
        return this.zzb("sessions_memory_capture_frequency_fg_ms", 100L);
    }

    public final long zzav() {
        return this.zzb("sessions_cpu_capture_frequency_bg_ms", 0L);
    }

    public final long zzaw() {
        return this.zzb("sessions_memory_capture_frequency_bg_ms", 0L);
    }

    public final long zzax() {
        return this.zzb("sessions_max_length_minutes", zzch);
    }

    private final long zzb(String string, long l) {
        int n = zzaf.zza(this.zzcf.zzc(string, l));
        int n2 = this.zzcg.getInt(string, n);
        if (n2 == Integer.MAX_VALUE || n2 == Integer.MIN_VALUE) {
            return l;
        }
        return n2;
    }
}

