/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzan;
import com.google.android.gms.internal.firebase-perf.zzar;
import com.google.android.gms.internal.firebase-perf.zzbq;
import com.google.android.gms.internal.firebase-perf.zzbz;
import com.google.android.gms.internal.firebase-perf.zzca;
import com.google.android.gms.internal.firebase-perf.zzeo;
import com.google.firebase.perf.internal.FeatureControl;
import com.google.firebase.perf.internal.zzc;
import com.google.firebase.perf.internal.zzm;
import com.google.firebase.perf.internal.zzo;
import com.google.firebase.perf.internal.zzp;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Keep
public class GaugeManager {
    private static GaugeManager zzdm = new GaugeManager();
    private final ScheduledExecutorService zzdn;
    private final FeatureControl zzcx;
    private final zzan zzdo;
    private final zzar zzdp;
    @Nullable
    private zzc zzdq;
    @Nullable
    private zzp zzdr;
    private zzbq zzds = zzbq.zzjb;
    @Nullable
    private String zzdt = null;
    @Nullable
    private ScheduledFuture zzdu = null;
    private final ConcurrentLinkedQueue<zza> zzdv = new ConcurrentLinkedQueue();

    private GaugeManager() {
        this(Executors.newSingleThreadScheduledExecutor(), null, FeatureControl.zzao(), null, zzan.zzs(), zzar.zzz());
    }

    @VisibleForTesting
    private GaugeManager(ScheduledExecutorService scheduledExecutorService, zzc zzc2, FeatureControl featureControl, zzp zzp2, zzan zzan2, zzar zzar2) {
        this.zzdn = scheduledExecutorService;
        this.zzdq = null;
        this.zzcx = featureControl;
        this.zzdr = null;
        this.zzdo = zzan2;
        this.zzdp = zzar2;
    }

    public final void zze(Context context) {
        this.zzdr = new zzp(context);
    }

    public static synchronized GaugeManager zzbe() {
        return zzdm;
    }

    public final void zza(String string, zzbq zzbq2) {
        long l;
        boolean bl;
        long l2;
        boolean bl2;
        long l3;
        long l4;
        if (this.zzdt != null) {
            this.zzbf();
        }
        zzbq zzbq3 = zzbq2;
        GaugeManager gaugeManager = this;
        long l5 = -1L;
        zzbq zzbq4 = zzbq3;
        GaugeManager gaugeManager2 = gaugeManager;
        switch (zzbq4) {
            case zzjd: {
                l4 = gaugeManager2.zzcx.zzav();
                break;
            }
            case zzjc: {
                l4 = gaugeManager2.zzcx.zzat();
                break;
            }
            default: {
                l4 = -1L;
            }
        }
        long l6 = l3 = l4 == -1L || l4 <= 0L ? -1L : l4;
        gaugeManager2 = gaugeManager;
        if (!gaugeManager2.zzcx.zzaq()) {
            Log.d((String)"FirebasePerformance", (String)"Cpu Metrics collection is disabled. Did not collect Cpu Metrics.");
            bl2 = false;
        } else if (l6 == -1L) {
            Log.d((String)"FirebasePerformance", (String)"Invalid Cpu Metrics collection frequency. Did not collect Cpu Metrics.");
            bl2 = false;
        } else {
            gaugeManager2.zzdo.zzb(l6);
            bl2 = true;
        }
        if (bl2) {
            l5 = l3;
        }
        zzbq zzbq5 = zzbq3;
        gaugeManager2 = gaugeManager;
        switch (zzbq5) {
            case zzjd: {
                l4 = gaugeManager2.zzcx.zzaw();
                break;
            }
            case zzjc: {
                l4 = gaugeManager2.zzcx.zzau();
                break;
            }
            default: {
                l4 = -1L;
            }
        }
        long l7 = l2 = l4 == -1L || l4 <= 0L ? -1L : l4;
        gaugeManager2 = gaugeManager;
        if (!gaugeManager2.zzcx.zzar()) {
            Log.d((String)"FirebasePerformance", (String)"Memory Metrics collection is disabled. Did not collect Memory Metrics.");
            bl = false;
        } else if (l7 == -1L) {
            Log.d((String)"FirebasePerformance", (String)"Invalid Memory Metrics collection frequency. Did not collect Memory Metrics.");
            bl = false;
        } else {
            gaugeManager2.zzdp.zzb(l7);
            bl = true;
        }
        if (bl) {
            long l8 = l5 = l5 == -1L ? l2 : Math.min(l5, l2);
        }
        if ((l = l5) == -1L) {
            Log.w((String)"FirebasePerformance", (String)"Invalid gauge collection frequency. Unable to start collecting Gauges.");
            return;
        }
        this.zzdt = string;
        this.zzds = zzbq2;
        String string2 = string;
        zzbq zzbq6 = zzbq2;
        try {
            this.zzdu = this.zzdn.scheduleAtFixedRate(new zzm(this, string2, zzbq6), l * 20L, l * 20L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            String string3 = String.valueOf(rejectedExecutionException.getMessage());
            Log.w((String)"FirebasePerformance", (String)(string3.length() != 0 ? "Unable to start collecting Gauges: ".concat(string3) : new String("Unable to start collecting Gauges: ")));
            return;
        }
    }

    public final void zzbf() {
        if (this.zzdt == null) {
            return;
        }
        String string = this.zzdt;
        zzbq zzbq2 = this.zzds;
        this.zzdo.zzt();
        this.zzdp.zzt();
        if (this.zzdu != null) {
            this.zzdu.cancel(false);
        }
        this.zzdn.schedule(new zzo(this, string, zzbq2), 20L, TimeUnit.MILLISECONDS);
        this.zzdt = null;
        this.zzds = zzbq.zzjb;
    }

    private final void zzb(String string, zzbq zzbq2) {
        zzca.zza zza2 = zzca.zzec();
        while (!this.zzdo.zzba.isEmpty()) {
            zza2.zzb(this.zzdo.zzba.poll());
        }
        while (!this.zzdp.zzbf.isEmpty()) {
            zza2.zzb(this.zzdp.zzbf.poll());
        }
        zza2.zzaa(string);
        this.zzc((zzca)((zzeo)zza2.zzhp()), zzbq2);
    }

    final boolean zzc(String string, zzbq zzbq2) {
        if (this.zzdr != null) {
            GaugeManager gaugeManager = this;
            zzca zzca2 = (zzca)((zzeo)zzca.zzec().zzaa(string).zzb((zzbz)((zzeo)zzbz.zzdu().zzz(gaugeManager.zzdr.getProcessName()).zzi(gaugeManager.zzdr.zzbk()).zzj(gaugeManager.zzdr.zzbi()).zzk(gaugeManager.zzdr.zzbj()).zzhp())).zzhp());
            this.zzc(zzca2, zzbq2);
            return true;
        }
        return false;
    }

    private final void zzc(zzca zzca2, zzbq zzbq2) {
        zzc zzc2 = this.zzdq = this.zzdq == null ? zzc.zzba() : this.zzdq;
        if (this.zzdq != null) {
            this.zzdq.zza(zzca2, zzbq2);
            while (!this.zzdv.isEmpty()) {
                zza zza2 = this.zzdv.poll();
                this.zzdq.zza(zza2.zzdf, zza2.zzds);
            }
        } else {
            this.zzdv.add(new zza(this, zzca2, zzbq2));
        }
    }

    public final void zzbg() {
        GaugeManager.zza(this.zzcx.zzaq(), this.zzcx.zzar(), this.zzdo, this.zzdp);
    }

    public static void zzbh() {
        GaugeManager.zza(true, true, zzan.zzs(), zzar.zzz());
    }

    private static void zza(boolean bl, boolean bl2, zzan zzan2, zzar zzar2) {
        if (bl) {
            zzan2.zzu();
        } else {
            Log.d((String)"FirebasePerformance", (String)"Cpu Metrics collection is disabled. Did not collect Cpu Metric.");
        }
        if (bl2) {
            zzar2.zzu();
            return;
        }
        Log.d((String)"FirebasePerformance", (String)"Memory Metrics collection is disabled. Did not collect Memory Metric.");
    }

    final /* synthetic */ void zzd(String string, zzbq zzbq2) {
        this.zzb(string, zzbq2);
    }

    final /* synthetic */ void zze(String string, zzbq zzbq2) {
        this.zzb(string, zzbq2);
    }

    final class zza {
        private final zzca zzdf;
        private final zzbq zzds;

        zza(GaugeManager gaugeManager, zzca zzca2, zzbq zzbq2) {
            this.zzdf = zzca2;
            this.zzds = zzbq2;
        }
    }
}

