/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zza;
import com.google.android.gms.internal.firebase-perf.zzax;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.android.gms.internal.firebase-perf.zzf;
import com.google.android.gms.internal.firebase-perf.zzi;
import com.google.android.gms.internal.firebase-perf.zzp;
import com.google.android.gms.internal.firebase-perf.zzs;
import com.google.android.gms.internal.firebase-perf.zzt;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.perf.internal.zzaa;
import com.google.firebase.perf.internal.zzab;
import com.google.firebase.perf.internal.zzac;
import com.google.firebase.perf.internal.zzy;
import com.google.firebase.perf.internal.zzz;
import com.google.firebase.perf.provider.FirebasePerfProvider;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Keep
public class RemoteConfigManager {
    private static final RemoteConfigManager zzfe = new RemoteConfigManager();
    private static final long zzff = TimeUnit.SECONDS.toMicros(30L);
    private static final long zzfg = TimeUnit.HOURS.toMillis(12L);
    private boolean zzfh = false;
    private boolean zzfi = false;
    private long zzfj = 0L;
    private zzf<zzt<String, Long>> zzfk = zzi.zza(new zzy(this));
    private zzt<String, Long> zzfl = zzt.zzj();
    @Nullable
    private FirebaseRemoteConfig zzfm;
    @Nullable
    private FirebaseApp zzco;
    private final Executor executor;
    private final zzbg zzfn;

    private RemoteConfigManager() {
        this(new ThreadPoolExecutor(0, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()), null, FirebasePerfProvider.zzcw(), null);
    }

    @VisibleForTesting
    private RemoteConfigManager(Executor executor, FirebaseRemoteConfig firebaseRemoteConfig, zzbg zzbg2, FirebaseApp firebaseApp) {
        this.executor = executor;
        this.zzfm = null;
        this.zzco = null;
        this.zzfn = zzbg2;
    }

    public static RemoteConfigManager zzbz() {
        return zzfe;
    }

    public final void zza(FirebaseRemoteConfig firebaseRemoteConfig) {
        this.zzfm = firebaseRemoteConfig;
    }

    public final void zza(FirebaseApp firebaseApp) {
        this.zzco = firebaseApp;
    }

    @Deprecated
    @WorkerThread
    private final zzt<String, Long> zzca() {
        if (this.zzco != null) {
            this.zzfl = this.zzfk.get();
            this.zzfh = true;
            return this.zzfl;
        }
        return zzt.zzj();
    }

    public final long zzc(String string, long l) {
        long l2;
        block3: {
            this.zzcc();
            l2 = this.zzfl.getOrDefault(zzax.zzk(string), l);
            if (this.zzcf()) {
                String string2 = this.zzfm.getString(zzax.zzl(string));
                try {
                    l2 = (long)((float)Long.parseLong(string2) * 100.0f);
                    Log.d((String)"FirebasePerformance", (String)new StringBuilder(74 + String.valueOf(string).length()).append("Fetched value: ").append(l2).append(" for key: ").append(string).append(" from firebase remote config.").toString());
                }
                catch (NumberFormatException numberFormatException) {
                    if (string2.isEmpty()) break block3;
                    Log.d((String)"FirebasePerformance", (String)new StringBuilder(45 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Could not parse value: ").append(string2).append(" for key: ").append(string).append(" into a long").toString());
                }
            }
        }
        return l2;
    }

    public final float zza(String string, float f) {
        float f2;
        block3: {
            this.zzcc();
            Long l = this.zzfl.get(zzax.zzk(string));
            float f3 = f2 = l != null ? (float)l.longValue() : f;
            if (this.zzcf()) {
                String string2 = this.zzfm.getString(zzax.zzl(string));
                try {
                    f2 = Float.parseFloat(string2) * 100.0f;
                }
                catch (NumberFormatException numberFormatException) {
                    if (string2.isEmpty()) break block3;
                    Log.d((String)"FirebasePerformance", (String)new StringBuilder(46 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Could not parse value: ").append(string2).append(" for key: ").append(string).append(" into a float").toString());
                }
            }
        }
        return f2;
    }

    @WorkerThread
    public final void zzcb() {
        this.zzca();
        if (this.zzcf()) {
            this.zzcg();
        }
    }

    private final void zzcc() {
        if (this.zzfh) {
            this.zzcd();
            return;
        }
        this.executor.execute(new zzaa(this));
    }

    private final void zzcd() {
        if (!this.zzcf()) {
            return;
        }
        int n = this.zzfm.getInfo().getLastFetchStatus();
        if ((n == 1 || n == 0) && this.zzch()) {
            if (this.zzfn.zzcy() > zzff) {
                this.zzce();
                return;
            }
        } else if (n == -1 || n == 2) {
            if (!this.zzfi) {
                this.zzfj = System.currentTimeMillis();
                this.zzfi = true;
                this.executor.execute(new zzz(this));
                return;
            }
            if (this.zzch()) {
                this.zzce();
            }
        }
    }

    private final void zzce() {
        this.zzfj = System.currentTimeMillis();
        this.zzfm.fetch().addOnCompleteListener(this.executor, (OnCompleteListener)new zzac(this)).addOnFailureListener(this.executor, (OnFailureListener)new zzab(this));
    }

    private final boolean zzcf() {
        return this.zzfm != null && this.zzfl.getOrDefault(zzax.zzk("firebase_remote_config_enabled"), 1L) == 1L;
    }

    private final void zzcg() {
        if (this.zzfm.activateFetched()) {
            Log.d((String)"FirebasePerformance", (String)"Activated Firebase Remote Config Values for the Fireperf Namespace");
        }
    }

    private static zzp<String> zza(Context context, String string) {
        zzs zzs2 = zzp.zzh();
        String[] stringArray = new String[3];
        int n = RemoteConfigManager.zzf(context);
        stringArray[0] = new StringBuilder(12 + String.valueOf(string).length()).append(string).append(":").append(n).toString();
        stringArray[1] = string;
        stringArray[2] = "1.0.0.240228580";
        String[] stringArray2 = stringArray;
        for (int i = 0; i < 3; ++i) {
            String string2 = stringArray2[i];
            String string3 = String.valueOf("_fireperf1:");
            String string4 = String.valueOf(string2);
            String string5 = RemoteConfigManager.zzh(string4.length() != 0 ? string3.concat(string4) : new String(string3));
            String string6 = new StringBuilder(16 + String.valueOf(string5).length()).append("fireperf:").append(string5).append("_limits").toString();
            String string7 = null;
            try {
                string7 = zza.zza(context.getContentResolver(), string6, null);
            }
            catch (SecurityException securityException) {
                String string8 = String.valueOf(securityException.getMessage());
                Log.w((String)"FirebasePerformance", (String)(string8.length() != 0 ? "Failed to fetch Gservices flag. SecurityException: ".concat(string8) : new String("Failed to fetch Gservices flag. SecurityException: ")));
            }
            if (string7 == null) continue;
            zzs2.zzb(string7);
        }
        return zzs2.zzi();
    }

    @Nullable
    @VisibleForTesting
    private static String zzh(@Nullable String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = MessageDigest.getInstance("SHA-1").digest(string.getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray2 = byArray;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte by = byArray2[i];
                stringBuilder.append(String.format("%02x", by));
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static zzt<String, Long> zzc(List<String> list) {
        if (list == null) {
            return zzt.zzj();
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = iterator.next().split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                long l;
                String string;
                String[] stringArray2 = stringArray[i].split(":");
                if (stringArray2.length < 2 || (string = stringArray2[0].trim()).isEmpty() || hashMap.containsKey(string)) continue;
                try {
                    l = Long.parseLong(stringArray2[1].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (l < 0L) continue;
                hashMap.put(string, l);
            }
        }
        return zzt.zza(hashMap);
    }

    private final boolean zzch() {
        return System.currentTimeMillis() - this.zzfj > zzfg;
    }

    @VisibleForTesting
    private static int zzf(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return 0;
        }
    }

    final /* synthetic */ void zza(Exception exception) {
        this.zzfj = 0L;
    }

    final /* synthetic */ void zza(Task task) {
        if (task.isSuccessful()) {
            this.zzcg();
            this.zzfi = true;
        }
    }

    final /* synthetic */ void zzci() {
        this.zzca();
        this.zzcd();
    }

    final /* synthetic */ zzt zzcj() {
        RemoteConfigManager remoteConfigManager = this;
        String string = remoteConfigManager.zzco.getOptions().getApplicationId();
        return RemoteConfigManager.zzc(RemoteConfigManager.zza(remoteConfigManager.zzco.getApplicationContext(), string));
    }

    final /* synthetic */ void zzck() {
        this.zzcg();
    }
}

