/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.clearcut.ClearcutLogger;
import com.google.android.gms.internal.firebase-perf.zzaw;
import com.google.android.gms.internal.firebase-perf.zzbj;
import com.google.android.gms.internal.firebase-perf.zzbk;
import com.google.android.gms.internal.firebase-perf.zzbo;
import com.google.android.gms.internal.firebase-perf.zzbq;
import com.google.android.gms.internal.firebase-perf.zzca;
import com.google.android.gms.internal.firebase-perf.zzch;
import com.google.android.gms.internal.firebase-perf.zzcn;
import com.google.android.gms.internal.firebase-perf.zzcw;
import com.google.android.gms.internal.firebase-perf.zzde;
import com.google.android.gms.internal.firebase-perf.zzeo;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.perf.FirebasePerformance;
import com.google.firebase.perf.internal.FeatureControl;
import com.google.firebase.perf.internal.RemoteConfigManager;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.internal.zza;
import com.google.firebase.perf.internal.zzd;
import com.google.firebase.perf.internal.zze;
import com.google.firebase.perf.internal.zzf;
import com.google.firebase.perf.internal.zzg;
import com.google.firebase.perf.internal.zzh;
import com.google.firebase.perf.internal.zzi;
import com.google.firebase.perf.internal.zzj;
import com.google.firebase.perf.internal.zzk;
import com.google.firebase.perf.internal.zzl;
import com.google.firebase.perf.internal.zzr;
import com.google.firebase.perf.internal.zzu;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class zzc {
    @SuppressLint(value={"StaticFieldLeak"})
    private static zzc zzcm;
    private final ExecutorService zzcn;
    private FirebaseApp zzco;
    private FirebasePerformance zzcp;
    private FirebaseInstanceId zzcq;
    private Context zzcr;
    private ClearcutLogger zzcs;
    private String zzct;
    private final zzbo.zza zzcu = zzbo.zzdm();
    private zzu zzcv;
    private zza zzcw;
    private FeatureControl zzcx;
    private boolean zzcy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static zzc zzba() {
        if (zzcm != null) return zzcm;
        Class<zzc> clazz = zzc.class;
        synchronized (zzc.class) {
            if (zzcm != null) return zzcm;
            try {
                FirebaseApp.getInstance();
            }
            catch (IllegalStateException illegalStateException) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            zzcm = new zzc(null, null, null, null, null, null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzcm;
        }
    }

    @VisibleForTesting(otherwise=2)
    private zzc(@Nullable ExecutorService executorService, @Nullable ClearcutLogger clearcutLogger, @Nullable zzu zzu2, @Nullable zza zza2, @Nullable FirebaseInstanceId firebaseInstanceId, @Nullable FeatureControl featureControl) {
        this.zzcn = executorService = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.zzcs = null;
        this.zzcv = null;
        this.zzcw = null;
        this.zzcq = null;
        this.zzcx = null;
        this.zzcn.execute(new zzf(this));
    }

    public final void zza(@NonNull zzcw zzcw2, zzbq zzbq2) {
        this.zzcn.execute(new zze(this, zzcw2, zzbq2));
        SessionManager.zzcl().zzcn();
    }

    public final void zza(@NonNull zzch zzch2, zzbq zzbq2) {
        this.zzcn.execute(new zzh(this, zzch2, zzbq2));
        SessionManager.zzcl().zzcn();
    }

    public final void zza(zzca zzca2, zzbq zzbq2) {
        this.zzcn.execute(new zzg(this, zzca2, zzbq2));
        SessionManager.zzcl().zzcn();
    }

    public final void zzb(boolean bl) {
        this.zzcn.execute(new zzj(this, bl));
    }

    @WorkerThread
    private final void zzbb() {
        this.zzco = FirebaseApp.getInstance();
        this.zzcp = FirebasePerformance.getInstance();
        this.zzcr = this.zzco.getApplicationContext();
        this.zzct = this.zzco.getOptions().getApplicationId();
        this.zzcu.zzv(this.zzct).zzb(zzbj.zzdb().zzq(this.zzcr.getPackageName()).zzr("1.0.0.240228580").zzs(zzc.zzd(this.zzcr)));
        this.zzbc();
        if (this.zzcs == null) {
            try {
                this.zzcs = ClearcutLogger.anonymousLogger((Context)this.zzcr, (String)"FIREPERF");
            }
            catch (SecurityException securityException) {
                String string = String.valueOf(securityException.getMessage());
                Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Caught SecurityException while init ClearcutLogger: ".concat(string) : new String("Caught SecurityException while init ClearcutLogger: ")));
                this.zzcs = null;
            }
        }
        RemoteConfigManager.zzbz().zzcb();
        this.zzcv = this.zzcv == null ? new zzu(this.zzcr, 100L, 500L) : this.zzcv;
        this.zzcw = this.zzcw == null ? zza.zzaj() : this.zzcw;
        this.zzcx = this.zzcx == null ? FeatureControl.zzao() : this.zzcx;
        this.zzcy = zzbk.zzg(this.zzcr);
    }

    @WorkerThread
    private final void zza(@NonNull zzcn zzcn2) {
        if (this.zzcs == null) {
            return;
        }
        if (this.zzcp.isPerformanceCollectionEnabled()) {
            boolean bl;
            block20: {
                ArrayList<zzr> arrayList;
                if (!zzcn2.zzfg().zzdh()) {
                    Log.w((String)"FirebasePerformance", (String)"App Instance ID is null or empty, dropping the log");
                    return;
                }
                Context context = this.zzcr;
                zzcn zzcn3 = zzcn2;
                Context context2 = context;
                zzcn zzcn4 = zzcn3;
                ArrayList<zzr> arrayList2 = new ArrayList<zzr>();
                if (zzcn4.zzfh()) {
                    arrayList2.add(new zzk(zzcn4.zzfi()));
                }
                if (zzcn4.zzfj()) {
                    arrayList2.add(new zzl(zzcn4.zzfk(), context2));
                }
                if (zzcn4.zzff()) {
                    arrayList2.add(new zzd(zzcn4.zzfg()));
                }
                if (zzcn4.zzfl()) {
                    arrayList2.add(new zzi(zzcn4.zzfm()));
                }
                if ((arrayList = arrayList2).isEmpty()) {
                    Log.d((String)"FirebasePerformance", (String)"No validators found for PerfMetric.");
                    bl = false;
                } else {
                    ArrayList<zzr> arrayList3 = arrayList;
                    int n = arrayList3.size();
                    Object var8_11 = null;
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList3.get(i);
                        if (((zzr)e).zzbd()) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                Log.w((String)"FirebasePerformance", (String)"Unable to process the PerfMetric due to missing or invalid values. See earlier log statements for additional information on the specific missing/invalid values.");
                return;
            }
            if (!this.zzcv.zzb(zzcn2)) {
                zzcn zzcn5 = zzcn2;
                zzc zzc2 = this;
                if (zzcn5.zzfj()) {
                    zzc2.zzcw.zza(zzaw.zzho.toString(), 1L);
                } else if (zzcn5.zzfh()) {
                    zzc2.zzcw.zza(zzaw.zzhn.toString(), 1L);
                }
                if (this.zzcy) {
                    if (zzcn2.zzfj()) {
                        String string = String.valueOf(zzcn2.zzfk().getUrl());
                        Log.i((String)"FirebasePerformance", (String)(string.length() != 0 ? "Rate Limited NetworkRequestMetric - ".concat(string) : new String("Rate Limited NetworkRequestMetric - ")));
                        return;
                    }
                    if (zzcn2.zzfh()) {
                        String string = String.valueOf(zzcn2.zzfi().getName());
                        Log.i((String)"FirebasePerformance", (String)(string.length() != 0 ? "Rate Limited TraceMetric - ".concat(string) : new String("Rate Limited TraceMetric - ")));
                    }
                }
                return;
            }
            byte[] byArray = zzcn2.toByteArray();
            try {
                this.zzcs.newEvent(byArray).log();
                return;
            }
            catch (SecurityException securityException) {}
        }
    }

    @WorkerThread
    private final void zzb(zzca zzca2, zzbq zzbq2) {
        if (this.zzcp.isPerformanceCollectionEnabled()) {
            if (this.zzcy) {
                int n = zzca2.zzea();
                int n2 = zzca2.zzeb();
                Log.d((String)"FirebasePerformance", (String)String.format("Logging GaugeMetric. Cpu Metrics: %d, Memory Metrics: %d, Has Metadata: %b, Session ID: %s", n, n2, zzca2.zzdy(), zzca2.getSessionId()));
            }
            if (!this.zzcx.zzap()) {
                if (this.zzcy) {
                    Log.d((String)"FirebasePerformance", (String)"Sessions are disabled. Not logging GaugeMetric.");
                }
                return;
            }
            zzcn.zza zza2 = com.google.android.gms.internal.firebase-perf.zzcn.zzfn();
            this.zzbc();
            zza2.zzb(this.zzcu.zzf(zzbq2)).zzb(zzca2);
            this.zza((zzcn)((zzeo)zza2.zzhp()));
        }
    }

    @WorkerThread
    private final void zzb(@NonNull zzcw zzcw2, zzbq zzbq2) {
        if (this.zzcp.isPerformanceCollectionEnabled()) {
            if (this.zzcy) {
                long l = zzcw2.getDurationUs();
                Log.d((String)"FirebasePerformance", (String)String.format("Logging TraceMetric - %s %dms", zzcw2.getName(), l / 1000L));
            }
            if (!this.zzcx.zzap()) {
                zzcw2 = (zzcw)((zzeo)((zzcw.zza)((zzeo.zza)zzcw2.zzhs())).zzgc().zzhp());
                if (this.zzcy) {
                    Log.d((String)"FirebasePerformance", (String)String.format("Sessions are disabled. Dropping all sessions from Trace - %s", zzcw2.getName()));
                }
            }
            this.zzbc();
            zzcn zzcn2 = (zzcn)((zzeo)com.google.android.gms.internal.firebase-perf.zzcn.zzfn().zzb(((zzbo.zza)((zzeo.zza)((zzde)this.zzcu).clone())).zzf(zzbq2).zzc(this.zzcp.getAttributes())).zzb(zzcw2).zzhp());
            this.zza(zzcn2);
        }
    }

    @WorkerThread
    private final void zzb(@NonNull zzch zzch2, zzbq zzbq2) {
        if (this.zzcp.isPerformanceCollectionEnabled()) {
            if (this.zzcy) {
                long l = !zzch2.zzev() ? 0L : zzch2.zzew();
                long l2 = !zzch2.zzel() ? 0L : zzch2.zzem();
                Log.d((String)"FirebasePerformance", (String)String.format("Logging NetworkRequestMetric - %s %db %dms,", zzch2.getUrl(), l2, l / 1000L));
            }
            if (!this.zzcx.zzap()) {
                zzch2 = (zzch)((zzeo)((zzch.zzb)((zzeo.zza)zzch2.zzhs())).zzfe().zzhp());
                if (this.zzcy) {
                    Log.d((String)"FirebasePerformance", (String)String.format("Sessions are disabled. Dropping all sessions from Network Request - %s", zzch2.getUrl()));
                }
            }
            this.zzbc();
            zzcn zzcn2 = (zzcn)((zzeo)com.google.android.gms.internal.firebase-perf.zzcn.zzfn().zzb(this.zzcu.zzf(zzbq2)).zze(zzch2).zzhp());
            this.zza(zzcn2);
        }
    }

    @WorkerThread
    public final void zzc(boolean bl) {
        this.zzcv.zzb(bl);
    }

    private static String zzd(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return "";
        }
    }

    @WorkerThread
    private final void zzbc() {
        if (this.zzcu.zzdh()) {
            return;
        }
        if (this.zzcp.isPerformanceCollectionEnabled()) {
            String string;
            if (this.zzcq == null) {
                this.zzcq = FirebaseInstanceId.getInstance();
            }
            if ((string = this.zzcq.getId()) != null && !string.isEmpty()) {
                this.zzcu.zzw(string);
            }
        }
    }

    static /* synthetic */ void zzb(zzc zzc2) {
        zzc2.zzbb();
    }

    static /* synthetic */ void zza(zzc zzc2, zzcw zzcw2, zzbq zzbq2) {
        zzc2.zzb(zzcw2, zzbq2);
    }

    static /* synthetic */ void zza(zzc zzc2, zzch zzch2, zzbq zzbq2) {
        zzc2.zzb(zzch2, zzbq2);
    }

    static /* synthetic */ void zza(zzc zzc2, zzca zzca2, zzbq zzbq2) {
        zzc2.zzb(zzca2, zzbq2);
    }
}

