/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzbi;
import com.google.android.gms.internal.firebase-perf.zzch;
import com.google.firebase.perf.internal.zzr;
import java.net.URI;

final class zzl
extends zzr {
    private final zzch zzdi;
    private final Context zzcr;

    zzl(@NonNull zzch zzch2, Context context) {
        this.zzcr = context;
        this.zzdi = zzch2;
    }

    @Override
    public final boolean zzbd() {
        String string = this.zzdi.getUrl();
        if (zzl.zze(string)) {
            String string2 = String.valueOf(this.zzdi.getUrl());
            Log.i((String)"FirebasePerformance", (String)(string2.length() != 0 ? "URL is missing:".concat(string2) : new String("URL is missing:")));
            return false;
        }
        URI uRI = zzl.zzd(this.zzdi.getUrl());
        if (uRI == null) {
            Log.i((String)"FirebasePerformance", (String)"URL cannot be parsed");
            return false;
        }
        string = this.zzcr;
        Object object = uRI;
        if (!(object == null ? false : zzbi.zza((URI)object, (Context)string))) {
            String string3 = String.valueOf(uRI);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(26 + String.valueOf(string3).length()).append("URL fails whitelist rule: ").append(string3).toString());
            return false;
        }
        string = uRI.getHost();
        if (!(string != null && !zzl.zze(string) && string.length() <= 255)) {
            Log.i((String)"FirebasePerformance", (String)"URL host is null or invalid");
            return false;
        }
        object = uRI.getScheme();
        if (!(object != null && ("http".equalsIgnoreCase((String)object) || "https".equalsIgnoreCase((String)object)))) {
            Log.i((String)"FirebasePerformance", (String)"URL scheme is null or invalid");
            return false;
        }
        if (!(uRI.getUserInfo() == null)) {
            Log.i((String)"FirebasePerformance", (String)"URL user info is null");
            return false;
        }
        int n = uRI.getPort();
        if (!(n == -1 || n > 0)) {
            Log.i((String)"FirebasePerformance", (String)"URL port is less than or equal to 0");
            return false;
        }
        zzch.zzc zzc2 = this.zzdi.zzeh() ? this.zzdi.zzei() : null;
        if (!(zzc2 != null && zzc2 != zzch.zzc.zzkz)) {
            String string4 = String.valueOf(this.zzdi.zzei());
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(32 + String.valueOf(string4).length()).append("HTTP Method is null or invalid: ").append(string4).toString());
            return false;
        }
        if (this.zzdi.zzaf() && !(this.zzdi.zzen() > 0)) {
            int n2 = this.zzdi.zzen();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(49).append("HTTP ResponseCode is a negative value:").append(n2).toString());
            return false;
        }
        if (this.zzdi.zzej() && !zzl.zzm(this.zzdi.zzek())) {
            long l = this.zzdi.zzek();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(56).append("Request Payload is a negative value:").append(l).toString());
            return false;
        }
        if (this.zzdi.zzel() && !zzl.zzm(this.zzdi.zzem())) {
            long l = this.zzdi.zzem();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(57).append("Response Payload is a negative value:").append(l).toString());
            return false;
        }
        if (!this.zzdi.zzep() || this.zzdi.zzeq() <= 0L) {
            long l = this.zzdi.zzeq();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(84).append("Start time of the request is null, or zero, or a negative value:").append(l).toString());
            return false;
        }
        if (this.zzdi.zzer() && !zzl.zzl(this.zzdi.zzes())) {
            long l = this.zzdi.zzes();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(69).append("Time to complete the request is a negative value:").append(l).toString());
            return false;
        }
        if (this.zzdi.zzet() && !zzl.zzl(this.zzdi.zzeu())) {
            long l = this.zzdi.zzeu();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(112).append("Time from the start of the request to the start of the response is null or a negative value:").append(l).toString());
            return false;
        }
        if (!this.zzdi.zzev() || this.zzdi.zzew() <= 0L) {
            long l = this.zzdi.zzew();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(108).append("Time from the start of the request to the end of the response is null, negative or zero:").append(l).toString());
            return false;
        }
        if (!this.zzdi.zzaf()) {
            Log.i((String)"FirebasePerformance", (String)"Did not receive a HTTP Response Code");
            return false;
        }
        return true;
    }

    @Nullable
    private static URI zzd(@Nullable String string) {
        if (string == null) {
            return null;
        }
        try {
            return URI.create(string);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            Log.w((String)"FirebasePerformance", (String)"getResultUrl throws exception", (Throwable)runtimeException);
            return null;
        }
    }

    private static boolean zzl(long l) {
        return l >= 0L;
    }

    private static boolean zzm(long l) {
        return l >= 0L;
    }

    private static boolean zze(@Nullable String string) {
        if (string == null) {
            return true;
        }
        return string.trim().isEmpty();
    }
}

