/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzau;
import com.google.android.gms.internal.firebase-perf.zzav;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.android.gms.internal.firebase-perf.zzbq;
import com.google.android.gms.internal.firebase-perf.zzcw;
import com.google.android.gms.internal.firebase-perf.zzeo;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.internal.zzc;
import com.google.firebase.perf.provider.FirebasePerfProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class AppStartTrace
implements Application.ActivityLifecycleCallbacks {
    private static final long zzfr = TimeUnit.MINUTES.toMicros(1L);
    private static volatile AppStartTrace zzfs;
    private boolean mRegistered = false;
    private zzc zzbr = null;
    private final zzau zzbs;
    private Context zzft;
    private WeakReference<Activity> zzfu;
    private WeakReference<Activity> zzfv;
    private boolean zzfw = false;
    private zzbg zzfx = null;
    private zzbg zzfy = null;
    private zzbg zzfz = null;
    private boolean zzga = false;

    @Keep
    public static void setLauncherActivityOnCreateTime(String string) {
    }

    @Keep
    public static void setLauncherActivityOnStartTime(String string) {
    }

    @Keep
    public static void setLauncherActivityOnResumeTime(String string) {
    }

    public static AppStartTrace zzco() {
        if (zzfs != null) {
            return zzfs;
        }
        return AppStartTrace.zzb(null, new zzau());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AppStartTrace zzb(zzc zzc2, zzau zzau2) {
        if (zzfs != null) return zzfs;
        Class<AppStartTrace> clazz = AppStartTrace.class;
        synchronized (AppStartTrace.class) {
            if (zzfs != null) return zzfs;
            zzfs = new AppStartTrace(null, zzau2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzfs;
        }
    }

    private AppStartTrace(@Nullable zzc zzc2, @NonNull zzau zzau2) {
        this.zzbs = zzau2;
    }

    public final synchronized void zzc(@NonNull Context context) {
        if (this.mRegistered) {
            return;
        }
        Context context2 = context.getApplicationContext();
        if (context2 instanceof Application) {
            ((Application)context2).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mRegistered = true;
            this.zzft = context2;
        }
    }

    private final synchronized void zzcp() {
        if (!this.mRegistered) {
            return;
        }
        ((Application)this.zzft).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.mRegistered = false;
    }

    public synchronized void onActivityCreated(Activity activity, Bundle bundle) {
        SessionManager.zzcl().zzc(zzbq.zzjc);
        if (this.zzga || this.zzfx != null) {
            return;
        }
        this.zzfu = new WeakReference<Activity>(activity);
        this.zzfx = new zzbg();
        if (FirebasePerfProvider.zzcw().zza(this.zzfx) > zzfr) {
            this.zzfw = true;
        }
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.zzga || this.zzfy != null || this.zzfw) {
            return;
        }
        this.zzfy = new zzbg();
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.zzga || this.zzfz != null || this.zzfw) {
            return;
        }
        this.zzfv = new WeakReference<Activity>(activity);
        this.zzfz = new zzbg();
        zzbg zzbg2 = FirebasePerfProvider.zzcw();
        Object object = activity.getClass().getName();
        long l = zzbg2.zza(this.zzfz);
        Log.d((String)"FirebasePerformance", (String)new StringBuilder(47 + String.valueOf(object).length()).append("onResume(): ").append((String)object).append(": ").append(l).append(" microseconds").toString());
        object = zzcw.zzfz().zzae(zzav.zzhg.toString()).zzak(zzbg2.zzcx()).zzal(zzbg2.zza(this.zzfz));
        ArrayList<zzcw> arrayList = new ArrayList<zzcw>(3);
        zzcw.zza zza2 = zzcw.zzfz().zzae(zzav.zzhh.toString()).zzak(zzbg2.zzcx()).zzal(zzbg2.zza(this.zzfx));
        arrayList.add((zzcw)((zzeo)zza2.zzhp()));
        zza2 = zzcw.zzfz();
        zza2.zzae(zzav.zzhi.toString()).zzak(this.zzfx.zzcx()).zzal(this.zzfx.zza(this.zzfy));
        arrayList.add((zzcw)((zzeo)zza2.zzhp()));
        zza2 = zzcw.zzfz();
        zza2.zzae(zzav.zzhj.toString()).zzak(this.zzfy.zzcx()).zzal(this.zzfy.zza(this.zzfz));
        arrayList.add((zzcw)((zzeo)zza2.zzhp()));
        ((zzcw.zza)object).zze(arrayList).zzb(SessionManager.zzcl().zzcm().zzbo());
        if (this.zzbr == null) {
            this.zzbr = zzc.zzba();
        }
        if (this.zzbr != null) {
            this.zzbr.zza((zzcw)((zzeo)((zzeo.zza)object).zzhp()), zzbq.zzje);
        }
        if (this.mRegistered) {
            this.zzcp();
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public synchronized void onActivityStopped(Activity activity) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    static /* synthetic */ boolean zza(AppStartTrace appStartTrace, boolean bl) {
        appStartTrace.zzga = true;
        return true;
    }

    public static final class zza
    implements Runnable {
        private final AppStartTrace zzgc;

        public zza(AppStartTrace appStartTrace) {
            this.zzgc = appStartTrace;
        }

        @Override
        public final void run() {
            if (this.zzgc.zzfx == null) {
                AppStartTrace.zza(this.zzgc, true);
            }
        }
    }
}

