/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzas;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.firebase.perf.internal.zzc;
import com.google.firebase.perf.internal.zzr;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpMetric {
    private zzas zzgd;
    private zzbg zzge;
    private final Map<String, String> zzgf;
    private boolean zzgg = false;

    public HttpMetric(String string, String string2, zzc zzc2, zzbg zzbg2) {
        this.zzgd = zzas.zza(zzc2);
        this.zzgd.zza(string);
        this.zzgd.zzb(string2);
        this.zzge = zzbg2;
        this.zzgd.zzae();
        this.zzgf = new ConcurrentHashMap<String, String>();
    }

    public HttpMetric(URL uRL, String string, zzc zzc2, zzbg zzbg2) {
        this.zzgd = zzas.zza(zzc2);
        this.zzgd.zza(uRL.toString());
        this.zzgd.zzb(string);
        this.zzge = zzbg2;
        this.zzgd.zzae();
        this.zzgf = new ConcurrentHashMap<String, String>();
    }

    public void setHttpResponseCode(int n) {
        this.zzgd.zzb(n);
    }

    public void setRequestPayloadSize(long l) {
        this.zzgd.zzf(l);
    }

    public void setResponsePayloadSize(long l) {
        this.zzgd.zzk(l);
    }

    public void setResponseContentType(@Nullable String string) {
        this.zzgd.zzc(string);
    }

    public void start() {
        this.zzge.reset();
        this.zzgd.zzg(this.zzge.zzcx());
    }

    public void stop() {
        this.zzgd.zzj(this.zzge.zzcy());
        this.zzgd.zzb(this.zzgf);
        this.zzgd.zzai();
        this.zzgg = true;
    }

    public void putAttribute(@NonNull String string, @NonNull String string2) {
        boolean bl = true;
        try {
            string = string.trim();
            String string3 = string2 = string2.trim();
            String string4 = string;
            HttpMetric httpMetric = this;
            if (httpMetric.zzgg) {
                throw new IllegalArgumentException("HttpMetric has been logged already so unable to modify attributes");
            }
            if (string4 == null || string3 == null) {
                throw new IllegalArgumentException("Attribute must not have null key or value.");
            }
            if (!httpMetric.zzgf.containsKey(string4) && httpMetric.zzgf.size() >= 5) {
                throw new IllegalArgumentException(String.format(Locale.US, "Exceeds max limit of number of attributes - %d", 5));
            }
            String string5 = zzr.zza(new AbstractMap.SimpleEntry<String, String>(string4, string3));
            if (string5 != null) {
                throw new IllegalArgumentException(string5);
            }
        }
        catch (Exception exception) {
            Log.e((String)"FirebasePerformance", (String)String.format("Can not set attribute %s with value %s (%s)", string, string2, exception.getMessage()));
            bl = false;
        }
        if (bl) {
            this.zzgf.put(string, string2);
        }
    }

    public void removeAttribute(@NonNull String string) {
        if (this.zzgg) {
            Log.e((String)"FirebasePerformance", (String)"Can't remove a attribute from a HttpMetric that's stopped.");
            return;
        }
        this.zzgf.remove(string);
    }

    @Nullable
    public String getAttribute(@NonNull String string) {
        return this.zzgf.get(string);
    }

    @NonNull
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzgf);
    }
}

