/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zzau;
import com.google.android.gms.internal.firebase-perf.zzav;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.firebase.perf.internal.GaugeManager;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.internal.zzad;
import com.google.firebase.perf.internal.zzb;
import com.google.firebase.perf.internal.zzr;
import com.google.firebase.perf.internal.zzs;
import com.google.firebase.perf.internal.zzt;
import com.google.firebase.perf.metrics.zza;
import com.google.firebase.perf.metrics.zzc;
import com.google.firebase.perf.metrics.zzd;
import com.google.firebase.perf.metrics.zze;
import com.google.firebase.perf.metrics.zzf;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Trace
extends zzb
implements Parcelable,
zzad {
    private static final Map<String, Trace> zzgh = new ConcurrentHashMap<String, Trace>();
    private final Trace zzgi;
    private final GaugeManager zzbk;
    private final String name;
    private final List<zzs> zzbj;
    private final List<Trace> zzgj;
    private final Map<String, zza> zzgk;
    private final zzau zzgl;
    private final com.google.firebase.perf.internal.zzc zzcm;
    private final Map<String, String> zzgm;
    private zzbg zzgn;
    private zzbg zzgo;
    private final WeakReference<zzad> zzbp = new WeakReference<Trace>(this);
    @Keep
    public static final Parcelable.Creator<Trace> CREATOR = new zzc();
    @VisibleForTesting
    private static final Parcelable.Creator<Trace> zzgp = new zze();

    @Override
    public final void zza(zzs zzs2) {
        if (this.hasStarted() && !this.isStopped()) {
            this.zzbj.add(zzs2);
        }
    }

    @NonNull
    public static Trace zzi(@NonNull String string) {
        return new Trace(string);
    }

    private Trace(@NonNull String string) {
        this(string, com.google.firebase.perf.internal.zzc.zzba(), new zzau(), com.google.firebase.perf.internal.zza.zzaj(), GaugeManager.zzbe());
    }

    public Trace(@NonNull String string, @NonNull com.google.firebase.perf.internal.zzc zzc2, @NonNull zzau zzau2, @NonNull com.google.firebase.perf.internal.zza zza2) {
        this(string, zzc2, zzau2, zza2, GaugeManager.zzbe());
    }

    private Trace(@NonNull String string, @NonNull com.google.firebase.perf.internal.zzc zzc2, @NonNull zzau zzau2, @NonNull com.google.firebase.perf.internal.zza zza2, @NonNull GaugeManager gaugeManager) {
        super(zza2);
        this.zzgi = null;
        this.name = string.trim();
        this.zzgj = new ArrayList<Trace>();
        this.zzgk = new ConcurrentHashMap<String, zza>();
        this.zzgm = new ConcurrentHashMap<String, String>();
        this.zzgl = zzau2;
        this.zzcm = zzc2;
        this.zzbj = new ArrayList<zzs>();
        this.zzbk = gaugeManager;
    }

    /*
     * Unable to fully structure code
     */
    @Keep
    public void start() {
        block8: {
            block9: {
                block7: {
                    var3_1 = this.name;
                    if (var3_1 != null) break block7;
                    v0 = "Trace name must not be null";
                    break block8;
                }
                if (var3_1.length() <= 100) break block9;
                v0 = String.format(Locale.US, "Trace name must not exceed %d characters", new Object[]{100});
                break block8;
            }
            if (!var3_1.startsWith("_")) ** GOTO lbl-1000
            var4_2 = zzav.values();
            var5_3 = var4_2.length;
            for (var6_4 = 0; var6_4 < var5_3; ++var6_4) {
                if (!var4_2[var6_4].toString().equals(var3_1)) {
                    continue;
                }
                ** GOTO lbl-1000
            }
            if (!var3_1.startsWith("_st_")) {
                v0 = "Trace name must not start with '_'";
            } else lbl-1000:
            // 3 sources

            {
                v0 = var1_5 = null;
            }
        }
        if (v0 != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Cannot start trace %s. Trace name is invalid.(%s)", new Object[]{this.name, var1_5}));
            return;
        }
        if (this.zzgn != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has already started, should not start again!", new Object[]{this.name}));
            return;
        }
        this.zzay();
        var2_6 = SessionManager.zzcl().zzcm();
        SessionManager.zzcl().zzc(this.zzbp);
        this.zzbj.add(var2_6);
        this.zzgn = new zzbg();
        Log.i((String)"FirebasePerformance", (String)String.format("Session ID - %s", new Object[]{var2_6.zzbm()}));
        if (var2_6.zzbn()) {
            this.zzbk.zzbg();
        }
    }

    @Keep
    public void stop() {
        if (!this.hasStarted()) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has not been started so unable to stop!", this.name));
            return;
        }
        if (this.isStopped()) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has already stopped, should not stop again!", this.name));
            return;
        }
        SessionManager.zzcl().zzd(this.zzbp);
        this.zzaz();
        this.zzgo = new zzbg();
        if (this.zzgi == null) {
            zzbg zzbg2 = this.zzgo;
            Trace trace = this;
            if (!trace.zzgj.isEmpty()) {
                int n = trace.zzgj.size() - 1;
                Trace trace2 = trace.zzgj.get(n);
                if (trace2.zzgo == null) {
                    trace2.zzgo = zzbg2;
                }
            }
            if (!this.name.isEmpty()) {
                if (this.zzcm != null) {
                    this.zzcm.zza(new zzf(this).zzcu(), this.zzal());
                    if (SessionManager.zzcl().zzcm().zzbn()) {
                        this.zzbk.zzbg();
                        return;
                    }
                }
            } else {
                Log.e((String)"FirebasePerformance", (String)"Trace name is empty, no log is sent to server");
            }
        }
    }

    @NonNull
    private final zza zzj(@NonNull String string) {
        zza zza2 = this.zzgk.get(string);
        if (zza2 == null) {
            zza2 = new zza(string);
            this.zzgk.put(string, zza2);
        }
        return zza2;
    }

    @Deprecated
    @Keep
    public void incrementCounter(@NonNull String string, long l) {
        this.zza(string, l, zzt.zzef);
    }

    private final void zza(String string, long l, int n) {
        String string2 = zzr.zza(string, n);
        if (string2 != null) {
            switch (zzd.zzeb[n - 1]) {
                case 1: {
                    Log.e((String)"FirebasePerformance", (String)String.format("Cannot increment counter %s. Counter name is invalid.(%s)", string, string2));
                    return;
                }
                case 2: {
                    Log.e((String)"FirebasePerformance", (String)String.format("Cannot increment metric %s. Metric name is invalid.(%s)", string, string2));
                }
            }
            return;
        }
        if (!this.hasStarted()) {
            switch (zzd.zzeb[n - 1]) {
                case 1: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment counter '%s' for trace '%s' because it's not started", string, this.name));
                    return;
                }
                case 2: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment metric '%s' for trace '%s' because it's not started", string, this.name));
                }
            }
            return;
        }
        if (this.isStopped()) {
            switch (zzd.zzeb[n - 1]) {
                case 1: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment counter '%s' for trace '%s' because it's been stopped", string, this.name));
                    return;
                }
                case 2: {
                    Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment metric '%s' for trace '%s' because it's been stopped", string, this.name));
                }
            }
            return;
        }
        this.zzj(string.trim()).zzn(l);
    }

    @Deprecated
    @Keep
    public void incrementCounter(@NonNull String string) {
        this.incrementCounter(string, 1L);
    }

    @Keep
    public void incrementMetric(@NonNull String string, long l) {
        this.zza(string, l, zzt.zzeg);
    }

    @Keep
    public long getLongMetric(@NonNull String string) {
        zza zza2 = null;
        if (string != null) {
            zza2 = this.zzgk.get(string.trim());
        }
        if (zza2 == null) {
            return 0L;
        }
        return zza2.getCount();
    }

    @Keep
    public void putMetric(@NonNull String string, long l) {
        String string2 = zzr.zza(string, zzt.zzeg);
        if (string2 != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Cannot set value for metric %s. Metric name is invalid.(%s)", string, string2));
            return;
        }
        if (!this.hasStarted()) {
            Log.w((String)"FirebasePerformance", (String)String.format("Cannot set value for metric '%s' for trace '%s' because it's not started", string, this.name));
            return;
        }
        if (this.isStopped()) {
            Log.w((String)"FirebasePerformance", (String)String.format("Cannot set value for metric '%s' for trace '%s' because it's been stopped", string, this.name));
            return;
        }
        this.zzj(string.trim()).zzo(l);
    }

    protected void finalize() throws Throwable {
        try {
            Trace trace = this;
            if (trace.hasStarted() && !trace.isStopped()) {
                Log.w((String)"FirebasePerformance", (String)String.format("Trace '%s' is started but not stopped when it is destructed!", this.name));
                this.zzc(1);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @VisibleForTesting
    @NonNull
    final String getName() {
        return this.name;
    }

    @VisibleForTesting
    @NonNull
    final Map<String, zza> zzcq() {
        return this.zzgk;
    }

    @VisibleForTesting
    final zzbg zzcr() {
        return this.zzgn;
    }

    @VisibleForTesting
    final zzbg zzcs() {
        return this.zzgo;
    }

    @VisibleForTesting
    @NonNull
    final List<Trace> zzct() {
        return this.zzgj;
    }

    @VisibleForTesting
    private final boolean isStopped() {
        return this.zzgo != null;
    }

    @VisibleForTesting
    private final boolean hasStarted() {
        return this.zzgn != null;
    }

    @Keep
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        parcel.writeParcelable((Parcelable)this.zzgi, 0);
        parcel.writeString(this.name);
        parcel.writeList(this.zzgj);
        parcel.writeMap(this.zzgk);
        parcel.writeParcelable((Parcelable)this.zzgn, 0);
        parcel.writeParcelable((Parcelable)this.zzgo, 0);
        parcel.writeList(this.zzbj);
    }

    private Trace(@NonNull Parcel parcel, boolean bl) {
        super(bl ? null : com.google.firebase.perf.internal.zza.zzaj());
        this.zzgi = (Trace)parcel.readParcelable(Trace.class.getClassLoader());
        this.name = parcel.readString();
        this.zzgj = new ArrayList<Trace>();
        parcel.readList(this.zzgj, Trace.class.getClassLoader());
        this.zzgk = new ConcurrentHashMap<String, zza>();
        this.zzgm = new ConcurrentHashMap<String, String>();
        parcel.readMap(this.zzgk, zza.class.getClassLoader());
        this.zzgn = (zzbg)parcel.readParcelable(zzbg.class.getClassLoader());
        this.zzgo = (zzbg)parcel.readParcelable(zzbg.class.getClassLoader());
        this.zzbj = new ArrayList<zzs>();
        parcel.readList(this.zzbj, zzs.class.getClassLoader());
        if (bl) {
            this.zzcm = null;
            this.zzgl = null;
            this.zzbk = null;
            return;
        }
        this.zzcm = com.google.firebase.perf.internal.zzc.zzba();
        this.zzgl = new zzau();
        this.zzbk = GaugeManager.zzbe();
    }

    @Keep
    public void putAttribute(@NonNull String string, @NonNull String string2) {
        boolean bl = true;
        try {
            string = string.trim();
            String string3 = string2 = string2.trim();
            String string4 = string;
            Trace trace = this;
            if (trace.isStopped()) {
                throw new IllegalArgumentException(String.format(Locale.US, "Trace %s has been stopped", trace.name));
            }
            if (!trace.zzgm.containsKey(string4) && trace.zzgm.size() >= 5) {
                throw new IllegalArgumentException(String.format(Locale.US, "Exceeds max limit of number of attributes - %d", 5));
            }
            String string5 = zzr.zza(new AbstractMap.SimpleEntry<String, String>(string4, string3));
            if (string5 != null) {
                throw new IllegalArgumentException(string5);
            }
        }
        catch (Exception exception) {
            Log.e((String)"FirebasePerformance", (String)String.format("Can not set attribute %s with value %s (%s)", string, string2, exception.getMessage()));
            bl = false;
        }
        if (bl) {
            this.zzgm.put(string, string2);
        }
    }

    @Keep
    public void removeAttribute(@NonNull String string) {
        if (this.isStopped()) {
            Log.e((String)"FirebasePerformance", (String)"Can't remove a attribute from a Trace that's stopped.");
            return;
        }
        this.zzgm.remove(string);
    }

    @Nullable
    @Keep
    public String getAttribute(@NonNull String string) {
        return this.zzgm.get(string);
    }

    @NonNull
    @Keep
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzgm);
    }

    @Keep
    public int describeContents() {
        return 0;
    }

    @VisibleForTesting
    final List<zzs> getSessions() {
        return this.zzbj;
    }

    /* synthetic */ Trace(Parcel parcel, boolean bl, zzc zzc2) {
        this(parcel, bl);
    }
}

