/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zzag;
import com.google.android.gms.internal.firebase-perf.zzah;
import com.google.android.gms.internal.firebase-perf.zzai;
import com.google.android.gms.internal.firebase-perf.zzaj;
import com.google.android.gms.internal.firebase-perf.zzak;
import com.google.android.gms.internal.firebase-perf.zzal;
import com.google.android.gms.internal.firebase-perf.zzam;
import com.google.android.gms.internal.firebase-perf.zzan;
import com.google.android.gms.internal.firebase-perf.zzao;
import com.google.android.gms.internal.firebase-perf.zzap;
import com.google.android.gms.internal.firebase-perf.zzaq;
import com.google.android.gms.internal.firebase-perf.zzar;
import com.google.android.gms.internal.firebase-perf.zzas;
import com.google.android.gms.internal.firebase-perf.zzat;
import com.google.android.gms.internal.firebase-perf.zzau;
import com.google.android.gms.internal.firebase-perf.zzav;
import com.google.android.gms.internal.firebase-perf.zzaw;
import com.google.android.gms.internal.firebase-perf.zzax;
import com.google.android.gms.internal.firebase-perf.zzay;
import com.google.android.gms.internal.firebase-perf.zzaz;
import com.google.android.gms.internal.firebase-perf.zzbi;
import com.google.android.gms.internal.firebase-perf.zzbl;
import com.google.android.gms.internal.firebase-perf.zzbo;
import com.google.android.gms.internal.firebase-perf.zzbx;
import com.google.firebase.perf.internal.RemoteConfigManager;
import com.google.firebase.perf.internal.zzd;

public final class zzaf {
    private static volatile zzaf zzab;
    private zzbl zzaf;
    private RemoteConfigManager zzag = RemoteConfigManager.zzci();
    private zzay zzah;
    private zzbi zzai;

    @VisibleForTesting
    private zzaf(@Nullable RemoteConfigManager remoteConfigManager, @Nullable zzbl zzbl2, @Nullable zzay zzay2) {
        this.zzaf = new zzbl();
        this.zzah = zzay.zzbb();
        this.zzai = zzbi.zzcp();
    }

    public static synchronized zzaf zzm() {
        if (zzab == null) {
            zzab = new zzaf(null, null, null);
        }
        return zzab;
    }

    public final void zzb(Context context) {
        this.zzc(context.getApplicationContext());
    }

    public final void zzc(Context context) {
        zzbi.zzcp().zze(zzbx.zzg(context));
        this.zzah.zzd(context);
    }

    public final void zza(zzbl zzbl2) {
        this.zzaf = zzbl2;
    }

    public final boolean zzn() {
        Boolean bl = this.zzo();
        return (bl == null || bl == true) && this.zzq();
    }

    @Nullable
    public final Boolean zzo() {
        if (this.zzp().booleanValue()) {
            return false;
        }
        zzag zzag2 = com.google.android.gms.internal.firebase-perf.zzag.zzaf();
        zzbo<Boolean> zzbo2 = this.zzg(zzag2);
        if (zzbo2.isPresent()) {
            return this.zza(zzag2, zzbo2.get());
        }
        zzbo<Boolean> zzbo3 = this.zza(zzag2);
        if (zzbo3.isPresent()) {
            return this.zza(zzag2, zzbo3.get());
        }
        this.zzai.zzm("CollectionEnabled metadata key unknown or value not found in manifest.");
        return this.zza(zzag2, null);
    }

    @Nullable
    public final Boolean zzp() {
        zzah zzah2 = com.google.android.gms.internal.firebase-perf.zzah.zzai();
        zzbo<Boolean> zzbo2 = this.zza(zzah2);
        if (zzbo2.isPresent()) {
            return this.zza(zzah2, zzbo2.get());
        }
        return this.zza(zzah2, false);
    }

    public final void zza(boolean bl) {
        if (this.zzp().booleanValue()) {
            return;
        }
        String string = ((zzaz)com.google.android.gms.internal.firebase-perf.zzag.zzaf()).zzah();
        if (string != null) {
            this.zzah.zza(string, bl);
        }
    }

    public final boolean zzq() {
        zzbo<Object> zzbo2;
        boolean bl;
        zzaf zzaf2 = this;
        zzaf2.zzai.zzm("Retrieving master flag for Firebase Performance SDK enabled configuration value.");
        zzaz zzaz2 = zzap.zzas();
        zzap zzap2 = zzaz2;
        zzbo<Object> zzbo3 = zzaf2.zzag.zzb(((zzaz)zzap2).zzak());
        if (zzbo3.isPresent()) {
            if (zzaf2.zzag.zzcj()) {
                bl = zzaf2.zza(zzaz2, false);
            } else {
                zzaf2.zzah.zza(zzaz2.zzah(), zzbo3.get());
                bl = zzaf2.zza(zzaz2, zzbo3.get());
            }
        } else {
            zzbo2 = zzaf2.zzg(zzaz2);
            bl = zzbo2.isPresent() ? zzaf2.zza(zzaz2, zzbo2.get()).booleanValue() : zzaf2.zza(zzaz2, true).booleanValue();
        }
        if (bl) {
            boolean bl2;
            zzaf2 = this;
            zzaf2.zzai.zzm("Retrieving Firebase Performance SDK disabled versions configuration value.");
            zzaz2 = zzam.zzap();
            zzap2 = zzaz2;
            zzbo3 = zzaf2.zzag.zzc(((zzaz)zzap2).zzak());
            if (zzbo3.isPresent()) {
                zzaf2.zzah.zza(zzaz2.zzah(), (String)zzbo3.get());
                bl2 = zzaf2.zza(zzaz2, (String)zzbo3.get(), com.google.android.gms.internal.firebase-perf.zzaf.zza((String)zzbo3.get()));
            } else {
                zzbo2 = zzaf2.zzh(zzaz2);
                bl2 = zzbo2.isPresent() ? zzaf2.zza(zzaz2, (String)zzbo2.get(), com.google.android.gms.internal.firebase-perf.zzaf.zza((String)zzbo2.get())) : zzaf2.zza(zzaz2, "", com.google.android.gms.internal.firebase-perf.zzaf.zza(""));
            }
            if (!bl2) {
                return true;
            }
        }
        return false;
    }

    private static boolean zza(String string) {
        if (string.trim().isEmpty()) {
            return false;
        }
        String[] stringArray = string.split(";");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].trim().equals(zzd.VERSION_NAME)) continue;
            return true;
        }
        return false;
    }

    public final float zzr() {
        this.zzai.zzm("Retrieving trace sampling rate configuration value.");
        zzaw zzaw2 = zzaw.zzaz();
        zzbo<Float> zzbo2 = this.zzc(zzaw2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zza(zzbo2.get().floatValue())) {
            this.zzah.zza(((zzaz)zzaw2).zzah(), zzbo2.get().floatValue());
            return this.zza(zzaw2, zzbo2.get()).floatValue();
        }
        zzbo<Float> zzbo3 = this.zze(zzaw2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zza(zzbo3.get().floatValue())) {
            return this.zza(zzaw2, zzbo3.get()).floatValue();
        }
        return this.zza(zzaw2, Float.valueOf(1.0f)).floatValue();
    }

    public final float zzs() {
        this.zzai.zzm("Retrieving network request sampling rate configuration value.");
        zzak zzak2 = zzak.zzan();
        zzbo<Float> zzbo2 = this.zzc(zzak2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zza(zzbo2.get().floatValue())) {
            this.zzah.zza(((zzaz)zzak2).zzah(), zzbo2.get().floatValue());
            return this.zza(zzak2, zzbo2.get()).floatValue();
        }
        zzbo<Float> zzbo3 = this.zze(zzak2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zza(zzbo3.get().floatValue())) {
            return this.zza(zzak2, zzbo3.get()).floatValue();
        }
        return this.zza(zzak2, Float.valueOf(1.0f)).floatValue();
    }

    public final float zzt() {
        float f;
        zzav zzav2;
        this.zzai.zzm("Retrieving session sampling rate configuration value.");
        zzav zzav3 = zzav2 = zzav.zzay();
        zzbo<Float> zzbo2 = this.zzaf.zzd(((zzaz)zzav3).zzag());
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zza(f = zzbo2.get().floatValue() / 100.0f)) {
            return this.zza(zzav2, Float.valueOf(f)).floatValue();
        }
        zzbo<Float> zzbo3 = this.zzc(zzav2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zza(zzbo3.get().floatValue())) {
            this.zzah.zza(((zzaz)zzav2).zzah(), zzbo3.get().floatValue());
            return this.zza(zzav2, zzbo3.get()).floatValue();
        }
        zzbo<Float> zzbo4 = this.zze(zzav2);
        if (zzbo4.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zza(zzbo4.get().floatValue())) {
            return this.zza(zzav2, zzbo4.get()).floatValue();
        }
        return this.zza(zzav2, Float.valueOf(0.01f)).floatValue();
    }

    public final long zzu() {
        this.zzai.zzm("Retrieving Session CPU Capture Frequency on foreground (milliseonds) configuration value.");
        zzar zzar2 = zzar.zzau();
        zzbo<Long> zzbo2 = this.zzb(zzar2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo2.get())) {
            return this.zza(zzar2, zzbo2.get());
        }
        zzbo<Long> zzbo3 = this.zzd(zzar2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo3.get())) {
            this.zzah.zza(((zzaz)zzar2).zzah(), zzbo3.get());
            return this.zza(zzar2, zzbo3.get());
        }
        zzbo<Long> zzbo4 = this.zzf(zzar2);
        if (zzbo4.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo4.get())) {
            return this.zza(zzar2, zzbo4.get());
        }
        return this.zza(zzar2, 100L);
    }

    public final long zzv() {
        this.zzai.zzm("Retrieving Session CPU Capture Frequency on background (milliseonds) configuration value.");
        zzao zzao2 = zzao.zzar();
        zzbo<Long> zzbo2 = this.zzb(zzao2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo2.get())) {
            return this.zza(zzao2, zzbo2.get());
        }
        zzbo<Long> zzbo3 = this.zzd(zzao2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo3.get())) {
            this.zzah.zza(((zzaz)zzao2).zzah(), zzbo3.get());
            return this.zza(zzao2, zzbo3.get());
        }
        zzbo<Long> zzbo4 = this.zzf(zzao2);
        if (zzbo4.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo4.get())) {
            return this.zza(zzao2, zzbo4.get());
        }
        return this.zza(zzao2, 0L);
    }

    public final long zzw() {
        this.zzai.zzm("Retrieving Session Memory Capture Frequency on foreground (milliseonds) configuration value.");
        zzas zzas2 = zzas.zzav();
        zzbo<Long> zzbo2 = this.zzb(zzas2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo2.get())) {
            return this.zza(zzas2, zzbo2.get());
        }
        zzbo<Long> zzbo3 = this.zzd(zzas2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo3.get())) {
            this.zzah.zza(((zzaz)zzas2).zzah(), zzbo3.get());
            return this.zza(zzas2, zzbo3.get());
        }
        zzbo<Long> zzbo4 = this.zzf(zzas2);
        if (zzbo4.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo4.get())) {
            return this.zza(zzas2, zzbo4.get());
        }
        return this.zza(zzas2, 100L);
    }

    public final long zzx() {
        this.zzai.zzm("Retrieving Session Memory Capture Frequency on background (milliseonds) configuration value.");
        zzat zzat2 = zzat.zzaw();
        zzbo<Long> zzbo2 = this.zzb(zzat2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo2.get())) {
            return this.zza(zzat2, zzbo2.get());
        }
        zzbo<Long> zzbo3 = this.zzd(zzat2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo3.get())) {
            this.zzah.zza(((zzaz)zzat2).zzah(), zzbo3.get());
            return this.zza(zzat2, zzbo3.get());
        }
        zzbo<Long> zzbo4 = this.zzf(zzat2);
        if (zzbo4.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzd(zzbo4.get())) {
            return this.zza(zzat2, zzbo4.get());
        }
        return this.zza(zzat2, 0L);
    }

    public final long zzy() {
        this.zzai.zzm("Retrieving Max Duration (in minutes) of single Session configuration value.");
        zzaq zzaq2 = zzaq.zzat();
        zzbo<Long> zzbo2 = this.zzb(zzaq2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zze(zzbo2.get())) {
            return this.zza(zzaq2, zzbo2.get());
        }
        zzbo<Long> zzbo3 = this.zzd(zzaq2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zze(zzbo3.get())) {
            this.zzah.zza(((zzaz)zzaq2).zzah(), zzbo3.get());
            return this.zza(zzaq2, zzbo3.get());
        }
        zzbo<Long> zzbo4 = this.zzf(zzaq2);
        if (zzbo4.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zze(zzbo4.get())) {
            return this.zza(zzaq2, zzbo4.get());
        }
        return this.zza(zzaq2, 240L);
    }

    public final long zzz() {
        this.zzai.zzm("Retrieving trace event count foreground configuration value.");
        zzax zzax2 = zzax.zzba();
        zzbo<Long> zzbo2 = this.zzd(zzax2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzb(zzbo2.get())) {
            this.zzah.zza(((zzaz)zzax2).zzah(), zzbo2.get());
            return this.zza(zzax2, zzbo2.get());
        }
        zzbo<Long> zzbo3 = this.zzf(zzax2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzb(zzbo3.get())) {
            return this.zza(zzax2, zzbo3.get());
        }
        return this.zza(zzax2, 300L);
    }

    public final long zzaa() {
        this.zzai.zzm("Retrieving trace event count background configuration value.");
        zzau zzau2 = zzau.zzax();
        zzbo<Long> zzbo2 = this.zzd(zzau2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzb(zzbo2.get())) {
            this.zzah.zza(((zzaz)zzau2).zzah(), zzbo2.get());
            return this.zza(zzau2, zzbo2.get());
        }
        zzbo<Long> zzbo3 = this.zzf(zzau2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzb(zzbo3.get())) {
            return this.zza(zzau2, zzbo3.get());
        }
        return this.zza(zzau2, 30L);
    }

    public final long zzab() {
        this.zzai.zzm("Retrieving network event count foreground configuration value.");
        zzal zzal2 = zzal.zzao();
        zzbo<Long> zzbo2 = this.zzd(zzal2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzb(zzbo2.get())) {
            this.zzah.zza(((zzaz)zzal2).zzah(), zzbo2.get());
            return this.zza(zzal2, zzbo2.get());
        }
        zzbo<Long> zzbo3 = this.zzf(zzal2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzb(zzbo3.get())) {
            return this.zza(zzal2, zzbo3.get());
        }
        return this.zza(zzal2, 700L);
    }

    public final long zzac() {
        this.zzai.zzm("Retrieving network event count background configuration value.");
        zzai zzai2 = com.google.android.gms.internal.firebase-perf.zzai.zzaj();
        zzbo<Long> zzbo2 = this.zzd(zzai2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzb(zzbo2.get())) {
            this.zzah.zza(((zzaz)zzai2).zzah(), zzbo2.get());
            return this.zza(zzai2, zzbo2.get());
        }
        zzbo<Long> zzbo3 = this.zzf(zzai2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzb(zzbo3.get())) {
            return this.zza(zzai2, zzbo3.get());
        }
        return this.zza(zzai2, 70L);
    }

    public final long zzad() {
        this.zzai.zzm("Retrieving rate limiting time range (in seconds) configuration value.");
        zzan zzan2 = zzan.zzaq();
        zzbo<Long> zzbo2 = this.zzd(zzan2);
        if (zzbo2.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzc(zzbo2.get())) {
            this.zzah.zza(((zzaz)zzan2).zzah(), zzbo2.get());
            return this.zza(zzan2, zzbo2.get());
        }
        zzbo<Long> zzbo3 = this.zzf(zzan2);
        if (zzbo3.isPresent() && com.google.android.gms.internal.firebase-perf.zzaf.zzc(zzbo3.get())) {
            return this.zza(zzan2, zzbo3.get());
        }
        return this.zza(zzan2, 600L);
    }

    public final String zzae() {
        zzbo<String> zzbo2;
        zzaj zzaj2 = zzaj.zzal();
        if (zzd.zzcx) {
            return this.zza(zzaj2, zzaj.zzam());
        }
        String string = ((zzaz)zzaj2).zzak();
        long l = string == null ? -1L : this.zzag.zza(string, -1L);
        String string2 = ((zzaz)zzaj2).zzah();
        if (zzaj.zzg(l) && (zzbo2 = zzaj.zzf(l)) != null) {
            this.zzah.zza(string2, (String)((Object)zzbo2));
            return (String)this.zza(zzaj2, zzbo2);
        }
        zzbo2 = this.zzh(zzaj2);
        if (zzbo2.isPresent()) {
            return this.zza(zzaj2, (String)zzbo2.get());
        }
        return this.zza(zzaj2, zzaj.zzam());
    }

    private final zzbo<Boolean> zza(zzaz<Boolean> zzaz2) {
        return this.zzaf.zzb(zzaz2.zzag());
    }

    private final zzbo<Long> zzb(zzaz<Long> zzaz2) {
        return this.zzaf.zze(zzaz2.zzag());
    }

    private final zzbo<Float> zzc(zzaz<Float> zzaz2) {
        return this.zzag.zzd(zzaz2.zzak());
    }

    private final zzbo<Long> zzd(zzaz<Long> zzaz2) {
        return this.zzag.zze(zzaz2.zzak());
    }

    private final zzbo<Float> zze(zzaz<Float> zzaz2) {
        return this.zzah.zzd(zzaz2.zzah());
    }

    private final zzbo<Long> zzf(zzaz<Long> zzaz2) {
        return this.zzah.zze(zzaz2.zzah());
    }

    private final zzbo<Boolean> zzg(zzaz<Boolean> zzaz2) {
        return this.zzah.zzb(zzaz2.zzah());
    }

    private final zzbo<String> zzh(zzaz<String> zzaz2) {
        return this.zzah.zzc(zzaz2.zzah());
    }

    private static boolean zza(float f) {
        return 0.0f <= f && f <= 1.0f;
    }

    private static boolean zzb(long l) {
        return l >= 0L;
    }

    private static boolean zzc(long l) {
        return l > 0L;
    }

    private static boolean zzd(long l) {
        return l >= 0L;
    }

    private static boolean zze(long l) {
        return l > 0L;
    }

    private final <T> T zza(zzaz<T> zzaz2, T t) {
        this.zzai.zzm(String.format("Config resolver result for flag: '%s' is: '%s'.", zzaz2.getClass().getName(), String.valueOf(t)));
        return t;
    }

    private final <T> boolean zza(zzaz<T> zzaz2, T t, boolean bl) {
        this.zzai.zzm(String.format("Config resolver result for flag: '%s' is: '%s'. Resolving value as '%s'", zzaz2.getClass().getName(), String.valueOf(t), String.valueOf(bl)));
        return bl;
    }
}

