/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zzbi;
import com.google.android.gms.internal.firebase-perf.zzbo;
import com.google.firebase.FirebaseApp;

@VisibleForTesting(otherwise=3)
public final class zzay {
    private static zzay zzbc;
    private SharedPreferences zzbd;
    private zzbi zzai = zzbi.zzcp();

    @VisibleForTesting
    private zzay() {
    }

    public static synchronized zzay zzbb() {
        if (zzbc == null) {
            zzbc = new zzay();
        }
        return zzbc;
    }

    public final synchronized void zzd(Context context) {
        if (this.zzbd == null && context != null) {
            this.zzbd = context.getSharedPreferences("FirebasePerfSharedPrefs", 0);
        }
    }

    public final zzbo<Boolean> zzb(String string) {
        if (string == null) {
            this.zzai.zzm("Key is null when getting boolean value on device cache.");
            return zzbo.zzda();
        }
        if (this.zzbd == null) {
            this.zzd(zzay.zzbc());
            if (this.zzbd == null) {
                return zzbo.zzda();
            }
        }
        if (!this.zzbd.contains(string)) {
            return zzbo.zzda();
        }
        try {
            return zzbo.zzb(this.zzbd.getBoolean(string, false));
        }
        catch (ClassCastException classCastException) {
            this.zzai.zzm(String.format("Key %s from sharedPreferences has type other than long: %s", string, classCastException.getMessage()));
            return zzbo.zzda();
        }
    }

    public final boolean zza(String string, boolean bl) {
        if (string == null) {
            this.zzai.zzm("Key is null when setting boolean value on device cache.");
            return false;
        }
        if (this.zzbd == null) {
            this.zzd(zzay.zzbc());
            if (this.zzbd == null) {
                return false;
            }
        }
        this.zzbd.edit().putBoolean(string, bl).apply();
        return true;
    }

    public final zzbo<String> zzc(String string) {
        if (string == null) {
            this.zzai.zzm("Key is null when getting String value on device cache.");
            return zzbo.zzda();
        }
        if (this.zzbd == null) {
            this.zzd(zzay.zzbc());
            if (this.zzbd == null) {
                return zzbo.zzda();
            }
        }
        if (!this.zzbd.contains(string)) {
            return zzbo.zzda();
        }
        try {
            return zzbo.zzb(this.zzbd.getString(string, ""));
        }
        catch (ClassCastException classCastException) {
            this.zzai.zzm(String.format("Key %s from sharedPreferences has type other than String: %s", string, classCastException.getMessage()));
            return zzbo.zzda();
        }
    }

    public final boolean zza(String string, String string2) {
        if (string == null) {
            this.zzai.zzm("Key is null when setting String value on device cache.");
            return false;
        }
        if (this.zzbd == null) {
            this.zzd(zzay.zzbc());
            if (this.zzbd == null) {
                return false;
            }
        }
        if (string2 == null) {
            this.zzbd.edit().remove(string).apply();
            return true;
        }
        this.zzbd.edit().putString(string, string2).apply();
        return true;
    }

    public final zzbo<Float> zzd(String string) {
        if (string == null) {
            this.zzai.zzm("Key is null when getting float value on device cache.");
            return zzbo.zzda();
        }
        if (this.zzbd == null) {
            this.zzd(zzay.zzbc());
            if (this.zzbd == null) {
                return zzbo.zzda();
            }
        }
        if (!this.zzbd.contains(string)) {
            return zzbo.zzda();
        }
        try {
            return zzbo.zzb(Float.valueOf(this.zzbd.getFloat(string, 0.0f)));
        }
        catch (ClassCastException classCastException) {
            this.zzai.zzm(String.format("Key %s from sharedPreferences has type other than float: %s", string, classCastException.getMessage()));
            return zzbo.zzda();
        }
    }

    public final boolean zza(String string, float f) {
        if (string == null) {
            this.zzai.zzm("Key is null when setting float value on device cache.");
            return false;
        }
        if (this.zzbd == null) {
            this.zzd(zzay.zzbc());
            if (this.zzbd == null) {
                return false;
            }
        }
        this.zzbd.edit().putFloat(string, f).apply();
        return true;
    }

    public final zzbo<Long> zze(String string) {
        if (string == null) {
            this.zzai.zzm("Key is null when getting long value on device cache.");
            return zzbo.zzda();
        }
        if (this.zzbd == null) {
            this.zzd(zzay.zzbc());
            if (this.zzbd == null) {
                return zzbo.zzda();
            }
        }
        if (!this.zzbd.contains(string)) {
            return zzbo.zzda();
        }
        try {
            return zzbo.zzb(this.zzbd.getLong(string, 0L));
        }
        catch (ClassCastException classCastException) {
            this.zzai.zzm(String.format("Key %s from sharedPreferences has type other than long: %s", string, classCastException.getMessage()));
            return zzbo.zzda();
        }
    }

    public final boolean zza(String string, long l) {
        if (string == null) {
            this.zzai.zzm("Key is null when setting long value on device cache.");
            return false;
        }
        if (this.zzbd == null) {
            this.zzd(zzay.zzbc());
            if (this.zzbd == null) {
                return false;
            }
        }
        this.zzbd.edit().putLong(string, l).apply();
        return true;
    }

    @Nullable
    private static Context zzbc() {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        return FirebaseApp.getInstance().getApplicationContext();
    }
}

