/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import android.os.Build;
import android.os.Process;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase-perf.zzaa;
import com.google.android.gms.internal.firebase-perf.zzba;
import com.google.android.gms.internal.firebase-perf.zzbd;
import com.google.android.gms.internal.firebase-perf.zzbt;
import com.google.android.gms.internal.firebase-perf.zzch;
import com.google.android.gms.internal.firebase-perf.zzfc;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class zzbb {
    private static final long zzbg = TimeUnit.SECONDS.toMicros(1L);
    @Nullable
    private static zzbb zzbh = null;
    @Nullable
    private ScheduledFuture zzbi = null;
    private final ScheduledExecutorService zzbj;
    private long zzbk = -1L;
    private final long zzbl;
    private final String zzbm;
    public final ConcurrentLinkedQueue<zzch> zzbn = new ConcurrentLinkedQueue();

    private zzbb() {
        this.zzbj = Executors.newSingleThreadScheduledExecutor();
        int n = Process.myPid();
        String string = Integer.toString(n);
        this.zzbm = new StringBuilder(11 + String.valueOf(string).length()).append("/proc/").append(string).append("/stat").toString();
        this.zzbl = Build.VERSION.SDK_INT >= 21 ? Os.sysconf((int)OsConstants._SC_CLK_TCK) : -1L;
    }

    public static zzbb zzbd() {
        if (zzbh == null) {
            zzbh = new zzbb();
        }
        return zzbh;
    }

    public final void zza(long l, zzbt zzbt2) {
        if (this.zzbl == -1L || this.zzbl == 0L) {
            return;
        }
        if (zzbb.zzi(l)) {
            return;
        }
        if (this.zzbi != null) {
            if (this.zzbk != l) {
                this.zzbe();
                this.zzb(l, zzbt2);
            }
            return;
        }
        this.zzb(l, zzbt2);
    }

    public final void zzbe() {
        if (this.zzbi == null) {
            return;
        }
        this.zzbi.cancel(false);
        this.zzbi = null;
        this.zzbk = -1L;
    }

    public final void zza(zzbt zzbt2) {
        this.zzb(zzbt2);
    }

    private final synchronized void zzb(long l, zzbt zzbt2) {
        this.zzbk = l;
        try {
            this.zzbi = this.zzbj.scheduleAtFixedRate(new zzba(this, zzbt2), 0L, l, TimeUnit.MILLISECONDS);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            String string = String.valueOf(rejectedExecutionException.getMessage());
            Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Unable to start collecting Cpu Metrics: ".concat(string) : new String("Unable to start collecting Cpu Metrics: ")));
            return;
        }
    }

    private final synchronized void zzb(zzbt zzbt2) {
        try {
            this.zzbj.schedule(new zzbd(this, zzbt2), 0L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            String string = String.valueOf(rejectedExecutionException.getMessage());
            Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Unable to collect Cpu Metric: ".concat(string) : new String("Unable to collect Cpu Metric: ")));
            return;
        }
    }

    @Nullable
    private final zzch zzc(zzbt zzbt2) {
        block9: {
            zzch zzch2;
            if (zzbt2 == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.zzbm));
            try {
                long l = zzbt2.zzdc();
                String[] stringArray = bufferedReader.readLine().split(" ");
                long l2 = Long.parseLong(stringArray[13]);
                long l3 = Long.parseLong(stringArray[15]);
                long l4 = Long.parseLong(stringArray[14]);
                long l5 = Long.parseLong(stringArray[16]);
                zzch2 = (zzch)((zzfc)zzch.zzdr().zzy(l).zzaa(this.zzh(l4 + l5)).zzz(this.zzh(l2 + l3)).zzhq());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable2) {
                        zzaa.zza(throwable, throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    String string = String.valueOf(iOException.getMessage());
                    Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Unable to read 'proc/[pid]/stat' file: ".concat(string) : new String("Unable to read 'proc/[pid]/stat' file: ")));
                    break block9;
                }
                catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException runtimeException) {
                    String string = String.valueOf(runtimeException.getMessage());
                    Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Unexpected '/proc/[pid]/stat' file format encountered: ".concat(string) : new String("Unexpected '/proc/[pid]/stat' file format encountered: ")));
                }
            }
            bufferedReader.close();
            return zzch2;
        }
        return null;
    }

    private final long zzh(long l) {
        return Math.round((double)l / (double)this.zzbl * (double)zzbg);
    }

    public static boolean zzi(long l) {
        return l <= 0L;
    }

    final /* synthetic */ void zzd(zzbt zzbt2) {
        zzch zzch2 = this.zzc(zzbt2);
        if (zzch2 != null) {
            this.zzbn.add(zzch2);
        }
    }

    final /* synthetic */ void zze(zzbt zzbt2) {
        zzch zzch2 = this.zzc(zzbt2);
        if (zzch2 != null) {
            this.zzbn.add(zzch2);
        }
    }
}

