/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzdw;
import com.google.android.gms.internal.firebase-perf.zzfg;
import com.google.android.gms.internal.firebase-perf.zzfk;
import com.google.android.gms.internal.firebase-perf.zzfm;
import com.google.android.gms.internal.firebase-perf.zzgy;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfe
extends zzdw<Integer>
implements zzfk,
zzgy,
RandomAccess {
    private static final zzfe zzqt = new zzfe(new int[0], 0);
    private int[] zzqu;
    private int size;

    public static zzfe zzhr() {
        return zzqt;
    }

    zzfe() {
        this(new int[10], 0);
    }

    private zzfe(int[] nArray, int n) {
        this.zzqu = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzgi();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzqu, n2, this.zzqu, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfe)) {
            return super.equals(object);
        }
        zzfe zzfe2 = (zzfe)object;
        if (this.size != zzfe2.size) {
            return false;
        }
        int[] nArray = zzfe2.zzqu;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzqu[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzqu[i];
        }
        return n;
    }

    @Override
    public final zzfk zzak(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzfe(Arrays.copyOf(this.zzqu, n), this.size);
    }

    @Override
    public final int getInt(int n) {
        this.zzam(n);
        return this.zzqu[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n = (Integer)object;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.zzqu[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzal(int n) {
        this.zzgi();
        if (this.size == this.zzqu.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzqu, 0, nArray, 0, this.size);
            this.zzqu = nArray;
        }
        this.zzqu[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzgi();
        zzfg.checkNotNull(collection);
        if (!(collection instanceof zzfe)) {
            return super.addAll(collection);
        }
        zzfe zzfe2 = (zzfe)collection;
        if (zzfe2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfe2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfe2.size;
        if (n > this.zzqu.length) {
            this.zzqu = Arrays.copyOf(this.zzqu, n);
        }
        System.arraycopy(zzfe2.zzqu, 0, this.zzqu, this.size, zzfe2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzgi();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzqu[i])) continue;
            System.arraycopy(this.zzqu, i + 1, this.zzqu, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzam(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzan(n));
        }
    }

    private final String zzan(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzfe zzfe2 = this;
        zzfe2.zzgi();
        zzfe2.zzam(n);
        int n4 = zzfe2.zzqu[n];
        zzfe2.zzqu[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfe zzfe2 = this;
        zzfe2.zzgi();
        zzfe2.zzam(n);
        int n2 = zzfe2.zzqu[n];
        if (n < zzfe2.size - 1) {
            System.arraycopy(zzfe2.zzqu, n + 1, zzfe2.zzqu, n, zzfe2.size - n - 1);
        }
        --zzfe2.size;
        ++zzfe2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzfe zzfe2 = this;
        zzfe2.zzgi();
        if (n < 0 || n > zzfe2.size) {
            throw new IndexOutOfBoundsException(zzfe2.zzan(n));
        }
        if (zzfe2.size < zzfe2.zzqu.length) {
            System.arraycopy(zzfe2.zzqu, n, zzfe2.zzqu, n + 1, zzfe2.size - n);
        } else {
            int[] nArray = new int[zzfe2.size * 3 / 2 + 1];
            System.arraycopy(zzfe2.zzqu, 0, nArray, 0, n);
            System.arraycopy(zzfe2.zzqu, n, nArray, n + 1, zzfe2.size - n);
            zzfe2.zzqu = nArray;
        }
        zzfe2.zzqu[n] = n3;
        ++zzfe2.size;
        ++zzfe2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Integer n = (Integer)object;
        this.zzal(n);
        return true;
    }

    @Override
    public final /* synthetic */ zzfm zzao(int n) {
        return this.zzak(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzqt.zzgh();
    }
}

