/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzdw;
import com.google.android.gms.internal.firebase-perf.zzfg;
import com.google.android.gms.internal.firebase-perf.zzfm;
import com.google.android.gms.internal.firebase-perf.zzgy;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfz
extends zzdw<Long>
implements zzfm<Long>,
zzgy,
RandomAccess {
    private static final zzfz zzsf = new zzfz(new long[0], 0);
    private long[] zzsg;
    private int size;

    zzfz() {
        this(new long[10], 0);
    }

    private zzfz(long[] lArray, int n) {
        this.zzsg = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzgi();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzsg, n2, this.zzsg, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfz)) {
            return super.equals(object);
        }
        zzfz zzfz2 = (zzfz)object;
        if (this.size != zzfz2.size) {
            return false;
        }
        long[] lArray = zzfz2.zzsg;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzsg[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzfg.zzaz(this.zzsg[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzam(n);
        return this.zzsg[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Long)) {
            return -1;
        }
        long l = (Long)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzsg[i] != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzgi();
        zzfg.checkNotNull(collection);
        if (!(collection instanceof zzfz)) {
            return super.addAll(collection);
        }
        zzfz zzfz2 = (zzfz)collection;
        if (zzfz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfz2.size;
        if (n > this.zzsg.length) {
            this.zzsg = Arrays.copyOf(this.zzsg, n);
        }
        System.arraycopy(zzfz2.zzsg, 0, this.zzsg, this.size, zzfz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzgi();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzsg[i])) continue;
            System.arraycopy(this.zzsg, i + 1, this.zzsg, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzam(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzan(n));
        }
    }

    private final String zzan(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzfz zzfz2 = this;
        zzfz2.zzgi();
        zzfz2.zzam(n);
        long l3 = zzfz2.zzsg[n];
        zzfz2.zzsg[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfz zzfz2 = this;
        zzfz2.zzgi();
        zzfz2.zzam(n);
        long l = zzfz2.zzsg[n];
        if (n < zzfz2.size - 1) {
            System.arraycopy(zzfz2.zzsg, n + 1, zzfz2.zzsg, n, zzfz2.size - n - 1);
        }
        --zzfz2.size;
        ++zzfz2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzfz zzfz2 = this;
        zzfz2.zzgi();
        if (n < 0 || n > zzfz2.size) {
            throw new IndexOutOfBoundsException(zzfz2.zzan(n));
        }
        if (zzfz2.size < zzfz2.zzsg.length) {
            System.arraycopy(zzfz2.zzsg, n, zzfz2.zzsg, n + 1, zzfz2.size - n);
        } else {
            long[] lArray = new long[zzfz2.size * 3 / 2 + 1];
            System.arraycopy(zzfz2.zzsg, 0, lArray, 0, n);
            System.arraycopy(zzfz2.zzsg, n, lArray, n + 1, zzfz2.size - n);
            zzfz2.zzsg = lArray;
        }
        zzfz2.zzsg[n] = l2;
        ++zzfz2.size;
        ++zzfz2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzfz zzfz2 = this;
        zzfz2.zzgi();
        if (zzfz2.size == zzfz2.zzsg.length) {
            long[] lArray = new long[zzfz2.size * 3 / 2 + 1];
            System.arraycopy(zzfz2.zzsg, 0, lArray, 0, zzfz2.size);
            zzfz2.zzsg = lArray;
        }
        zzfz2.zzsg[zzfz2.size++] = l2;
        return true;
    }

    @Override
    public final /* synthetic */ zzfm zzao(int n) {
        int n2 = n;
        zzfz zzfz2 = this;
        if (n2 < zzfz2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfz(Arrays.copyOf(zzfz2.zzsg, n2), zzfz2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzsf.zzgh();
    }
}

