/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zzaf;
import com.google.android.gms.internal.firebase-perf.zzbl;
import com.google.android.gms.internal.firebase-perf.zzbt;
import com.google.firebase.FirebaseApp;
import com.google.firebase.perf.internal.GaugeManager;
import com.google.firebase.perf.internal.RemoteConfigManager;
import com.google.firebase.perf.internal.zzf;
import com.google.firebase.perf.metrics.HttpMetric;
import com.google.firebase.perf.metrics.Trace;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FirebasePerformance {
    public static final int MAX_TRACE_NAME_LENGTH = 100;
    private static volatile FirebasePerformance zzz;
    private final Map<String, String> zzaa = new ConcurrentHashMap<String, String>();
    private final zzaf zzab;
    private final zzbl zzac;
    @Nullable
    private Boolean zzad = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static FirebasePerformance getInstance() {
        if (zzz != null) return zzz;
        Class<FirebasePerformance> clazz = FirebasePerformance.class;
        synchronized (FirebasePerformance.class) {
            if (zzz != null) return zzz;
            zzz = (FirebasePerformance)FirebaseApp.getInstance().get(FirebasePerformance.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzz;
        }
    }

    FirebasePerformance(FirebaseApp firebaseApp, FirebaseRemoteConfig firebaseRemoteConfig) {
        this(firebaseApp, firebaseRemoteConfig, RemoteConfigManager.zzci(), zzaf.zzm(), GaugeManager.zzby());
    }

    @VisibleForTesting
    private FirebasePerformance(FirebaseApp firebaseApp, FirebaseRemoteConfig firebaseRemoteConfig, RemoteConfigManager remoteConfigManager, zzaf zzaf2, GaugeManager gaugeManager) {
        if (firebaseApp == null) {
            this.zzad = false;
            this.zzab = zzaf2;
            this.zzac = new zzbl(new Bundle());
            return;
        }
        Context context = firebaseApp.getApplicationContext();
        this.zzac = FirebasePerformance.zza(context);
        remoteConfigManager.zza(firebaseRemoteConfig);
        this.zzab = zzaf2;
        this.zzab.zza(this.zzac);
        this.zzab.zzc(context);
        gaugeManager.zzc(context);
        this.zzad = zzaf2.zzo();
    }

    @NonNull
    public static Trace startTrace(@NonNull String string) {
        Trace trace = Trace.zzn(string);
        trace.start();
        return trace;
    }

    public void setPerformanceCollectionEnabled(boolean bl) {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        if (this.zzab.zzp().booleanValue()) {
            Log.i((String)"FirebasePerformance", (String)"Firebase Performance is permanently disabled");
            return;
        }
        this.zzad = bl;
        this.zzab.zza(bl);
        if (bl) {
            Log.i((String)"FirebasePerformance", (String)"Firebase Performance is Enabled");
            return;
        }
        Log.i((String)"FirebasePerformance", (String)"Firebase Performance is Disabled");
    }

    public boolean isPerformanceCollectionEnabled() {
        if (this.zzad != null) {
            return this.zzad;
        }
        return FirebaseApp.getInstance().isDataCollectionDefaultEnabled();
    }

    @NonNull
    public final Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzaa);
    }

    @NonNull
    public Trace newTrace(@NonNull String string) {
        return Trace.zzn(string);
    }

    @NonNull
    public HttpMetric newHttpMetric(@NonNull String string, @NonNull String string2) {
        return new HttpMetric(string, string2, zzf.zzbt(), new zzbt());
    }

    @NonNull
    public HttpMetric newHttpMetric(@NonNull URL uRL, @NonNull String string) {
        return new HttpMetric(uRL, string, zzf.zzbt(), new zzbt());
    }

    private static zzbl zza(Context context) {
        Bundle bundle = null;
        try {
            bundle = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            String string = String.valueOf(throwable.getMessage());
            Log.d((String)"isEnabled", (String)(string.length() != 0 ? "No perf enable meta data found ".concat(string) : new String("No perf enable meta data found ")));
        }
        if (bundle != null) {
            return new zzbl(bundle);
        }
        return new zzbl();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HttpMethod {
        public static final String GET = "GET";
        public static final String PUT = "PUT";
        public static final String POST = "POST";
        public static final String DELETE = "DELETE";
        public static final String HEAD = "HEAD";
        public static final String PATCH = "PATCH";
        public static final String OPTIONS = "OPTIONS";
        public static final String TRACE = "TRACE";
        public static final String CONNECT = "CONNECT";
    }
}

