/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zzbi;
import com.google.android.gms.internal.firebase-perf.zzbo;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.firebase.perf.internal.zzw;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Keep
public class RemoteConfigManager {
    private static final RemoteConfigManager zzfb = new RemoteConfigManager();
    private static final long zzfc = TimeUnit.HOURS.toMillis(12L);
    private long zzfd = 0L;
    @Nullable
    private FirebaseRemoteConfig zzfe;
    private final Executor executor;
    private zzbi zzai;

    private RemoteConfigManager() {
        this(new ThreadPoolExecutor(0, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()), null);
    }

    @VisibleForTesting
    private RemoteConfigManager(Executor executor, FirebaseRemoteConfig firebaseRemoteConfig) {
        this.executor = executor;
        this.zzfe = null;
        this.zzai = zzbi.zzcp();
    }

    public static RemoteConfigManager zzci() {
        return zzfb;
    }

    public final void zza(FirebaseRemoteConfig firebaseRemoteConfig) {
        this.zzfe = firebaseRemoteConfig;
    }

    public final zzbo<Float> zzd(String string) {
        block4: {
            if (string == null) {
                this.zzai.zzm("The key to get Remote Config float value is null.");
                return zzbo.zzda();
            }
            FirebaseRemoteConfigValue firebaseRemoteConfigValue = this.zzl(string);
            if (firebaseRemoteConfigValue != null) {
                try {
                    return zzbo.zzb(Float.valueOf(Double.valueOf(firebaseRemoteConfigValue.asDouble()).floatValue()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (firebaseRemoteConfigValue.asString().isEmpty()) break block4;
                    this.zzai.zzm(String.format("Could not parse value: '%s' for key: '%s'.", firebaseRemoteConfigValue.asString(), string));
                }
            }
        }
        return zzbo.zzda();
    }

    public final zzbo<Long> zze(String string) {
        block4: {
            if (string == null) {
                this.zzai.zzm("The key to get Remote Config long value is null.");
                return zzbo.zzda();
            }
            FirebaseRemoteConfigValue firebaseRemoteConfigValue = this.zzl(string);
            if (firebaseRemoteConfigValue != null) {
                try {
                    return zzbo.zzb(firebaseRemoteConfigValue.asLong());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (firebaseRemoteConfigValue.asString().isEmpty()) break block4;
                    this.zzai.zzm(String.format("Could not parse value: '%s' for key: '%s'.", firebaseRemoteConfigValue.asString(), string));
                }
            }
        }
        return zzbo.zzda();
    }

    public final zzbo<Boolean> zzb(String string) {
        block4: {
            if (string == null) {
                this.zzai.zzm("The key to get Remote Config boolean value is null.");
                return zzbo.zzda();
            }
            FirebaseRemoteConfigValue firebaseRemoteConfigValue = this.zzl(string);
            if (firebaseRemoteConfigValue != null) {
                try {
                    return zzbo.zzb(firebaseRemoteConfigValue.asBoolean());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (firebaseRemoteConfigValue.asString().isEmpty()) break block4;
                    this.zzai.zzm(String.format("Could not parse value: '%s' for key: '%s'.", firebaseRemoteConfigValue.asString(), string));
                }
            }
        }
        return zzbo.zzda();
    }

    public final zzbo<String> zzc(String string) {
        if (string == null) {
            this.zzai.zzm("The key to get Remote Config String value is null.");
            return zzbo.zzda();
        }
        FirebaseRemoteConfigValue firebaseRemoteConfigValue = this.zzl(string);
        if (firebaseRemoteConfigValue != null) {
            return zzbo.zzb(firebaseRemoteConfigValue.asString());
        }
        return zzbo.zzda();
    }

    public final <T> T zza(String string, T t) {
        Object object;
        block11: {
            object = t;
            FirebaseRemoteConfigValue firebaseRemoteConfigValue = this.zzl(string);
            if (firebaseRemoteConfigValue != null) {
                try {
                    if (t instanceof Boolean) {
                        object = firebaseRemoteConfigValue.asBoolean();
                    } else if (t instanceof Float) {
                        object = Float.valueOf(Double.valueOf(firebaseRemoteConfigValue.asDouble()).floatValue());
                    } else if (t instanceof Long || t instanceof Integer) {
                        object = firebaseRemoteConfigValue.asLong();
                    } else if (t instanceof String) {
                        object = firebaseRemoteConfigValue.asString();
                    } else {
                        object = firebaseRemoteConfigValue.asString();
                        this.zzai.zzm(String.format("No matching type found for the defaultValue: '%s', using String.", t));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (firebaseRemoteConfigValue.asString().isEmpty()) break block11;
                    this.zzai.zzm(String.format("Could not parse value: '%s' for key: '%s'.", firebaseRemoteConfigValue.asString(), string));
                }
            }
        }
        return object;
    }

    private final FirebaseRemoteConfigValue zzl(String string) {
        FirebaseRemoteConfigValue firebaseRemoteConfigValue;
        RemoteConfigManager remoteConfigManager = this;
        if (remoteConfigManager.zzck()) {
            RemoteConfigManager remoteConfigManager2 = remoteConfigManager;
            if (System.currentTimeMillis() - remoteConfigManager2.zzfd > zzfc) {
                remoteConfigManager2 = remoteConfigManager;
                remoteConfigManager.zzfd = System.currentTimeMillis();
                remoteConfigManager2.zzfe.fetchAndActivate().addOnFailureListener(remoteConfigManager2.executor, (OnFailureListener)new zzw(remoteConfigManager2));
            }
        }
        if (this.zzck() && (firebaseRemoteConfigValue = this.zzfe.getValue(string)).getSource() == 2) {
            this.zzai.zzm(String.format("Fetched value: '%s' for key: '%s' from Firebase Remote Config.", firebaseRemoteConfigValue.asString(), string));
            return firebaseRemoteConfigValue;
        }
        return null;
    }

    public final boolean zzcj() {
        return this.zzfe == null || this.zzfe.getInfo().getLastFetchStatus() == 1;
    }

    private final boolean zzck() {
        return this.zzfe != null;
    }

    final /* synthetic */ void zza(Exception exception) {
        this.zzfd = 0L;
    }
}

