/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.core.app.FrameMetricsAggregator;
import com.google.android.gms.internal.firebase-perf.zzaf;
import com.google.android.gms.internal.firebase-perf.zzbj;
import com.google.android.gms.internal.firebase-perf.zzbk;
import com.google.android.gms.internal.firebase-perf.zzbm;
import com.google.android.gms.internal.firebase-perf.zzbt;
import com.google.android.gms.internal.firebase-perf.zzbx;
import com.google.android.gms.internal.firebase-perf.zzcg;
import com.google.android.gms.internal.firebase-perf.zzdn;
import com.google.android.gms.internal.firebase-perf.zzfc;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.internal.zzf;
import com.google.firebase.perf.metrics.Trace;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class zza
implements Application.ActivityLifecycleCallbacks {
    private static volatile zza zzbv;
    private boolean mRegistered = false;
    private zzf zzbw = null;
    private zzaf zzbx;
    private final zzbk zzby;
    private boolean zzbz = true;
    private final WeakHashMap<Activity, Boolean> zzca = new WeakHashMap();
    private zzbt zzcb;
    private zzbt zzcc;
    private final Map<String, Long> zzcd = new HashMap<String, Long>();
    private AtomicInteger zzce = new AtomicInteger(0);
    private zzcg zzcf = com.google.android.gms.internal.firebase-perf.zzcg.zziy;
    private Set<WeakReference<zza>> zzcg = new HashSet<WeakReference<zza>>();
    private boolean zzch = false;
    private FrameMetricsAggregator zzci;
    private final WeakHashMap<Activity, Trace> zzcj = new WeakHashMap();

    public static zza zzbg() {
        if (zzbv != null) {
            return zzbv;
        }
        return zza.zza(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static zza zza(zzf zzf2) {
        if (zzbv != null) return zzbv;
        Class<zza> clazz = zza.class;
        synchronized (zza.class) {
            if (zzbv != null) return zzbv;
            zzbv = new zza(null, new zzbk());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbv;
        }
    }

    private zza(zzf zzf2, zzbk zzbk2) {
        this.zzby = zzbk2;
        this.zzbx = zzaf.zzm();
        this.zzch = zza.zzbk();
        if (this.zzch) {
            this.zzci = new FrameMetricsAggregator();
        }
    }

    public final synchronized void zze(Context context) {
        if (this.mRegistered) {
            return;
        }
        Context context2 = context.getApplicationContext();
        if (context2 instanceof Application) {
            ((Application)context2).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mRegistered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(@NonNull String string, long l) {
        Map<String, Long> map = this.zzcd;
        synchronized (map) {
            Long l2 = this.zzcd.get(string);
            if (l2 == null) {
                this.zzcd.put(string, 1L);
            } else {
                this.zzcd.put(string, l2 + 1L);
            }
            return;
        }
    }

    public final void zzb(int n) {
        this.zzce.addAndGet(1);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.zza(activity) && this.zzbx.zzn()) {
            this.zzci.add(activity);
            this.zzbj();
            Trace trace = new Trace(zza.zzb(activity), this.zzbw, this.zzby, this);
            trace.start();
            this.zzcj.put(activity, trace);
        }
    }

    public synchronized void onActivityStopped(Activity activity) {
        if (this.zza(activity)) {
            Trace trace;
            Activity activity2 = activity;
            zza zza2 = this;
            if (zza2.zzcj.containsKey(activity2) && (trace = zza2.zzcj.get(activity2)) != null) {
                int n;
                int n2;
                int n3;
                Object object;
                zza2.zzcj.remove(activity2);
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                SparseIntArray[] sparseIntArrayArray = zza2.zzci.remove(activity2);
                if (sparseIntArrayArray != null && (object = sparseIntArrayArray[0]) != null) {
                    for (n3 = 0; n3 < object.size(); ++n3) {
                        n2 = object.keyAt(n3);
                        n = object.valueAt(n3);
                        n4 += n;
                        if (n2 > 700) {
                            n6 += n;
                        }
                        if (n2 <= 16) continue;
                        n5 += n;
                    }
                }
                if (n4 == 0) {
                    // empty if block
                }
                if (n4 > 0) {
                    trace.putMetric(zzbj.zzhf.toString(), n4);
                }
                if (n5 > 0) {
                    trace.putMetric(zzbj.zzhg.toString(), n5);
                }
                if (n6 > 0) {
                    trace.putMetric(zzbj.zzhh.toString(), n6);
                }
                if (com.google.android.gms.internal.firebase-perf.zzbx.zzg(activity2.getApplicationContext())) {
                    object = zza.zzb(activity2);
                    n3 = n4;
                    n2 = n5;
                    n = n6;
                    Log.d((String)"FirebasePerformance", (String)new StringBuilder(81 + String.valueOf(object).length()).append("sendScreenTrace name:").append((String)object).append(" _fr_tot:").append(n3).append(" _fr_slo:").append(n2).append(" _fr_fzn:").append(n).toString());
                }
                trace.stop();
            }
        }
        if (this.zzca.containsKey(activity)) {
            this.zzca.remove(activity);
            if (this.zzca.isEmpty()) {
                this.zzcb = new zzbt();
                this.zza(com.google.android.gms.internal.firebase-perf.zzcg.zziy);
                this.zzb(false);
                this.zza(zzbm.zzho.toString(), this.zzcc, this.zzcb);
            }
        }
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.zzca.isEmpty()) {
            this.zzcc = new zzbt();
            this.zzca.put(activity, true);
            this.zza(com.google.android.gms.internal.firebase-perf.zzcg.zzix);
            this.zzb(true);
            if (this.zzbz) {
                this.zzbz = false;
                return;
            }
            this.zza(zzbm.zzhp.toString(), this.zzcb, this.zzcc);
            return;
        }
        this.zzca.put(activity, true);
    }

    public final boolean zzbh() {
        return this.zzbz;
    }

    public final zzcg zzbi() {
        return this.zzcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(WeakReference<zza> weakReference) {
        Set<WeakReference<zza>> set = this.zzcg;
        synchronized (set) {
            this.zzcg.add(weakReference);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(WeakReference<zza> weakReference) {
        Set<WeakReference<zza>> set = this.zzcg;
        synchronized (set) {
            this.zzcg.remove(weakReference);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzcg zzcg2) {
        this.zzcf = zzcg2;
        Set<WeakReference<zza>> set = this.zzcg;
        synchronized (set) {
            Iterator<WeakReference<zza>> iterator = this.zzcg.iterator();
            while (iterator.hasNext()) {
                zza zza2 = (zza)iterator.next().get();
                if (zza2 != null) {
                    zza2.zzb(this.zzcf);
                    continue;
                }
                iterator.remove();
            }
            return;
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityPaused(Activity activity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string, zzbt zzbt2, zzbt zzbt3) {
        if (!this.zzbx.zzn()) {
            return;
        }
        this.zzbj();
        zzdn.zzb zzb2 = zzdn.zzfy().zzah(string).zzao(zzbt2.zzdb()).zzap(zzbt2.zzk(zzbt3)).zzb(SessionManager.zzcl().zzcm().zzch());
        int n = this.zzce.getAndSet(0);
        Map<String, Long> map = this.zzcd;
        synchronized (map) {
            zzb2.zzd(this.zzcd);
            if (n != 0) {
                zzb2.zzc(zzbj.zzhe.toString(), n);
            }
            this.zzcd.clear();
        }
        if (this.zzbw != null) {
            this.zzbw.zza((zzdn)((zzfc)zzb2.zzhq()), com.google.android.gms.internal.firebase-perf.zzcg.zziz);
        }
    }

    private final void zzb(boolean bl) {
        this.zzbj();
        if (this.zzbw != null) {
            this.zzbw.zzc(bl);
        }
    }

    private final void zzbj() {
        if (this.zzbw == null) {
            this.zzbw = zzf.zzbt();
        }
    }

    private final boolean zza(Activity activity) {
        return this.zzch && activity.getWindow() != null && (activity.getWindow().getAttributes().flags & 0x1000000) != 0;
    }

    private static boolean zzbk() {
        try {
            Class.forName("androidx.core.app.FrameMetricsAggregator");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static String zzb(Activity activity) {
        String string = String.valueOf("_st_");
        String string2 = String.valueOf(activity.getClass().getSimpleName());
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    public static interface zza {
        public void zzb(zzcg var1);
    }
}

