/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.clearcut.ClearcutLogger;
import com.google.android.gms.internal.firebase-perf.zzaf;
import com.google.android.gms.internal.firebase-perf.zzbj;
import com.google.android.gms.internal.firebase-perf.zzbx;
import com.google.android.gms.internal.firebase-perf.zzca;
import com.google.android.gms.internal.firebase-perf.zzce;
import com.google.android.gms.internal.firebase-perf.zzcg;
import com.google.android.gms.internal.firebase-perf.zzcq;
import com.google.android.gms.internal.firebase-perf.zzcv;
import com.google.android.gms.internal.firebase-perf.zzda;
import com.google.android.gms.internal.firebase-perf.zzdn;
import com.google.android.gms.internal.firebase-perf.zzdv;
import com.google.android.gms.internal.firebase-perf.zzfc;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.perf.FirebasePerformance;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.internal.zza;
import com.google.firebase.perf.internal.zzc;
import com.google.firebase.perf.internal.zzd;
import com.google.firebase.perf.internal.zze;
import com.google.firebase.perf.internal.zzg;
import com.google.firebase.perf.internal.zzh;
import com.google.firebase.perf.internal.zzi;
import com.google.firebase.perf.internal.zzj;
import com.google.firebase.perf.internal.zzk;
import com.google.firebase.perf.internal.zzl;
import com.google.firebase.perf.internal.zzm;
import com.google.firebase.perf.internal.zzq;
import com.google.firebase.perf.internal.zzv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class zzf {
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile zzf zzcz;
    private final ExecutorService zzda;
    private FirebaseApp zzdb;
    @Nullable
    private FirebasePerformance zzdc;
    private FirebaseInstanceId zzdd;
    private Context zzde;
    private ClearcutLogger zzdf;
    private String zzdg;
    private final zzce.zzb zzdh = zzce.zzdn();
    private zzv zzdi;
    private zza zzdj;
    private zzaf zzab;
    private boolean zzdk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static zzf zzbt() {
        if (zzcz != null) return zzcz;
        Class<zzf> clazz = zzf.class;
        synchronized (zzf.class) {
            if (zzcz != null) return zzcz;
            try {
                FirebaseApp.getInstance();
            }
            catch (IllegalStateException illegalStateException) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            zzcz = new zzf(null, null, null, null, null, null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzcz;
        }
    }

    @VisibleForTesting(otherwise=2)
    private zzf(@Nullable ExecutorService executorService, @Nullable ClearcutLogger clearcutLogger, @Nullable zzv zzv2, @Nullable zza zza2, @Nullable FirebaseInstanceId firebaseInstanceId, @Nullable zzaf zzaf2) {
        this.zzda = executorService = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.zzdf = null;
        this.zzdi = null;
        this.zzdj = null;
        this.zzdd = null;
        this.zzab = null;
        this.zzda.execute(new zze(this));
    }

    public final void zza(@NonNull zzdn zzdn2, zzcg zzcg2) {
        this.zzda.execute(new zzh(this, zzdn2, zzcg2));
        SessionManager.zzcl().zzcn();
    }

    public final void zza(@NonNull zzcv zzcv2, zzcg zzcg2) {
        this.zzda.execute(new zzg(this, zzcv2, zzcg2));
        SessionManager.zzcl().zzcn();
    }

    public final void zza(zzcq zzcq2, zzcg zzcg2) {
        this.zzda.execute(new zzj(this, zzcq2, zzcg2));
        SessionManager.zzcl().zzcn();
    }

    public final void zzc(boolean bl) {
        this.zzda.execute(new zzi(this, bl));
    }

    @WorkerThread
    private final void zzbu() {
        this.zzdb = FirebaseApp.getInstance();
        this.zzdc = FirebasePerformance.getInstance();
        this.zzde = this.zzdb.getApplicationContext();
        this.zzdg = this.zzdb.getOptions().getApplicationId();
        this.zzdh.zzy(this.zzdg).zza(zzca.zzdd().zzt(this.zzde.getPackageName()).zzu(zzd.VERSION_NAME).zzv(zzf.zzf(this.zzde)));
        this.zzbv();
        this.zzdi = this.zzdi == null ? new zzv(this.zzde, 100.0, 500L) : this.zzdi;
        this.zzdj = this.zzdj == null ? zza.zzbg() : this.zzdj;
        this.zzab = this.zzab == null ? zzaf.zzm() : this.zzab;
        this.zzab.zzc(this.zzde);
        this.zzdk = zzbx.zzg(this.zzde);
        if (this.zzdf == null) {
            try {
                String string = this.zzab.zzae();
                this.zzdf = ClearcutLogger.anonymousLogger((Context)this.zzde, (String)string);
                return;
            }
            catch (SecurityException securityException) {
                String string = String.valueOf(securityException.getMessage());
                Log.w((String)"FirebasePerformance", (String)(string.length() != 0 ? "Caught SecurityException while init ClearcutLogger: ".concat(string) : new String("Caught SecurityException while init ClearcutLogger: ")));
                this.zzdf = null;
            }
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzda zzda2) {
        if (this.zzdf == null) {
            return;
        }
        if (this.zzbw()) {
            boolean bl;
            block20: {
                ArrayList<zzq> arrayList;
                if (!zzda2.zzff().hasAppInstanceId()) {
                    Log.w((String)"FirebasePerformance", (String)"App Instance ID is null or empty, dropping the log");
                    return;
                }
                Context context = this.zzde;
                zzda zzda3 = zzda2;
                Context context2 = context;
                zzda zzda4 = zzda3;
                ArrayList<zzq> arrayList2 = new ArrayList<zzq>();
                if (zzda4.zzfg()) {
                    arrayList2.add(new zzm(zzda4.zzfh()));
                }
                if (zzda4.zzfi()) {
                    arrayList2.add(new zzk(zzda4.zzfj(), context2));
                }
                if (zzda4.zzfe()) {
                    arrayList2.add(new zzc(zzda4.zzff()));
                }
                if (zzda4.zzfk()) {
                    arrayList2.add(new zzl(zzda4.zzfl()));
                }
                if ((arrayList = arrayList2).isEmpty()) {
                    Log.d((String)"FirebasePerformance", (String)"No validators found for PerfMetric.");
                    bl = false;
                } else {
                    ArrayList<zzq> arrayList3 = arrayList;
                    int n = arrayList3.size();
                    Object var8_11 = null;
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList3.get(i);
                        if (((zzq)e).zzbs()) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                Log.w((String)"FirebasePerformance", (String)"Unable to process the PerfMetric due to missing or invalid values. See earlier log statements for additional information on the specific missing/invalid values.");
                return;
            }
            if (!this.zzdi.zzb(zzda2)) {
                zzda zzda5 = zzda2;
                zzf zzf2 = this;
                if (zzda5.zzfi()) {
                    zzf2.zzdj.zzb(zzbj.zzhd.toString(), 1L);
                } else if (zzda5.zzfg()) {
                    zzf2.zzdj.zzb(zzbj.zzhc.toString(), 1L);
                }
                if (this.zzdk) {
                    if (zzda2.zzfi()) {
                        String string = String.valueOf(zzda2.zzfj().getUrl());
                        Log.i((String)"FirebasePerformance", (String)(string.length() != 0 ? "Rate Limited NetworkRequestMetric - ".concat(string) : new String("Rate Limited NetworkRequestMetric - ")));
                        return;
                    }
                    if (zzda2.zzfg()) {
                        String string = String.valueOf(zzda2.zzfh().getName());
                        Log.i((String)"FirebasePerformance", (String)(string.length() != 0 ? "Rate Limited TraceMetric - ".concat(string) : new String("Rate Limited TraceMetric - ")));
                    }
                }
                return;
            }
            byte[] byArray = zzda2.toByteArray();
            try {
                this.zzdf.newEvent(byArray).log();
                return;
            }
            catch (SecurityException securityException) {}
        }
    }

    @WorkerThread
    private final void zzb(zzcq zzcq2, zzcg zzcg2) {
        if (this.zzbw()) {
            if (this.zzdk) {
                int n = zzcq2.zzeb();
                int n2 = zzcq2.zzec();
                Log.d((String)"FirebasePerformance", (String)String.format("Logging GaugeMetric. Cpu Metrics: %d, Memory Metrics: %d, Has Metadata: %b, Session ID: %s", n, n2, zzcq2.zzdz(), zzcq2.zzdy()));
            }
            zzda.zza zza2 = com.google.android.gms.internal.firebase-perf.zzda.zzfm();
            this.zzbv();
            zza2.zza(this.zzdh.zzf(zzcg2)).zzb(zzcq2);
            this.zza((zzda)((zzfc)zza2.zzhq()));
        }
    }

    @WorkerThread
    private final void zzb(@NonNull zzdn zzdn2, zzcg zzcg2) {
        if (this.zzbw()) {
            if (this.zzdk) {
                long l = zzdn2.getDurationUs();
                Log.d((String)"FirebasePerformance", (String)String.format("Logging TraceMetric - %s %dms", zzdn2.getName(), l / 1000L));
            }
            this.zzbv();
            zzda.zza zza2 = com.google.android.gms.internal.firebase-perf.zzda.zzfm();
            zzce.zzb zzb2 = ((zzce.zzb)((zzfc.zzb)((zzdv)this.zzdh).clone())).zzf(zzcg2);
            zzf zzf2 = this;
            zzf2.zzbx();
            zzda zzda2 = (zzda)((zzfc)zza2.zza(zzb2.zzb(zzf2.zzdc != null ? zzf2.zzdc.getAttributes() : Collections.emptyMap())).zzb(zzdn2).zzhq());
            this.zza(zzda2);
        }
    }

    @WorkerThread
    private final void zzb(@NonNull zzcv zzcv2, zzcg zzcg2) {
        if (this.zzbw()) {
            if (this.zzdk) {
                long l = !zzcv2.zzew() ? 0L : zzcv2.zzex();
                long l2 = !zzcv2.zzem() ? 0L : zzcv2.zzen();
                Log.d((String)"FirebasePerformance", (String)String.format("Logging NetworkRequestMetric - %s %db %dms,", zzcv2.getUrl(), l2, l / 1000L));
            }
            this.zzbv();
            zzda zzda2 = (zzda)((zzfc)com.google.android.gms.internal.firebase-perf.zzda.zzfm().zza(this.zzdh.zzf(zzcg2)).zzd(zzcv2).zzhq());
            this.zza(zzda2);
        }
    }

    @WorkerThread
    public final void zzd(boolean bl) {
        this.zzdi.zzc(bl);
    }

    private static String zzf(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return "";
        }
    }

    @WorkerThread
    private final void zzbv() {
        if (this.zzdh.hasAppInstanceId()) {
            return;
        }
        if (this.zzbw()) {
            String string;
            if (this.zzdd == null) {
                this.zzdd = FirebaseInstanceId.getInstance();
            }
            if ((string = this.zzdd.getId()) != null && !string.isEmpty()) {
                this.zzdh.zzz(string);
            }
        }
    }

    @VisibleForTesting(otherwise=2)
    private final boolean zzbw() {
        this.zzbx();
        if (this.zzab == null) {
            this.zzab = zzaf.zzm();
        }
        return this.zzdc != null && this.zzdc.isPerformanceCollectionEnabled() && this.zzab.zzq();
    }

    private final void zzbx() {
        if (this.zzdc == null) {
            this.zzdc = this.zzdb != null ? FirebasePerformance.getInstance() : null;
        }
    }

    static /* synthetic */ void zzc(zzf zzf2) {
        zzf2.zzbu();
    }

    static /* synthetic */ void zza(zzf zzf2, zzdn zzdn2, zzcg zzcg2) {
        zzf2.zzb(zzdn2, zzcg2);
    }

    static /* synthetic */ void zza(zzf zzf2, zzcv zzcv2, zzcg zzcg2) {
        zzf2.zzb(zzcv2, zzcg2);
    }

    static /* synthetic */ void zza(zzf zzf2, zzcq zzcq2, zzcg zzcg2) {
        zzf2.zzb(zzcq2, zzcg2);
    }
}

