/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase-perf.zzbv;
import com.google.android.gms.internal.firebase-perf.zzcv;
import com.google.firebase.perf.internal.zzq;
import java.net.URI;

final class zzk
extends zzq {
    private final zzcv zzdq;
    private final Context zzde;

    zzk(@NonNull zzcv zzcv2, Context context) {
        this.zzde = context;
        this.zzdq = zzcv2;
    }

    @Override
    public final boolean zzbs() {
        String string = this.zzdq.getUrl();
        if (zzk.zzj(string)) {
            String string2 = String.valueOf(this.zzdq.getUrl());
            Log.i((String)"FirebasePerformance", (String)(string2.length() != 0 ? "URL is missing:".concat(string2) : new String("URL is missing:")));
            return false;
        }
        URI uRI = zzk.zzi(this.zzdq.getUrl());
        if (uRI == null) {
            Log.i((String)"FirebasePerformance", (String)"URL cannot be parsed");
            return false;
        }
        string = this.zzde;
        Object object = uRI;
        if (!(object == null ? false : zzbv.zza((URI)object, (Context)string))) {
            String string3 = String.valueOf(uRI);
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(26 + String.valueOf(string3).length()).append("URL fails whitelist rule: ").append(string3).toString());
            return false;
        }
        string = uRI.getHost();
        if (!(string != null && !zzk.zzj(string) && string.length() <= 255)) {
            Log.i((String)"FirebasePerformance", (String)"URL host is null or invalid");
            return false;
        }
        object = uRI.getScheme();
        if (!(object != null && ("http".equalsIgnoreCase((String)object) || "https".equalsIgnoreCase((String)object)))) {
            Log.i((String)"FirebasePerformance", (String)"URL scheme is null or invalid");
            return false;
        }
        if (!(uRI.getUserInfo() == null)) {
            Log.i((String)"FirebasePerformance", (String)"URL user info is null");
            return false;
        }
        int n = uRI.getPort();
        if (!(n == -1 || n > 0)) {
            Log.i((String)"FirebasePerformance", (String)"URL port is less than or equal to 0");
            return false;
        }
        zzcv.zzb zzb2 = this.zzdq.zzei() ? this.zzdq.zzej() : null;
        if (!(zzb2 != null && zzb2 != zzcv.zzb.zzkt)) {
            String string4 = String.valueOf(this.zzdq.zzej());
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(32 + String.valueOf(string4).length()).append("HTTP Method is null or invalid: ").append(string4).toString());
            return false;
        }
        if (this.zzdq.zzbm() && !(this.zzdq.zzeo() > 0)) {
            int n2 = this.zzdq.zzeo();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(49).append("HTTP ResponseCode is a negative value:").append(n2).toString());
            return false;
        }
        if (this.zzdq.zzek() && !zzk.zzq(this.zzdq.zzel())) {
            long l = this.zzdq.zzel();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(56).append("Request Payload is a negative value:").append(l).toString());
            return false;
        }
        if (this.zzdq.zzem() && !zzk.zzq(this.zzdq.zzen())) {
            long l = this.zzdq.zzen();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(57).append("Response Payload is a negative value:").append(l).toString());
            return false;
        }
        if (!this.zzdq.zzeq() || this.zzdq.zzer() <= 0L) {
            long l = this.zzdq.zzer();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(84).append("Start time of the request is null, or zero, or a negative value:").append(l).toString());
            return false;
        }
        if (this.zzdq.zzes() && !zzk.zzp(this.zzdq.zzet())) {
            long l = this.zzdq.zzet();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(69).append("Time to complete the request is a negative value:").append(l).toString());
            return false;
        }
        if (this.zzdq.zzeu() && !zzk.zzp(this.zzdq.zzev())) {
            long l = this.zzdq.zzev();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(112).append("Time from the start of the request to the start of the response is null or a negative value:").append(l).toString());
            return false;
        }
        if (!this.zzdq.zzew() || this.zzdq.zzex() <= 0L) {
            long l = this.zzdq.zzex();
            Log.i((String)"FirebasePerformance", (String)new StringBuilder(108).append("Time from the start of the request to the end of the response is null, negative or zero:").append(l).toString());
            return false;
        }
        if (!this.zzdq.zzbm()) {
            Log.i((String)"FirebasePerformance", (String)"Did not receive a HTTP Response Code");
            return false;
        }
        return true;
    }

    @Nullable
    private static URI zzi(@Nullable String string) {
        if (string == null) {
            return null;
        }
        try {
            return URI.create(string);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            Log.w((String)"FirebasePerformance", (String)"getResultUrl throws exception", (Throwable)runtimeException);
            return null;
        }
    }

    private static boolean zzp(long l) {
        return l >= 0L;
    }

    private static boolean zzq(long l) {
        return l >= 0L;
    }

    private static boolean zzj(@Nullable String string) {
        if (string == null) {
            return true;
        }
        return string.trim().isEmpty();
    }
}

