/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase-perf.zzbi;
import com.google.android.gms.internal.firebase-perf.zzbk;
import com.google.android.gms.internal.firebase-perf.zzbm;
import com.google.android.gms.internal.firebase-perf.zzbt;
import com.google.android.gms.internal.firebase-perf.zzcg;
import com.google.android.gms.internal.firebase-perf.zzdn;
import com.google.android.gms.internal.firebase-perf.zzfc;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.internal.zzf;
import com.google.firebase.perf.provider.FirebasePerfProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class AppStartTrace
implements Application.ActivityLifecycleCallbacks {
    private static final long zzfm = TimeUnit.MINUTES.toMicros(1L);
    private static volatile AppStartTrace zzfn;
    private boolean mRegistered = false;
    private zzf zzbw = null;
    private final zzbk zzby;
    private Context zzfo;
    private WeakReference<Activity> zzfp;
    private WeakReference<Activity> zzfq;
    private boolean zzfr = false;
    private zzbt zzfs = null;
    private zzbt zzft = null;
    private zzbt zzfu = null;
    private boolean zzfv = false;

    @Keep
    public static void setLauncherActivityOnCreateTime(String string) {
    }

    @Keep
    public static void setLauncherActivityOnStartTime(String string) {
    }

    @Keep
    public static void setLauncherActivityOnResumeTime(String string) {
    }

    public static AppStartTrace zzcq() {
        if (zzfn != null) {
            return zzfn;
        }
        return AppStartTrace.zza(null, new zzbk());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AppStartTrace zza(zzf zzf2, zzbk zzbk2) {
        if (zzfn != null) return zzfn;
        Class<AppStartTrace> clazz = AppStartTrace.class;
        synchronized (AppStartTrace.class) {
            if (zzfn != null) return zzfn;
            zzfn = new AppStartTrace(null, zzbk2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzfn;
        }
    }

    private AppStartTrace(@Nullable zzf zzf2, @NonNull zzbk zzbk2) {
        this.zzby = zzbk2;
    }

    public final synchronized void zze(@NonNull Context context) {
        if (this.mRegistered) {
            return;
        }
        Context context2 = context.getApplicationContext();
        if (context2 instanceof Application) {
            ((Application)context2).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mRegistered = true;
            this.zzfo = context2;
        }
    }

    private final synchronized void zzcr() {
        if (!this.mRegistered) {
            return;
        }
        ((Application)this.zzfo).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.mRegistered = false;
    }

    public synchronized void onActivityCreated(Activity activity, Bundle bundle) {
        if (this.zzfv || this.zzfs != null) {
            return;
        }
        this.zzfp = new WeakReference<Activity>(activity);
        this.zzfs = new zzbt();
        if (FirebasePerfProvider.zzcz().zzk(this.zzfs) > zzfm) {
            this.zzfr = true;
        }
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.zzfv || this.zzft != null || this.zzfr) {
            return;
        }
        this.zzft = new zzbt();
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.zzfv || this.zzfu != null || this.zzfr) {
            return;
        }
        this.zzfq = new WeakReference<Activity>(activity);
        this.zzfu = new zzbt();
        zzbt zzbt2 = FirebasePerfProvider.zzcz();
        Object object = activity.getClass().getName();
        long l = zzbt2.zzk(this.zzfu);
        zzbi.zzcp().zzm(new StringBuilder(47 + String.valueOf(object).length()).append("onResume(): ").append((String)object).append(": ").append(l).append(" microseconds").toString());
        object = zzdn.zzfy().zzah(zzbm.zzhk.toString()).zzao(zzbt2.zzdb()).zzap(zzbt2.zzk(this.zzfu));
        ArrayList<zzdn> arrayList = new ArrayList<zzdn>(3);
        zzdn.zzb zzb2 = zzdn.zzfy().zzah(zzbm.zzhl.toString()).zzao(zzbt2.zzdb()).zzap(zzbt2.zzk(this.zzfs));
        arrayList.add((zzdn)((zzfc)zzb2.zzhq()));
        zzb2 = zzdn.zzfy();
        zzb2.zzah(zzbm.zzhm.toString()).zzao(this.zzfs.zzdb()).zzap(this.zzfs.zzk(this.zzft));
        arrayList.add((zzdn)((zzfc)zzb2.zzhq()));
        zzb2 = zzdn.zzfy();
        zzb2.zzah(zzbm.zzhn.toString()).zzao(this.zzft.zzdb()).zzap(this.zzft.zzk(this.zzfu));
        arrayList.add((zzdn)((zzfc)zzb2.zzhq()));
        ((zzdn.zzb)object).zzd(arrayList).zzb(SessionManager.zzcl().zzcm().zzch());
        if (this.zzbw == null) {
            this.zzbw = zzf.zzbt();
        }
        if (this.zzbw != null) {
            this.zzbw.zza((zzdn)((zzfc)((zzfc.zzb)object).zzhq()), zzcg.zziz);
        }
        if (this.mRegistered) {
            this.zzcr();
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public synchronized void onActivityStopped(Activity activity) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    static /* synthetic */ boolean zza(AppStartTrace appStartTrace, boolean bl) {
        appStartTrace.zzfv = true;
        return true;
    }

    public static final class zza
    implements Runnable {
        private final AppStartTrace zzfx;

        public zza(AppStartTrace appStartTrace) {
            this.zzfx = appStartTrace;
        }

        @Override
        public final void run() {
            if (this.zzfx.zzfs == null) {
                AppStartTrace.zza(this.zzfx, true);
            }
        }
    }
}

