/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase-perf.zzaf;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.android.gms.internal.firebase-perf.zzbt;
import com.google.firebase.perf.internal.zzf;
import com.google.firebase.perf.internal.zzq;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpMetric {
    private zzbg zzfy;
    private zzbt zzfz;
    private final Map<String, String> zzga = new ConcurrentHashMap<String, String>();
    private boolean zzgb = false;
    private boolean zzgc = false;

    public HttpMetric(String string, String string2, zzf zzf2, zzbt zzbt2) {
        this.zzfz = zzbt2;
        this.zzfy = zzbg.zzb(zzf2).zzf(string).zzg(string2);
        this.zzfy.zzbl();
        if (!zzaf.zzm().zzn()) {
            Log.i((String)"FirebasePerformance", (String)String.format("HttpMetric feature is disabled. URL %s", string));
            this.zzgc = true;
        }
    }

    public HttpMetric(URL uRL, String string, zzf zzf2, zzbt zzbt2) {
        this(uRL.toString(), string, zzf2, zzbt2);
    }

    public void setHttpResponseCode(int n) {
        this.zzfy.zzc(n);
    }

    public void setRequestPayloadSize(long l) {
        this.zzfy.zzj(l);
    }

    public void setResponsePayloadSize(long l) {
        this.zzfy.zzo(l);
    }

    public void setResponseContentType(@Nullable String string) {
        this.zzfy.zzh(string);
    }

    public void start() {
        this.zzfz.reset();
        this.zzfy.zzk(this.zzfz.zzdb());
    }

    public void stop() {
        if (this.zzgc) {
            return;
        }
        this.zzfy.zzn(this.zzfz.getDurationMicros()).zza(this.zzga).zzbp();
        this.zzgb = true;
    }

    public void putAttribute(@NonNull String string, @NonNull String string2) {
        boolean bl = true;
        try {
            string = string.trim();
            String string3 = string2 = string2.trim();
            String string4 = string;
            HttpMetric httpMetric = this;
            if (httpMetric.zzgb) {
                throw new IllegalArgumentException("HttpMetric has been logged already so unable to modify attributes");
            }
            if (string4 == null || string3 == null) {
                throw new IllegalArgumentException("Attribute must not have null key or value.");
            }
            if (!httpMetric.zzga.containsKey(string4) && httpMetric.zzga.size() >= 5) {
                throw new IllegalArgumentException(String.format(Locale.US, "Exceeds max limit of number of attributes - %d", 5));
            }
            String string5 = zzq.zza(new AbstractMap.SimpleEntry<String, String>(string4, string3));
            if (string5 != null) {
                throw new IllegalArgumentException(string5);
            }
        }
        catch (Exception exception) {
            Log.e((String)"FirebasePerformance", (String)String.format("Can not set attribute %s with value %s (%s)", string, string2, exception.getMessage()));
            bl = false;
        }
        if (bl) {
            this.zzga.put(string, string2);
        }
    }

    public void removeAttribute(@NonNull String string) {
        if (this.zzgb) {
            Log.e((String)"FirebasePerformance", (String)"Can't remove a attribute from a HttpMetric that's stopped.");
            return;
        }
        this.zzga.remove(string);
    }

    @Nullable
    public String getAttribute(@NonNull String string) {
        return this.zzga.get(string);
    }

    @NonNull
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzga);
    }
}

