/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zzaf;
import com.google.android.gms.internal.firebase-perf.zzbk;
import com.google.android.gms.internal.firebase-perf.zzbm;
import com.google.android.gms.internal.firebase-perf.zzbt;
import com.google.android.gms.internal.firebase-perf.zzj;
import com.google.firebase.perf.internal.GaugeManager;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.internal.zzb;
import com.google.firebase.perf.internal.zzf;
import com.google.firebase.perf.internal.zzq;
import com.google.firebase.perf.internal.zzt;
import com.google.firebase.perf.internal.zzx;
import com.google.firebase.perf.metrics.zza;
import com.google.firebase.perf.metrics.zzc;
import com.google.firebase.perf.metrics.zzd;
import com.google.firebase.perf.metrics.zze;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Trace
extends zzb
implements Parcelable,
zzx {
    private static final Map<String, Trace> zzgd = new ConcurrentHashMap<String, Trace>();
    private final Trace zzge;
    private final GaugeManager zzcl;
    private final String name;
    private final List<zzt> zzck;
    private final List<Trace> zzgf;
    private final Map<String, zza> zzgg;
    private final zzbk zzgh;
    private final zzf zzcz;
    private final Map<String, String> zzgi;
    private zzbt zzgj;
    private zzbt zzgk;
    private final WeakReference<zzx> zzcq = new WeakReference<Trace>(this);
    @Keep
    public static final Parcelable.Creator<Trace> CREATOR = new zzc();
    @VisibleForTesting
    private static final Parcelable.Creator<Trace> zzgl = new zze();

    @Override
    public final void zza(zzt zzt2) {
        if (zzt2 == null) {
            Log.i((String)"FirebasePerformance", (String)"Unable to add new SessionId to the Trace. Continuing without it.");
            return;
        }
        if (this.hasStarted() && !this.isStopped()) {
            this.zzck.add(zzt2);
        }
    }

    @NonNull
    public static Trace zzn(@NonNull String string) {
        return new Trace(string);
    }

    private Trace(@NonNull String string) {
        this(string, zzf.zzbt(), new zzbk(), com.google.firebase.perf.internal.zza.zzbg(), GaugeManager.zzby());
    }

    public Trace(@NonNull String string, @NonNull zzf zzf2, @NonNull zzbk zzbk2, @NonNull com.google.firebase.perf.internal.zza zza2) {
        this(string, zzf2, zzbk2, zza2, GaugeManager.zzby());
    }

    private Trace(@NonNull String string, @NonNull zzf zzf2, @NonNull zzbk zzbk2, @NonNull com.google.firebase.perf.internal.zza zza2, @NonNull GaugeManager gaugeManager) {
        super(zza2);
        this.zzge = null;
        this.name = string.trim();
        this.zzgf = new ArrayList<Trace>();
        this.zzgg = new ConcurrentHashMap<String, zza>();
        this.zzgi = new ConcurrentHashMap<String, String>();
        this.zzgh = zzbk2;
        this.zzcz = zzf2;
        this.zzck = new ArrayList<zzt>();
        this.zzcl = gaugeManager;
    }

    private Trace(@NonNull Parcel parcel, boolean bl) {
        super(bl ? null : com.google.firebase.perf.internal.zza.zzbg());
        this.zzge = (Trace)parcel.readParcelable(Trace.class.getClassLoader());
        this.name = parcel.readString();
        this.zzgf = new ArrayList<Trace>();
        parcel.readList(this.zzgf, Trace.class.getClassLoader());
        this.zzgg = new ConcurrentHashMap<String, zza>();
        this.zzgi = new ConcurrentHashMap<String, String>();
        parcel.readMap(this.zzgg, zza.class.getClassLoader());
        this.zzgj = (zzbt)parcel.readParcelable(zzbt.class.getClassLoader());
        this.zzgk = (zzbt)parcel.readParcelable(zzbt.class.getClassLoader());
        this.zzck = new ArrayList<zzt>();
        parcel.readList(this.zzck, zzt.class.getClassLoader());
        if (bl) {
            this.zzcz = null;
            this.zzgh = null;
            this.zzcl = null;
            return;
        }
        this.zzcz = zzf.zzbt();
        this.zzgh = new zzbk();
        this.zzcl = GaugeManager.zzby();
    }

    /*
     * Unable to fully structure code
     */
    @Keep
    public void start() {
        block9: {
            block10: {
                block8: {
                    if (!zzaf.zzm().zzn()) {
                        Log.i((String)"FirebasePerformance", (String)"Trace feature is disabled.");
                        return;
                    }
                    var3_1 = this.name;
                    if (var3_1 != null) break block8;
                    v0 = "Trace name must not be null";
                    break block9;
                }
                if (var3_1.length() <= 100) break block10;
                v0 = String.format(Locale.US, "Trace name must not exceed %d characters", new Object[]{100});
                break block9;
            }
            if (!var3_1.startsWith("_")) ** GOTO lbl-1000
            var4_2 = zzbm.values();
            var5_3 = var4_2.length;
            for (var6_4 = 0; var6_4 < var5_3; ++var6_4) {
                if (!var4_2[var6_4].toString().equals(var3_1)) {
                    continue;
                }
                ** GOTO lbl-1000
            }
            if (!var3_1.startsWith("_st_")) {
                v0 = "Trace name must not start with '_'";
            } else lbl-1000:
            // 3 sources

            {
                v0 = var1_5 = null;
            }
        }
        if (v0 != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Cannot start trace %s. Trace name is invalid.(%s)", new Object[]{this.name, var1_5}));
            return;
        }
        if (this.zzgj != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has already started, should not start again!", new Object[]{this.name}));
            return;
        }
        this.zzgj = new zzbt();
        this.zzbq();
        var2_6 = SessionManager.zzcl().zzcm();
        SessionManager.zzcl().zzc(this.zzcq);
        this.zza(var2_6);
        if (var2_6.zzcg()) {
            this.zzcl.zzj(var2_6.zzcf());
        }
    }

    @Keep
    public void stop() {
        if (!this.hasStarted()) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has not been started so unable to stop!", this.name));
            return;
        }
        if (this.isStopped()) {
            Log.e((String)"FirebasePerformance", (String)String.format("Trace '%s' has already stopped, should not stop again!", this.name));
            return;
        }
        SessionManager.zzcl().zzd(this.zzcq);
        this.zzbr();
        this.zzgk = new zzbt();
        if (this.zzge == null) {
            zzbt zzbt2 = this.zzgk;
            Trace trace = this;
            if (!trace.zzgf.isEmpty()) {
                int n = trace.zzgf.size() - 1;
                Trace trace2 = trace.zzgf.get(n);
                if (trace2.zzgk == null) {
                    trace2.zzgk = zzbt2;
                }
            }
            if (!this.name.isEmpty()) {
                if (this.zzcz != null) {
                    this.zzcz.zza(new zzd(this).zzcx(), this.zzbi());
                    if (SessionManager.zzcl().zzcm().zzcg()) {
                        this.zzcl.zzj(SessionManager.zzcl().zzcm().zzcf());
                        return;
                    }
                }
            } else {
                Log.e((String)"FirebasePerformance", (String)"Trace name is empty, no log is sent to server");
            }
        }
    }

    @NonNull
    private final zza zzo(@NonNull String string) {
        zza zza2 = this.zzgg.get(string);
        if (zza2 == null) {
            zza2 = new zza(string);
            this.zzgg.put(string, zza2);
        }
        return zza2;
    }

    @Keep
    public void incrementMetric(@NonNull String string, long l) {
        String string2 = zzq.zzk(string);
        if (string2 != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Cannot increment metric %s. Metric name is invalid.(%s)", string, string2));
            return;
        }
        if (!this.hasStarted()) {
            Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment metric '%s' for trace '%s' because it's not started", string, this.name));
            return;
        }
        if (this.isStopped()) {
            Log.w((String)"FirebasePerformance", (String)String.format("Cannot increment metric '%s' for trace '%s' because it's been stopped", string, this.name));
            return;
        }
        this.zzo(string.trim()).zzr(l);
    }

    @Keep
    public long getLongMetric(@NonNull String string) {
        zza zza2 = null;
        if (string != null) {
            zza2 = this.zzgg.get(string.trim());
        }
        if (zza2 == null) {
            return 0L;
        }
        return zza2.getCount();
    }

    @Keep
    public void putMetric(@NonNull String string, long l) {
        String string2 = zzq.zzk(string);
        if (string2 != null) {
            Log.e((String)"FirebasePerformance", (String)String.format("Cannot set value for metric %s. Metric name is invalid.(%s)", string, string2));
            return;
        }
        if (!this.hasStarted()) {
            Log.w((String)"FirebasePerformance", (String)String.format("Cannot set value for metric '%s' for trace '%s' because it's not started", string, this.name));
            return;
        }
        if (this.isStopped()) {
            Log.w((String)"FirebasePerformance", (String)String.format("Cannot set value for metric '%s' for trace '%s' because it's been stopped", string, this.name));
            return;
        }
        this.zzo(string.trim()).zzs(l);
    }

    protected void finalize() throws Throwable {
        try {
            Trace trace = this;
            if (trace.hasStarted() && !trace.isStopped()) {
                Log.w((String)"FirebasePerformance", (String)String.format("Trace '%s' is started but not stopped when it is destructed!", this.name));
                this.zzb(1);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @VisibleForTesting
    @NonNull
    final String getName() {
        return this.name;
    }

    @VisibleForTesting
    @NonNull
    final Map<String, zza> zzcs() {
        return this.zzgg;
    }

    @VisibleForTesting
    final zzbt zzct() {
        return this.zzgj;
    }

    @VisibleForTesting
    final zzbt zzcu() {
        return this.zzgk;
    }

    @VisibleForTesting
    @NonNull
    final List<Trace> zzcv() {
        return this.zzgf;
    }

    @VisibleForTesting
    private final boolean isStopped() {
        return this.zzgk != null;
    }

    @VisibleForTesting
    private final boolean hasStarted() {
        return this.zzgj != null;
    }

    @Keep
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        parcel.writeParcelable((Parcelable)this.zzge, 0);
        parcel.writeString(this.name);
        parcel.writeList(this.zzgf);
        parcel.writeMap(this.zzgg);
        parcel.writeParcelable((Parcelable)this.zzgj, 0);
        parcel.writeParcelable((Parcelable)this.zzgk, 0);
        parcel.writeList(this.zzck);
    }

    @Keep
    public void putAttribute(@NonNull String string, @NonNull String string2) {
        boolean bl = true;
        try {
            string = string.trim();
            String string3 = string2 = string2.trim();
            String string4 = string;
            Trace trace = this;
            if (trace.isStopped()) {
                throw new IllegalArgumentException(String.format(Locale.US, "Trace %s has been stopped", trace.name));
            }
            if (!trace.zzgi.containsKey(string4) && trace.zzgi.size() >= 5) {
                throw new IllegalArgumentException(String.format(Locale.US, "Exceeds max limit of number of attributes - %d", 5));
            }
            String string5 = zzq.zza(new AbstractMap.SimpleEntry<String, String>(string4, string3));
            if (string5 != null) {
                throw new IllegalArgumentException(string5);
            }
        }
        catch (Exception exception) {
            Log.e((String)"FirebasePerformance", (String)String.format("Can not set attribute %s with value %s (%s)", string, string2, exception.getMessage()));
            bl = false;
        }
        if (bl) {
            this.zzgi.put(string, string2);
        }
    }

    @Keep
    public void removeAttribute(@NonNull String string) {
        if (this.isStopped()) {
            Log.e((String)"FirebasePerformance", (String)"Can't remove a attribute from a Trace that's stopped.");
            return;
        }
        this.zzgi.remove(string);
    }

    @Nullable
    @Keep
    public String getAttribute(@NonNull String string) {
        return this.zzgi.get(string);
    }

    @NonNull
    @Keep
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.zzgi);
    }

    @Keep
    public int describeContents() {
        return 0;
    }

    @VisibleForTesting
    final zzj<zzt> zzcw() {
        return zzj.zza(this.zzck);
    }

    /* synthetic */ Trace(Parcel parcel, boolean bl, zzc zzc2) {
        this(parcel, bl);
    }
}

