/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import androidx.annotation.Keep;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.android.gms.internal.firebase-perf.zzbt;
import com.google.firebase.perf.network.zzf;
import com.google.firebase.perf.network.zzh;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class FirebasePerfOkHttpClient {
    private FirebasePerfOkHttpClient() {
    }

    @Keep
    public static Response execute(Call call) throws IOException {
        Response response;
        zzbg zzbg2 = zzbg.zzb(com.google.firebase.perf.internal.zzf.zzbt());
        zzbt zzbt2 = new zzbt();
        long l = zzbt2.zzdb();
        try {
            response = call.execute();
            long l2 = zzbt2.getDurationMicros();
            FirebasePerfOkHttpClient.zza(response, zzbg2, l, l2);
        }
        catch (IOException iOException) {
            Request request = call.request();
            if (request != null) {
                HttpUrl httpUrl = request.url();
                if (httpUrl != null) {
                    zzbg2.zzf(httpUrl.url().toString());
                }
                if (request.method() != null) {
                    zzbg2.zzg(request.method());
                }
            }
            zzbg2.zzk(l);
            zzbg2.zzn(zzbt2.getDurationMicros());
            zzh.zza(zzbg2);
            throw iOException;
        }
        return response;
    }

    @Keep
    public static void enqueue(Call call, Callback callback) {
        zzbt zzbt2 = new zzbt();
        long l = zzbt2.zzdb();
        call.enqueue((Callback)new zzf(callback, com.google.firebase.perf.internal.zzf.zzbt(), zzbt2, l));
    }

    static void zza(Response response, zzbg zzbg2, long l, long l2) throws IOException {
        ResponseBody responseBody;
        long l3;
        Request request = response.request();
        if (request == null) {
            return;
        }
        zzbg2.zzf(request.url().url().toString());
        zzbg2.zzg(request.method());
        if (request.body() != null && (l3 = request.body().contentLength()) != -1L) {
            zzbg2.zzj(l3);
        }
        if ((responseBody = response.body()) != null) {
            MediaType mediaType;
            long l4 = responseBody.contentLength();
            if (l4 != -1L) {
                zzbg2.zzo(l4);
            }
            if ((mediaType = responseBody.contentType()) != null) {
                zzbg2.zzh(mediaType.toString());
            }
        }
        zzbg2.zzc(response.code());
        zzbg2.zzk(l);
        zzbg2.zzn(l2);
        zzbg2.zzbp();
    }
}

