/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.impl;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.perf.internal.AppStateMonitor;
import com.google.firebase.perf.internal.AppStateUpdateHandler;
import com.google.firebase.perf.internal.GaugeManager;
import com.google.firebase.perf.internal.SessionAwareObject;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Utils;
import com.google.firebase.perf.v1.NetworkRequestMetric;
import com.google.firebase.perf.v1.PerfSession;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class NetworkRequestMetricBuilder
extends AppStateUpdateHandler
implements SessionAwareObject {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final char HIGHEST_CONTROL_CHAR = '\u001f';
    private static final char HIGHEST_ASCII_CHAR = '\u007f';
    private final List<com.google.firebase.perf.internal.PerfSession> sessions;
    private final GaugeManager gaugeManager;
    private final TransportManager transportManager;
    private final NetworkRequestMetric.Builder networkRequestMetricBuilder = NetworkRequestMetric.newBuilder();
    @Nullable
    private String userAgent;
    private boolean isReportSent;
    private boolean isManualNetworkRequestMetric;
    private final WeakReference<SessionAwareObject> weakReference = new WeakReference<NetworkRequestMetricBuilder>(this);

    @Override
    public void updateSession(com.google.firebase.perf.internal.PerfSession session) {
        if (session == null) {
            logger.info("Unable to add new SessionId to the Network Trace. Continuing without it.");
            return;
        }
        if (this.hasStarted() && !this.isStopped()) {
            this.sessions.add(session);
        }
    }

    public static NetworkRequestMetricBuilder builder(TransportManager transportManager) {
        return new NetworkRequestMetricBuilder(transportManager);
    }

    private NetworkRequestMetricBuilder(TransportManager transportManager) {
        this(transportManager, AppStateMonitor.getInstance(), GaugeManager.getInstance());
    }

    public NetworkRequestMetricBuilder(TransportManager transportManager, AppStateMonitor appStateMonitor, GaugeManager gaugeManager) {
        super(appStateMonitor);
        this.transportManager = transportManager;
        this.gaugeManager = gaugeManager;
        this.sessions = Collections.synchronizedList(new ArrayList());
        this.registerForAppState();
    }

    public void setManualNetworkRequestMetric() {
        this.isManualNetworkRequestMetric = true;
    }

    public NetworkRequestMetricBuilder setUrl(@Nullable String url) {
        if (url != null) {
            url = Utils.stripSensitiveInfo(url);
            this.networkRequestMetricBuilder.setUrl(Utils.truncateURL(url, 2000));
        }
        return this;
    }

    public String getUrl() {
        return this.networkRequestMetricBuilder.getUrl();
    }

    public NetworkRequestMetricBuilder setUserAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public NetworkRequestMetricBuilder setHttpMethod(@Nullable String method) {
        if (method != null) {
            NetworkRequestMetric.HttpMethod httpMethod = NetworkRequestMetric.HttpMethod.HTTP_METHOD_UNKNOWN;
            String string = method.toUpperCase();
            int n = -1;
            switch (string.hashCode()) {
                case 70454: {
                    if (!string.equals("GET")) break;
                    n = 0;
                    break;
                }
                case 79599: {
                    if (!string.equals("PUT")) break;
                    n = 1;
                    break;
                }
                case 2461856: {
                    if (!string.equals("POST")) break;
                    n = 2;
                    break;
                }
                case 2012838315: {
                    if (!string.equals("DELETE")) break;
                    n = 3;
                    break;
                }
                case 2213344: {
                    if (!string.equals("HEAD")) break;
                    n = 4;
                    break;
                }
                case 75900968: {
                    if (!string.equals("PATCH")) break;
                    n = 5;
                    break;
                }
                case -531492226: {
                    if (!string.equals("OPTIONS")) break;
                    n = 6;
                    break;
                }
                case 80083237: {
                    if (!string.equals("TRACE")) break;
                    n = 7;
                    break;
                }
                case 1669334218: {
                    if (!string.equals("CONNECT")) break;
                    n = 8;
                }
            }
            switch (n) {
                case 0: {
                    httpMethod = NetworkRequestMetric.HttpMethod.GET;
                    break;
                }
                case 1: {
                    httpMethod = NetworkRequestMetric.HttpMethod.PUT;
                    break;
                }
                case 2: {
                    httpMethod = NetworkRequestMetric.HttpMethod.POST;
                    break;
                }
                case 3: {
                    httpMethod = NetworkRequestMetric.HttpMethod.DELETE;
                    break;
                }
                case 4: {
                    httpMethod = NetworkRequestMetric.HttpMethod.HEAD;
                    break;
                }
                case 5: {
                    httpMethod = NetworkRequestMetric.HttpMethod.PATCH;
                    break;
                }
                case 6: {
                    httpMethod = NetworkRequestMetric.HttpMethod.OPTIONS;
                    break;
                }
                case 7: {
                    httpMethod = NetworkRequestMetric.HttpMethod.TRACE;
                    break;
                }
                case 8: {
                    httpMethod = NetworkRequestMetric.HttpMethod.CONNECT;
                    break;
                }
                default: {
                    httpMethod = NetworkRequestMetric.HttpMethod.HTTP_METHOD_UNKNOWN;
                }
            }
            this.networkRequestMetricBuilder.setHttpMethod(httpMethod);
        }
        return this;
    }

    public NetworkRequestMetricBuilder setHttpResponseCode(int code) {
        this.networkRequestMetricBuilder.setHttpResponseCode(code);
        return this;
    }

    public boolean hasHttpResponseCode() {
        return this.networkRequestMetricBuilder.hasHttpResponseCode();
    }

    public NetworkRequestMetricBuilder setRequestPayloadBytes(long bytes) {
        this.networkRequestMetricBuilder.setRequestPayloadBytes(bytes);
        return this;
    }

    public NetworkRequestMetricBuilder setCustomAttributes(Map<String, String> attributes) {
        this.networkRequestMetricBuilder.clearCustomAttributes().putAllCustomAttributes(attributes);
        return this;
    }

    public NetworkRequestMetricBuilder setRequestStartTimeMicros(long time) {
        SessionManager sessionManager = SessionManager.getInstance();
        com.google.firebase.perf.internal.PerfSession perfSession = sessionManager.perfSession();
        SessionManager.getInstance().registerForSessionUpdates(this.weakReference);
        this.networkRequestMetricBuilder.setClientStartTimeUs(time);
        this.updateSession(perfSession);
        if (perfSession.isGaugeAndEventCollectionEnabled()) {
            this.gaugeManager.collectGaugeMetricOnce(perfSession.getTimer());
        }
        return this;
    }

    public NetworkRequestMetricBuilder setTimeToRequestCompletedMicros(long time) {
        this.networkRequestMetricBuilder.setTimeToRequestCompletedUs(time);
        return this;
    }

    public NetworkRequestMetricBuilder setTimeToResponseInitiatedMicros(long time) {
        this.networkRequestMetricBuilder.setTimeToResponseInitiatedUs(time);
        return this;
    }

    public long getTimeToResponseInitiatedMicros() {
        return this.networkRequestMetricBuilder.getTimeToResponseInitiatedUs();
    }

    public NetworkRequestMetricBuilder setTimeToResponseCompletedMicros(long time) {
        this.networkRequestMetricBuilder.setTimeToResponseCompletedUs(time);
        if (SessionManager.getInstance().perfSession().isGaugeAndEventCollectionEnabled()) {
            this.gaugeManager.collectGaugeMetricOnce(SessionManager.getInstance().perfSession().getTimer());
        }
        return this;
    }

    public NetworkRequestMetricBuilder setResponsePayloadBytes(long bytes) {
        this.networkRequestMetricBuilder.setResponsePayloadBytes(bytes);
        return this;
    }

    public NetworkRequestMetricBuilder setResponseContentType(@Nullable String contentType) {
        if (contentType == null) {
            this.networkRequestMetricBuilder.clearResponseContentType();
            return this;
        }
        if (NetworkRequestMetricBuilder.isValidContentType(contentType)) {
            this.networkRequestMetricBuilder.setResponseContentType(contentType);
        } else {
            logger.info("The content type of the response is not a valid content-type:" + contentType);
        }
        return this;
    }

    public NetworkRequestMetricBuilder setNetworkClientErrorReason() {
        this.networkRequestMetricBuilder.setNetworkClientErrorReason(NetworkRequestMetric.NetworkClientErrorReason.GENERIC_CLIENT_ERROR);
        return this;
    }

    public NetworkRequestMetric build() {
        SessionManager.getInstance().unregisterForSessionUpdates(this.weakReference);
        this.unregisterForAppState();
        PerfSession[] perfSessions = com.google.firebase.perf.internal.PerfSession.buildAndSort(this.getSessions());
        if (perfSessions != null) {
            this.networkRequestMetricBuilder.addAllPerfSessions(Arrays.asList(perfSessions));
        }
        NetworkRequestMetric metric = (NetworkRequestMetric)this.networkRequestMetricBuilder.build();
        if (!NetworkRequestMetricBuilderUtil.isAllowedUserAgent(this.userAgent)) {
            logger.debug("Dropping network request from a 'User-Agent' that is not allowed");
            return metric;
        }
        if (!this.isReportSent) {
            this.transportManager.log(metric, this.getAppState());
            this.isReportSent = true;
            return metric;
        }
        if (this.isManualNetworkRequestMetric) {
            logger.info("This metric has already been queued for transmission.  Please create a new HttpMetric for each request/response");
        }
        return metric;
    }

    private boolean isStopped() {
        return this.networkRequestMetricBuilder.hasTimeToResponseCompletedUs();
    }

    private boolean hasStarted() {
        return this.networkRequestMetricBuilder.hasClientStartTimeUs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<com.google.firebase.perf.internal.PerfSession> getSessions() {
        List<com.google.firebase.perf.internal.PerfSession> list = this.sessions;
        synchronized (list) {
            ArrayList<com.google.firebase.perf.internal.PerfSession> sessionsListCopy = new ArrayList<com.google.firebase.perf.internal.PerfSession>();
            for (com.google.firebase.perf.internal.PerfSession session : this.sessions) {
                if (session == null) continue;
                sessionsListCopy.add(session);
            }
            return Collections.unmodifiableList(sessionsListCopy);
        }
    }

    @VisibleForTesting
    boolean isReportSent() {
        return this.isReportSent;
    }

    @VisibleForTesting
    void setReportSent() {
        this.isReportSent = true;
    }

    @VisibleForTesting
    void clearBuilderFields() {
        this.networkRequestMetricBuilder.clear();
    }

    private static boolean isValidContentType(String str) {
        if (str.length() > 128) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c > '\u001f' && c <= '\u007f') continue;
            return false;
        }
        return true;
    }
}

