/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.core.app.FrameMetricsAggregator;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.Trace;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Clock;
import com.google.firebase.perf.util.Constants;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.util.Utils;
import com.google.firebase.perf.v1.ApplicationProcessState;
import com.google.firebase.perf.v1.TraceMetric;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class AppStateMonitor
implements Application.ActivityLifecycleCallbacks {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static volatile AppStateMonitor sInstance;
    private static final String FRAME_METRICS_AGGREGATOR_CLASSNAME = "androidx.core.app.FrameMetricsAggregator";
    private boolean mRegistered = false;
    private final TransportManager transportManager;
    private ConfigResolver mConfigResolver;
    private final Clock mClock;
    private boolean mIsColdStart = true;
    private final WeakHashMap<Activity, Boolean> mResumed = new WeakHashMap();
    private Timer mStopTime;
    private Timer mResumeTime;
    private final Map<String, Long> mMetrics = new HashMap<String, Long>();
    private AtomicInteger mTsnsCount = new AtomicInteger(0);
    private ApplicationProcessState mCurrentState = ApplicationProcessState.BACKGROUND;
    private Set<WeakReference<AppStateCallback>> mClients = new HashSet<WeakReference<AppStateCallback>>();
    private boolean hasFrameMetricsAggregator = false;
    private FrameMetricsAggregator mFrameMetricsAggregator;
    private final WeakHashMap<Activity, Trace> mActivity2ScreenTrace = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppStateMonitor getInstance() {
        if (sInstance != null) return sInstance;
        Class<AppStateMonitor> clazz = AppStateMonitor.class;
        synchronized (AppStateMonitor.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AppStateMonitor(TransportManager.getInstance(), new Clock());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    AppStateMonitor(TransportManager transportManager, Clock clock) {
        this.transportManager = transportManager;
        this.mClock = clock;
        this.mConfigResolver = ConfigResolver.getInstance();
        this.hasFrameMetricsAggregator = this.hasFrameMetricsAggregatorClass();
        if (this.hasFrameMetricsAggregator) {
            this.mFrameMetricsAggregator = new FrameMetricsAggregator();
        }
    }

    public synchronized void registerActivityLifecycleCallbacks(Context context) {
        if (this.mRegistered) {
            return;
        }
        Context appContext = context.getApplicationContext();
        if (appContext instanceof Application) {
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mRegistered = true;
        }
    }

    public synchronized void unregisterActivityLifecycleCallbacks(Context context) {
        if (!this.mRegistered) {
            return;
        }
        Context appContext = context.getApplicationContext();
        if (appContext instanceof Application) {
            ((Application)appContext).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mRegistered = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCount(@NonNull String name, long value) {
        Map<String, Long> map = this.mMetrics;
        synchronized (map) {
            Long v = this.mMetrics.get(name);
            if (v == null) {
                this.mMetrics.put(name, value);
            } else {
                this.mMetrics.put(name, v + value);
            }
        }
    }

    public void incrementTsnsCount(int value) {
        this.mTsnsCount.addAndGet(value);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.isScreenTraceSupported(activity) && this.mConfigResolver.isPerformanceMonitoringEnabled()) {
            this.mFrameMetricsAggregator.add(activity);
            Trace screenTrace = new Trace(AppStateMonitor.getScreenTraceName(activity), this.transportManager, this.mClock, this);
            screenTrace.start();
            this.mActivity2ScreenTrace.put(activity, screenTrace);
        }
    }

    public synchronized void onActivityStopped(Activity activity) {
        if (this.isScreenTraceSupported(activity)) {
            this.sendScreenTrace(activity);
        }
        if (this.mResumed.containsKey(activity)) {
            this.mResumed.remove(activity);
            if (this.mResumed.isEmpty()) {
                this.mStopTime = this.mClock.getTime();
                this.updateAppState(ApplicationProcessState.BACKGROUND);
                this.sendSessionLog(Constants.TraceNames.FOREGROUND_TRACE_NAME.toString(), this.mResumeTime, this.mStopTime);
            }
        }
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.mResumed.isEmpty()) {
            this.mResumeTime = this.mClock.getTime();
            this.mResumed.put(activity, true);
            this.updateAppState(ApplicationProcessState.FOREGROUND);
            if (this.mIsColdStart) {
                this.mIsColdStart = false;
            } else {
                this.sendSessionLog(Constants.TraceNames.BACKGROUND_TRACE_NAME.toString(), this.mStopTime, this.mResumeTime);
            }
        } else {
            this.mResumed.put(activity, true);
        }
    }

    public boolean isColdStart() {
        return this.mIsColdStart;
    }

    public ApplicationProcessState getAppState() {
        return this.mCurrentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForAppState(WeakReference<AppStateCallback> client) {
        Set<WeakReference<AppStateCallback>> set = this.mClients;
        synchronized (set) {
            this.mClients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForAppState(WeakReference<AppStateCallback> client) {
        Set<WeakReference<AppStateCallback>> set = this.mClients;
        synchronized (set) {
            this.mClients.remove(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAppState(ApplicationProcessState newState) {
        this.mCurrentState = newState;
        Set<WeakReference<AppStateCallback>> set = this.mClients;
        synchronized (set) {
            Iterator<WeakReference<AppStateCallback>> i = this.mClients.iterator();
            while (i.hasNext()) {
                AppStateCallback callback = (AppStateCallback)i.next().get();
                if (callback != null) {
                    callback.onUpdateAppState(this.mCurrentState);
                    continue;
                }
                i.remove();
            }
        }
    }

    public boolean isForeground() {
        return this.mCurrentState == ApplicationProcessState.FOREGROUND;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityPaused(Activity activity) {
    }

    private void sendScreenTrace(Activity activity) {
        SparseIntArray frameTimes;
        if (!this.mActivity2ScreenTrace.containsKey(activity)) {
            return;
        }
        Trace screenTrace = this.mActivity2ScreenTrace.get(activity);
        if (screenTrace == null) {
            return;
        }
        this.mActivity2ScreenTrace.remove(activity);
        int totalFrames = 0;
        int slowFrames = 0;
        int frozenFrames = 0;
        SparseIntArray[] arr = this.mFrameMetricsAggregator.remove(activity);
        if (arr != null && (frameTimes = arr[0]) != null) {
            for (int i = 0; i < frameTimes.size(); ++i) {
                int frameTime = frameTimes.keyAt(i);
                int numFrames = frameTimes.valueAt(i);
                totalFrames += numFrames;
                if (frameTime > 700) {
                    frozenFrames += numFrames;
                }
                if (frameTime <= 16) continue;
                slowFrames += numFrames;
            }
        }
        if (totalFrames != 0 || slowFrames != 0 || frozenFrames == 0) {
            // empty if block
        }
        if (totalFrames > 0) {
            screenTrace.putMetric(Constants.CounterNames.FRAMES_TOTAL.toString(), totalFrames);
        }
        if (slowFrames > 0) {
            screenTrace.putMetric(Constants.CounterNames.FRAMES_SLOW.toString(), slowFrames);
        }
        if (frozenFrames > 0) {
            screenTrace.putMetric(Constants.CounterNames.FRAMES_FROZEN.toString(), frozenFrames);
        }
        if (Utils.isDebugLoggingEnabled(activity.getApplicationContext())) {
            logger.debug("sendScreenTrace name:" + AppStateMonitor.getScreenTraceName(activity) + " _fr_tot:" + totalFrames + " _fr_slo:" + slowFrames + " _fr_fzn:" + frozenFrames);
        }
        screenTrace.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSessionLog(String name, Timer startTime, Timer endTime) {
        if (!this.mConfigResolver.isPerformanceMonitoringEnabled()) {
            return;
        }
        TraceMetric.Builder metric = TraceMetric.newBuilder().setName(name).setClientStartTimeUs(startTime.getMicros()).setDurationUs(startTime.getDurationMicros(endTime)).addPerfSessions(SessionManager.getInstance().perfSession().build());
        int tsnsCount = this.mTsnsCount.getAndSet(0);
        Map<String, Long> map = this.mMetrics;
        synchronized (map) {
            metric.putAllCounters(this.mMetrics);
            if (tsnsCount != 0) {
                metric.putCounters(Constants.CounterNames.TRACE_STARTED_NOT_STOPPED.toString(), tsnsCount);
            }
            this.mMetrics.clear();
        }
        this.transportManager.log((TraceMetric)metric.build(), ApplicationProcessState.FOREGROUND_BACKGROUND);
    }

    private boolean isScreenTraceSupported(Activity activity) {
        return this.hasFrameMetricsAggregator && activity.getWindow() != null && (activity.getWindow().getAttributes().flags & 0x1000000) != 0;
    }

    private boolean hasFrameMetricsAggregatorClass() {
        try {
            Class<?> initializerClass = Class.forName(FRAME_METRICS_AGGREGATOR_CLASSNAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String getScreenTraceName(Activity activity) {
        return "_st_" + activity.getClass().getSimpleName();
    }

    @VisibleForTesting
    WeakHashMap<Activity, Boolean> getResumed() {
        return this.mResumed;
    }

    @VisibleForTesting
    WeakHashMap<Activity, Trace> getActivity2ScreenTrace() {
        return this.mActivity2ScreenTrace;
    }

    @VisibleForTesting
    Timer getPauseTime() {
        return this.mStopTime;
    }

    @VisibleForTesting
    Timer getResumeTime() {
        return this.mResumeTime;
    }

    @VisibleForTesting
    void setIsColdStart(boolean isColdStart) {
        this.mIsColdStart = isColdStart;
    }

    public static interface AppStateCallback {
        public void onUpdateAppState(ApplicationProcessState var1);
    }
}

