/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.perf.internal.PerfMetricValidator;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.URLAllowlist;
import com.google.firebase.perf.v1.NetworkRequestMetric;
import java.net.URI;

final class FirebasePerfNetworkValidator
extends PerfMetricValidator {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final String HTTP_SCHEMA = "http";
    private static final String HTTPS = "https";
    private static final int EMPTY_PORT = -1;
    private final NetworkRequestMetric mNetworkMetric;
    private final Context context;

    FirebasePerfNetworkValidator(NetworkRequestMetric networkRequestMetric, Context context) {
        this.context = context;
        this.mNetworkMetric = networkRequestMetric;
    }

    @Override
    public boolean isValidPerfMetric() {
        if (this.isEmptyUrl(this.mNetworkMetric.getUrl())) {
            logger.info("URL is missing:" + this.mNetworkMetric.getUrl());
            return false;
        }
        URI uri = this.getResultUrl(this.mNetworkMetric.getUrl());
        if (uri == null) {
            logger.info("URL cannot be parsed");
            return false;
        }
        if (!this.isAllowlisted(uri, this.context)) {
            logger.info("URL fails allowlist rule: " + uri);
            return false;
        }
        if (!this.isValidHost(uri.getHost())) {
            logger.info("URL host is null or invalid");
            return false;
        }
        if (!this.isValidScheme(uri.getScheme())) {
            logger.info("URL scheme is null or invalid");
            return false;
        }
        if (!this.isValidUserInfo(uri.getUserInfo())) {
            logger.info("URL user info is null");
            return false;
        }
        if (!this.isValidPort(uri.getPort())) {
            logger.info("URL port is less than or equal to 0");
            return false;
        }
        if (!this.isValidHttpMethod(this.mNetworkMetric.hasHttpMethod() ? this.mNetworkMetric.getHttpMethod() : null)) {
            logger.info("HTTP Method is null or invalid: " + (Object)((Object)this.mNetworkMetric.getHttpMethod()));
            return false;
        }
        if (this.mNetworkMetric.hasHttpResponseCode() && !this.isValidHttpResponseCode(this.mNetworkMetric.getHttpResponseCode())) {
            logger.info("HTTP ResponseCode is a negative value:" + this.mNetworkMetric.getHttpResponseCode());
            return false;
        }
        if (this.mNetworkMetric.hasRequestPayloadBytes() && !this.isValidPayload(this.mNetworkMetric.getRequestPayloadBytes())) {
            logger.info("Request Payload is a negative value:" + this.mNetworkMetric.getRequestPayloadBytes());
            return false;
        }
        if (this.mNetworkMetric.hasResponsePayloadBytes() && !this.isValidPayload(this.mNetworkMetric.getResponsePayloadBytes())) {
            logger.info("Response Payload is a negative value:" + this.mNetworkMetric.getResponsePayloadBytes());
            return false;
        }
        if (!this.mNetworkMetric.hasClientStartTimeUs() || this.mNetworkMetric.getClientStartTimeUs() <= 0L) {
            logger.info("Start time of the request is null, or zero, or a negative value:" + this.mNetworkMetric.getClientStartTimeUs());
            return false;
        }
        if (this.mNetworkMetric.hasTimeToRequestCompletedUs() && !this.isValidTime(this.mNetworkMetric.getTimeToRequestCompletedUs())) {
            logger.info("Time to complete the request is a negative value:" + this.mNetworkMetric.getTimeToRequestCompletedUs());
            return false;
        }
        if (this.mNetworkMetric.hasTimeToResponseInitiatedUs() && !this.isValidTime(this.mNetworkMetric.getTimeToResponseInitiatedUs())) {
            logger.info("Time from the start of the request to the start of the response is null or a negative value:" + this.mNetworkMetric.getTimeToResponseInitiatedUs());
            return false;
        }
        if (!this.mNetworkMetric.hasTimeToResponseCompletedUs() || this.mNetworkMetric.getTimeToResponseCompletedUs() <= 0L) {
            logger.info("Time from the start of the request to the end of the response is null, negative or zero:" + this.mNetworkMetric.getTimeToResponseCompletedUs());
            return false;
        }
        if (!this.mNetworkMetric.hasHttpResponseCode()) {
            logger.info("Did not receive a HTTP Response Code");
            return false;
        }
        return true;
    }

    private boolean isEmptyUrl(@Nullable String url) {
        return this.isBlank(url);
    }

    @Nullable
    private URI getResultUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        try {
            return URI.create(url);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            logger.warn("getResultUrl throws exception %s", e.getMessage());
            return null;
        }
    }

    private boolean isAllowlisted(@Nullable URI uri, @NonNull Context context) {
        if (uri == null) {
            return false;
        }
        return URLAllowlist.isURLAllowlisted(uri, context);
    }

    private boolean isValidHost(@Nullable String host) {
        return host != null && !this.isBlank(host) && host.length() <= 255;
    }

    private boolean isValidPort(int port) {
        return port == -1 || port > 0;
    }

    private boolean isValidUserInfo(@Nullable String userInfo) {
        return userInfo == null;
    }

    private boolean isValidScheme(@Nullable String scheme) {
        if (scheme == null) {
            return false;
        }
        return HTTP_SCHEMA.equalsIgnoreCase(scheme) || HTTPS.equalsIgnoreCase(scheme);
    }

    boolean isValidHttpMethod(@Nullable NetworkRequestMetric.HttpMethod httpMethod) {
        return httpMethod != null && httpMethod != NetworkRequestMetric.HttpMethod.HTTP_METHOD_UNKNOWN;
    }

    private boolean isValidHttpResponseCode(int responseCode) {
        return responseCode > 0;
    }

    private boolean isValidTime(long time) {
        return time >= 0L;
    }

    private boolean isValidPayload(long payload) {
        return payload >= 0L;
    }

    private boolean isBlank(@Nullable String str) {
        if (str == null) {
            return true;
        }
        str = str.trim();
        return str.isEmpty();
    }
}

