/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.concurrent.atomic.AtomicLong;

public class Counter
implements Parcelable {
    private final String mName;
    private AtomicLong mCount;
    public static final Parcelable.Creator<Counter> CREATOR = new Parcelable.Creator<Counter>(){

        public Counter createFromParcel(Parcel in) {
            return new Counter(in);
        }

        public Counter[] newArray(int size) {
            return new Counter[size];
        }
    };

    public Counter(@NonNull String name) {
        this.mName = name;
        this.mCount = new AtomicLong(0L);
    }

    private Counter(Parcel in) {
        this.mName = in.readString();
        this.mCount = new AtomicLong(in.readLong());
    }

    public void increment(long counts) {
        this.mCount.addAndGet(counts);
    }

    @NonNull
    String getName() {
        return this.mName;
    }

    long getCount() {
        return this.mCount.get();
    }

    void setCount(long newCount) {
        this.mCount.set(newCount);
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mName);
        out.writeLong(this.mCount.get());
    }

    public int describeContents() {
        return 0;
    }
}

