/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.session;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.perf.application.AppStateMonitor;
import com.google.firebase.perf.application.AppStateUpdateHandler;
import com.google.firebase.perf.session.PerfSession;
import com.google.firebase.perf.session.SessionAwareObject;
import com.google.firebase.perf.session.gauges.GaugeManager;
import com.google.firebase.perf.v1.ApplicationProcessState;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Keep
public class SessionManager
extends AppStateUpdateHandler {
    @SuppressLint(value={"StaticFieldLeak"})
    private static final SessionManager instance = new SessionManager();
    private final GaugeManager gaugeManager;
    private final AppStateMonitor appStateMonitor;
    private final Set<WeakReference<SessionAwareObject>> clients = new HashSet<WeakReference<SessionAwareObject>>();
    private PerfSession perfSession;
    private Future syncInitFuture;

    public static SessionManager getInstance() {
        return instance;
    }

    public final PerfSession perfSession() {
        return this.perfSession;
    }

    private SessionManager() {
        this(GaugeManager.getInstance(), PerfSession.createWithId(UUID.randomUUID().toString()), AppStateMonitor.getInstance());
    }

    @VisibleForTesting
    public SessionManager(GaugeManager gaugeManager, PerfSession perfSession, AppStateMonitor appStateMonitor) {
        this.gaugeManager = gaugeManager;
        this.perfSession = perfSession;
        this.appStateMonitor = appStateMonitor;
        this.registerForAppState();
    }

    public void setApplicationContext(Context appContext) {
        PerfSession appStartSession = this.perfSession;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        this.syncInitFuture = executorService.submit(() -> {
            this.gaugeManager.initializeGaugeMetadataManager(appContext);
            if (appStartSession.isGaugeAndEventCollectionEnabled()) {
                this.gaugeManager.logGaugeMetadata(appStartSession.sessionId(), ApplicationProcessState.FOREGROUND);
            }
        });
    }

    @Override
    public void onUpdateAppState(ApplicationProcessState newAppState) {
        super.onUpdateAppState(newAppState);
        if (this.appStateMonitor.isColdStart()) {
            return;
        }
        if (newAppState == ApplicationProcessState.FOREGROUND) {
            PerfSession session = PerfSession.createWithId(UUID.randomUUID().toString());
            this.updatePerfSession(session);
        } else if (this.perfSession.isSessionRunningTooLong()) {
            PerfSession session = PerfSession.createWithId(UUID.randomUUID().toString());
            this.updatePerfSession(session);
        } else {
            this.startOrStopCollectingGauges(newAppState);
        }
    }

    public void stopGaugeCollectionIfSessionRunningTooLong() {
        if (this.perfSession.isSessionRunningTooLong()) {
            this.gaugeManager.stopCollectingGauges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePerfSession(PerfSession perfSession) {
        if (perfSession.sessionId() == this.perfSession.sessionId()) {
            return;
        }
        this.perfSession = perfSession;
        Set<WeakReference<SessionAwareObject>> set = this.clients;
        synchronized (set) {
            Iterator<WeakReference<SessionAwareObject>> i = this.clients.iterator();
            while (i.hasNext()) {
                SessionAwareObject callback = (SessionAwareObject)i.next().get();
                if (callback != null) {
                    callback.updateSession(perfSession);
                    continue;
                }
                i.remove();
            }
        }
        this.logGaugeMetadataIfCollectionEnabled(this.appStateMonitor.getAppState());
        this.startOrStopCollectingGauges(this.appStateMonitor.getAppState());
    }

    public void initializeGaugeCollection() {
        this.logGaugeMetadataIfCollectionEnabled(ApplicationProcessState.FOREGROUND);
        this.startOrStopCollectingGauges(ApplicationProcessState.FOREGROUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForSessionUpdates(WeakReference<SessionAwareObject> client) {
        Set<WeakReference<SessionAwareObject>> set = this.clients;
        synchronized (set) {
            this.clients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForSessionUpdates(WeakReference<SessionAwareObject> client) {
        Set<WeakReference<SessionAwareObject>> set = this.clients;
        synchronized (set) {
            this.clients.remove(client);
        }
    }

    private void logGaugeMetadataIfCollectionEnabled(ApplicationProcessState appState) {
        if (this.perfSession.isGaugeAndEventCollectionEnabled()) {
            this.gaugeManager.logGaugeMetadata(this.perfSession.sessionId(), appState);
        }
    }

    private void startOrStopCollectingGauges(ApplicationProcessState appState) {
        if (this.perfSession.isGaugeAndEventCollectionEnabled()) {
            this.gaugeManager.startCollectingGauges(this.perfSession, appState);
        } else {
            this.gaugeManager.stopCollectingGauges();
        }
    }

    @VisibleForTesting
    public void setPerfSession(PerfSession perfSession) {
        this.perfSession = perfSession;
    }

    @VisibleForTesting
    public Future getSyncInitFuture() {
        return this.syncInitFuture;
    }
}

