// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: firebase/perf/v1/perf_metric.proto

// Protobuf Java Version: 3.25.5
package com.google.firebase.perf.v1;

public interface NetworkRequestMetricOrBuilder extends
    // @@protoc_insertion_point(interface_extends:firebase.perf.v1.NetworkRequestMetric)
    com.google.protobuf.MessageLiteOrBuilder {

  /**
   * <pre>
   * The parameterless url to which the network request was made. The sdk will
   * redact the unnecessary components of the URL and only log the components
   * which are useful. For a url of the form
   * scheme://host[:port]/path[?params][#fragment], the sdk should only log
   * scheme://host[:port]/path
   * Example:
   * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
   * Logged Url: https://wwww.google.com/maps/cities
   * </pre>
   *
   * <code>optional string url = 1;</code>
   * @return Whether the url field is set.
   */
  boolean hasUrl();
  /**
   * <pre>
   * The parameterless url to which the network request was made. The sdk will
   * redact the unnecessary components of the URL and only log the components
   * which are useful. For a url of the form
   * scheme://host[:port]/path[?params][#fragment], the sdk should only log
   * scheme://host[:port]/path
   * Example:
   * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
   * Logged Url: https://wwww.google.com/maps/cities
   * </pre>
   *
   * <code>optional string url = 1;</code>
   * @return The url.
   */
  java.lang.String getUrl();
  /**
   * <pre>
   * The parameterless url to which the network request was made. The sdk will
   * redact the unnecessary components of the URL and only log the components
   * which are useful. For a url of the form
   * scheme://host[:port]/path[?params][#fragment], the sdk should only log
   * scheme://host[:port]/path
   * Example:
   * Captured Url: https://wwww.google.com/maps/cities#seattle?id=123
   * Logged Url: https://wwww.google.com/maps/cities
   * </pre>
   *
   * <code>optional string url = 1;</code>
   * @return The bytes for url.
   */
  com.google.protobuf.ByteString
      getUrlBytes();

  /**
   * <pre>
   * The HTTP verb for the network request. Common values include GET,
   * PUT, POST and DELETE
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.HttpMethod http_method = 2;</code>
   * @return Whether the httpMethod field is set.
   */
  boolean hasHttpMethod();
  /**
   * <pre>
   * The HTTP verb for the network request. Common values include GET,
   * PUT, POST and DELETE
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.HttpMethod http_method = 2;</code>
   * @return The httpMethod.
   */
  com.google.firebase.perf.v1.NetworkRequestMetric.HttpMethod getHttpMethod();

  /**
   * <pre>
   * The size of the payload in the request.
   * </pre>
   *
   * <code>optional int64 request_payload_bytes = 3;</code>
   * @return Whether the requestPayloadBytes field is set.
   */
  boolean hasRequestPayloadBytes();
  /**
   * <pre>
   * The size of the payload in the request.
   * </pre>
   *
   * <code>optional int64 request_payload_bytes = 3;</code>
   * @return The requestPayloadBytes.
   */
  long getRequestPayloadBytes();

  /**
   * <pre>
   * The size of the payload in the response.
   * </pre>
   *
   * <code>optional int64 response_payload_bytes = 4;</code>
   * @return Whether the responsePayloadBytes field is set.
   */
  boolean hasResponsePayloadBytes();
  /**
   * <pre>
   * The size of the payload in the response.
   * </pre>
   *
   * <code>optional int64 response_payload_bytes = 4;</code>
   * @return The responsePayloadBytes.
   */
  long getResponsePayloadBytes();

  /**
   * <pre>
   * The client error received from the networking library.
   * Do not record a client error if we have HTTP response code available.
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason network_client_error_reason = 11;</code>
   * @return Whether the networkClientErrorReason field is set.
   */
  boolean hasNetworkClientErrorReason();
  /**
   * <pre>
   * The client error received from the networking library.
   * Do not record a client error if we have HTTP response code available.
   * </pre>
   *
   * <code>optional .firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason network_client_error_reason = 11;</code>
   * @return The networkClientErrorReason.
   */
  com.google.firebase.perf.v1.NetworkRequestMetric.NetworkClientErrorReason getNetworkClientErrorReason();

  /**
   * <pre>
   * The Http response code received from the server.
   * </pre>
   *
   * <code>optional int32 http_response_code = 5;</code>
   * @return Whether the httpResponseCode field is set.
   */
  boolean hasHttpResponseCode();
  /**
   * <pre>
   * The Http response code received from the server.
   * </pre>
   *
   * <code>optional int32 http_response_code = 5;</code>
   * @return The httpResponseCode.
   */
  int getHttpResponseCode();

  /**
   * <pre>
   * The value of the content type header in the response.
   * </pre>
   *
   * <code>optional string response_content_type = 6;</code>
   * @return Whether the responseContentType field is set.
   */
  boolean hasResponseContentType();
  /**
   * <pre>
   * The value of the content type header in the response.
   * </pre>
   *
   * <code>optional string response_content_type = 6;</code>
   * @return The responseContentType.
   */
  java.lang.String getResponseContentType();
  /**
   * <pre>
   * The value of the content type header in the response.
   * </pre>
   *
   * <code>optional string response_content_type = 6;</code>
   * @return The bytes for responseContentType.
   */
  com.google.protobuf.ByteString
      getResponseContentTypeBytes();

  /**
   * <pre>
   * The timestamp in microseconds since epoch when the network request was
   * initiated. This time is recorded using the device clock.
   * </pre>
   *
   * <code>optional int64 client_start_time_us = 7;</code>
   * @return Whether the clientStartTimeUs field is set.
   */
  boolean hasClientStartTimeUs();
  /**
   * <pre>
   * The timestamp in microseconds since epoch when the network request was
   * initiated. This time is recorded using the device clock.
   * </pre>
   *
   * <code>optional int64 client_start_time_us = 7;</code>
   * @return The clientStartTimeUs.
   */
  long getClientStartTimeUs();

  /**
   * <pre>
   * The time in microseconds since the start of the network request and the
   * upload of the last request byte.
   * </pre>
   *
   * <code>optional int64 time_to_request_completed_us = 8;</code>
   * @return Whether the timeToRequestCompletedUs field is set.
   */
  boolean hasTimeToRequestCompletedUs();
  /**
   * <pre>
   * The time in microseconds since the start of the network request and the
   * upload of the last request byte.
   * </pre>
   *
   * <code>optional int64 time_to_request_completed_us = 8;</code>
   * @return The timeToRequestCompletedUs.
   */
  long getTimeToRequestCompletedUs();

  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the first byte of the response headers.
   * </pre>
   *
   * <code>optional int64 time_to_response_initiated_us = 9;</code>
   * @return Whether the timeToResponseInitiatedUs field is set.
   */
  boolean hasTimeToResponseInitiatedUs();
  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the first byte of the response headers.
   * </pre>
   *
   * <code>optional int64 time_to_response_initiated_us = 9;</code>
   * @return The timeToResponseInitiatedUs.
   */
  long getTimeToResponseInitiatedUs();

  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the last response byte.
   * </pre>
   *
   * <code>optional int64 time_to_response_completed_us = 10;</code>
   * @return Whether the timeToResponseCompletedUs field is set.
   */
  boolean hasTimeToResponseCompletedUs();
  /**
   * <pre>
   * The time in microseconds between the start of the network request and the
   * receipt of the last response byte.
   * </pre>
   *
   * <code>optional int64 time_to_response_completed_us = 10;</code>
   * @return The timeToResponseCompletedUs.
   */
  long getTimeToResponseCompletedUs();

  /**
   * <pre>
   * A map of network-level custom attribute names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
   */
  int getCustomAttributesCount();
  /**
   * <pre>
   * A map of network-level custom attribute names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
   */
  boolean containsCustomAttributes(
      java.lang.String key);
  /**
   * Use {@link #getCustomAttributesMap()} instead.
   */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String>
  getCustomAttributes();
  /**
   * <pre>
   * A map of network-level custom attribute names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
   */
  java.util.Map<java.lang.String, java.lang.String>
  getCustomAttributesMap();
  /**
   * <pre>
   * A map of network-level custom attribute names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
   */

  /* nullable */
java.lang.String getCustomAttributesOrDefault(
      java.lang.String key,
      /* nullable */
java.lang.String defaultValue);
  /**
   * <pre>
   * A map of network-level custom attribute names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 12;</code>
   */

  java.lang.String getCustomAttributesOrThrow(
      java.lang.String key);

  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  java.util.List<com.google.firebase.perf.v1.PerfSession> 
      getPerfSessionsList();
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  com.google.firebase.perf.v1.PerfSession getPerfSessions(int index);
  /**
   * <pre>
   * Sessions across which the network request spanned. A session lasts
   * from one change in the app state (foreground/background) to the next.
   * Basically every foreground and background session gets it's own session id.
   * A network request may span across multiple such sessions. So we need a list
   * to identify which sessions it spanned across.
   * </pre>
   *
   * <code>repeated .firebase.perf.v1.PerfSession perf_sessions = 13;</code>
   */
  int getPerfSessionsCount();
}
