/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf;

import androidx.annotation.Keep;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.StartupTime;
import com.google.firebase.annotations.concurrent.UiThread;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Qualified;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.perf.FirebasePerfEarly;
import com.google.firebase.perf.FirebasePerformance;
import com.google.firebase.perf.injection.components.DaggerFirebasePerformanceComponent;
import com.google.firebase.perf.injection.components.FirebasePerformanceComponent;
import com.google.firebase.perf.injection.modules.FirebasePerformanceModule;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import com.google.firebase.remoteconfig.RemoteConfigComponent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;

@Keep
public class FirebasePerfRegistrar
implements ComponentRegistrar {
    private static final String LIBRARY_NAME = "fire-perf";
    private static final String EARLY_LIBRARY_NAME = "fire-perf-early";

    @Keep
    public List<Component<?>> getComponents() {
        Qualified uiExecutor = Qualified.qualified(UiThread.class, Executor.class);
        return Arrays.asList(Component.builder(FirebasePerformance.class).name(LIBRARY_NAME).add(Dependency.required(FirebaseApp.class)).add(Dependency.requiredProvider(RemoteConfigComponent.class)).add(Dependency.required(FirebaseInstallationsApi.class)).add(Dependency.requiredProvider(TransportFactory.class)).add(Dependency.required(FirebasePerfEarly.class)).factory(FirebasePerfRegistrar::providesFirebasePerformance).build(), Component.builder(FirebasePerfEarly.class).name(EARLY_LIBRARY_NAME).add(Dependency.required(FirebaseApp.class)).add(Dependency.optionalProvider(StartupTime.class)).add(Dependency.required((Qualified)uiExecutor)).eagerInDefaultApp().factory(container -> new FirebasePerfEarly((FirebaseApp)container.get(FirebaseApp.class), (StartupTime)container.getProvider(StartupTime.class).get(), (Executor)container.get(uiExecutor))).build(), LibraryVersionComponent.create((String)LIBRARY_NAME, (String)"22.0.3"));
    }

    private static FirebasePerformance providesFirebasePerformance(ComponentContainer container) {
        container.get(FirebasePerfEarly.class);
        FirebasePerformanceComponent component = DaggerFirebasePerformanceComponent.builder().firebasePerformanceModule(new FirebasePerformanceModule((FirebaseApp)container.get(FirebaseApp.class), (FirebaseInstallationsApi)container.get(FirebaseInstallationsApi.class), (Provider<RemoteConfigComponent>)container.getProvider(RemoteConfigComponent.class), (Provider<TransportFactory>)container.getProvider(TransportFactory.class))).build();
        return component.getFirebasePerformance();
    }
}

