/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics.validator;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.validator.FirebasePerfApplicationInfoValidator;
import com.google.firebase.perf.metrics.validator.FirebasePerfGaugeMetricValidator;
import com.google.firebase.perf.metrics.validator.FirebasePerfNetworkValidator;
import com.google.firebase.perf.metrics.validator.FirebasePerfTraceValidator;
import com.google.firebase.perf.util.Constants;
import com.google.firebase.perf.v1.PerfMetric;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PerfMetricValidator {
    private static final Pattern ATTRIBUTE_KEY_PATTERN = Pattern.compile("^(?!(firebase_|google_|ga_))[A-Za-z][A-Za-z_0-9]*");

    @NonNull
    private static List<PerfMetricValidator> getValidators(@NonNull PerfMetric perfMetric, @NonNull Context context) {
        ArrayList<PerfMetricValidator> validators = new ArrayList<PerfMetricValidator>();
        if (perfMetric.hasTraceMetric()) {
            validators.add(new FirebasePerfTraceValidator(perfMetric.getTraceMetric()));
        }
        if (perfMetric.hasNetworkRequestMetric()) {
            validators.add(new FirebasePerfNetworkValidator(perfMetric.getNetworkRequestMetric(), context));
        }
        if (perfMetric.hasApplicationInfo()) {
            validators.add(new FirebasePerfApplicationInfoValidator(perfMetric.getApplicationInfo()));
        }
        if (perfMetric.hasGaugeMetric()) {
            validators.add(new FirebasePerfGaugeMetricValidator(perfMetric.getGaugeMetric()));
        }
        return validators;
    }

    public static boolean isValid(@NonNull PerfMetric perfMetric, @NonNull Context context) {
        List<PerfMetricValidator> validators = PerfMetricValidator.getValidators(perfMetric, context);
        if (validators.isEmpty()) {
            AndroidLogger.getInstance().debug("No validators found for PerfMetric.");
            return false;
        }
        for (PerfMetricValidator validator : validators) {
            if (validator.isValidPerfMetric()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String validateTraceName(@Nullable String str) {
        if (str == null) {
            return "Trace name must not be null";
        }
        if (str.length() > 100) {
            return String.format(Locale.US, "Trace name must not exceed %d characters", 100);
        }
        if (str.startsWith("_")) {
            Constants.TraceNames[] validTraceNames;
            for (Constants.TraceNames traceName : validTraceNames = Constants.TraceNames.values()) {
                if (!traceName.toString().equals(str)) continue;
                return null;
            }
            if (str.startsWith("_st_")) {
                return null;
            }
            return "Trace name must not start with '_'";
        }
        return null;
    }

    @Nullable
    public static String validateMetricName(@Nullable String str) {
        if (str == null) {
            return "Metric name must not be null";
        }
        if (str.length() > 100) {
            return String.format(Locale.US, "Metric name must not exceed %d characters", 100);
        }
        if (str.startsWith("_")) {
            Constants.CounterNames[] validCounterNames;
            for (Constants.CounterNames counterName : validCounterNames = Constants.CounterNames.values()) {
                if (!counterName.toString().equals(str)) continue;
                return null;
            }
            return "Metric name must not start with '_'";
        }
        return null;
    }

    public static void validateAttribute(@NonNull String key, @NonNull String value) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Attribute key must not be null or empty");
        }
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("Attribute value must not be null or empty");
        }
        if (key.length() > 40) {
            throw new IllegalArgumentException(String.format(Locale.US, "Attribute key length must not exceed %d characters", 40));
        }
        if (value.length() > 100) {
            throw new IllegalArgumentException(String.format(Locale.US, "Attribute value length must not exceed %d characters", 100));
        }
        Matcher attributeKeyMatcher = ATTRIBUTE_KEY_PATTERN.matcher(key);
        if (!attributeKeyMatcher.matches()) {
            throw new IllegalArgumentException("Attribute key must start with letter, must only contain alphanumeric characters and underscore and must not start with \"firebase_\", \"google_\" and \"ga_");
        }
    }

    public abstract boolean isValidPerfMetric();
}

