/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import android.os.Build;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.InstrHttpInputStream;
import com.google.firebase.perf.network.InstrHttpOutputStream;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.util.List;
import java.util.Map;

class InstrURLConnectionBase {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final String USER_AGENT_PROPERTY = "User-Agent";
    private final HttpURLConnection httpUrlConnection;
    private final NetworkRequestMetricBuilder networkMetricBuilder;
    private long timeRequestedInMicros = -1L;
    private long timeToResponseInitiatedInMicros = -1L;
    private final Timer timer;

    public InstrURLConnectionBase(HttpURLConnection connection, Timer timer, NetworkRequestMetricBuilder builder) {
        this.httpUrlConnection = connection;
        this.networkMetricBuilder = builder;
        this.timer = timer;
        this.networkMetricBuilder.setUrl(this.httpUrlConnection.getURL().toString());
    }

    public void connect() throws IOException {
        if (this.timeRequestedInMicros == -1L) {
            this.timer.reset();
            this.timeRequestedInMicros = this.timer.getMicros();
            this.networkMetricBuilder.setRequestStartTimeMicros(this.timeRequestedInMicros);
        }
        try {
            this.httpUrlConnection.connect();
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    public void disconnect() {
        this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
        this.networkMetricBuilder.build();
        this.httpUrlConnection.disconnect();
    }

    public Object getContent() throws IOException {
        Object content;
        this.updateRequestInfo();
        this.networkMetricBuilder.setHttpResponseCode(this.httpUrlConnection.getResponseCode());
        try {
            content = this.httpUrlConnection.getContent();
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
        if (content instanceof InputStream) {
            this.networkMetricBuilder.setResponseContentType(this.httpUrlConnection.getContentType());
            content = new InstrHttpInputStream((InputStream)content, this.networkMetricBuilder, this.timer);
        } else {
            this.networkMetricBuilder.setResponseContentType(this.httpUrlConnection.getContentType());
            this.networkMetricBuilder.setResponsePayloadBytes(this.httpUrlConnection.getContentLength());
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            this.networkMetricBuilder.build();
        }
        return content;
    }

    public Object getContent(Class[] classes) throws IOException {
        Object content;
        this.updateRequestInfo();
        this.networkMetricBuilder.setHttpResponseCode(this.httpUrlConnection.getResponseCode());
        try {
            content = this.httpUrlConnection.getContent(classes);
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
        if (content instanceof InputStream) {
            this.networkMetricBuilder.setResponseContentType(this.httpUrlConnection.getContentType());
            content = new InstrHttpInputStream((InputStream)content, this.networkMetricBuilder, this.timer);
        } else {
            this.networkMetricBuilder.setResponseContentType(this.httpUrlConnection.getContentType());
            this.networkMetricBuilder.setResponsePayloadBytes(this.httpUrlConnection.getContentLength());
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            this.networkMetricBuilder.build();
        }
        return content;
    }

    public InputStream getInputStream() throws IOException {
        this.updateRequestInfo();
        this.networkMetricBuilder.setHttpResponseCode(this.httpUrlConnection.getResponseCode());
        this.networkMetricBuilder.setResponseContentType(this.httpUrlConnection.getContentType());
        try {
            InputStream inputStream = this.httpUrlConnection.getInputStream();
            if (inputStream != null) {
                return new InstrHttpInputStream(inputStream, this.networkMetricBuilder, this.timer);
            }
            return inputStream;
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    public long getLastModified() {
        this.updateRequestInfo();
        long value = this.httpUrlConnection.getLastModified();
        return value;
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            OutputStream outputStream = this.httpUrlConnection.getOutputStream();
            if (outputStream != null) {
                return new InstrHttpOutputStream(outputStream, this.networkMetricBuilder, this.timer);
            }
            return outputStream;
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    public Permission getPermission() throws IOException {
        try {
            return this.httpUrlConnection.getPermission();
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    public int getResponseCode() throws IOException {
        this.updateRequestInfo();
        if (this.timeToResponseInitiatedInMicros == -1L) {
            this.timeToResponseInitiatedInMicros = this.timer.getDurationMicros();
            this.networkMetricBuilder.setTimeToResponseInitiatedMicros(this.timeToResponseInitiatedInMicros);
        }
        try {
            int code = this.httpUrlConnection.getResponseCode();
            this.networkMetricBuilder.setHttpResponseCode(code);
            return code;
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    public String getResponseMessage() throws IOException {
        this.updateRequestInfo();
        if (this.timeToResponseInitiatedInMicros == -1L) {
            this.timeToResponseInitiatedInMicros = this.timer.getDurationMicros();
            this.networkMetricBuilder.setTimeToResponseInitiatedMicros(this.timeToResponseInitiatedInMicros);
        }
        try {
            String message = this.httpUrlConnection.getResponseMessage();
            this.networkMetricBuilder.setHttpResponseCode(this.httpUrlConnection.getResponseCode());
            return message;
        }
        catch (IOException e) {
            this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.networkMetricBuilder);
            throw e;
        }
    }

    public long getExpiration() {
        this.updateRequestInfo();
        long exp = this.httpUrlConnection.getExpiration();
        return exp;
    }

    public String getHeaderField(int n) {
        this.updateRequestInfo();
        String value = this.httpUrlConnection.getHeaderField(n);
        return value;
    }

    public String getHeaderField(String name) {
        this.updateRequestInfo();
        String value = this.httpUrlConnection.getHeaderField(name);
        return value;
    }

    public long getHeaderFieldDate(String name, long defaultDate) {
        this.updateRequestInfo();
        long value = this.httpUrlConnection.getHeaderFieldDate(name, defaultDate);
        return value;
    }

    public int getHeaderFieldInt(String name, int defaultInt) {
        this.updateRequestInfo();
        int value = this.httpUrlConnection.getHeaderFieldInt(name, defaultInt);
        return value;
    }

    public long getHeaderFieldLong(String name, long defaultLong) {
        this.updateRequestInfo();
        long value = 0L;
        if (Build.VERSION.SDK_INT >= 24) {
            value = this.httpUrlConnection.getHeaderFieldLong(name, defaultLong);
        }
        return value;
    }

    public String getHeaderFieldKey(int n) {
        this.updateRequestInfo();
        String value = this.httpUrlConnection.getHeaderFieldKey(n);
        return value;
    }

    public Map<String, List<String>> getHeaderFields() {
        this.updateRequestInfo();
        Map<String, List<String>> value = this.httpUrlConnection.getHeaderFields();
        return value;
    }

    public String getContentEncoding() {
        this.updateRequestInfo();
        return this.httpUrlConnection.getContentEncoding();
    }

    public int getContentLength() {
        this.updateRequestInfo();
        return this.httpUrlConnection.getContentLength();
    }

    public long getContentLengthLong() {
        this.updateRequestInfo();
        long contentLength = 0L;
        if (Build.VERSION.SDK_INT >= 24) {
            contentLength = this.httpUrlConnection.getContentLengthLong();
        }
        return contentLength;
    }

    public String getContentType() {
        this.updateRequestInfo();
        return this.httpUrlConnection.getContentType();
    }

    public long getDate() {
        this.updateRequestInfo();
        return this.httpUrlConnection.getDate();
    }

    public void addRequestProperty(String key, String value) {
        this.httpUrlConnection.addRequestProperty(key, value);
    }

    public boolean equals(Object obj) {
        return this.httpUrlConnection.equals(obj);
    }

    public boolean getAllowUserInteraction() {
        return this.httpUrlConnection.getAllowUserInteraction();
    }

    public int getConnectTimeout() {
        return this.httpUrlConnection.getConnectTimeout();
    }

    public boolean getDefaultUseCaches() {
        return this.httpUrlConnection.getDefaultUseCaches();
    }

    public boolean getDoInput() {
        return this.httpUrlConnection.getDoInput();
    }

    public boolean getDoOutput() {
        return this.httpUrlConnection.getDoOutput();
    }

    public InputStream getErrorStream() {
        this.updateRequestInfo();
        try {
            this.networkMetricBuilder.setHttpResponseCode(this.httpUrlConnection.getResponseCode());
        }
        catch (IOException e) {
            logger.debug("IOException thrown trying to obtain the response code");
        }
        InputStream errorStream = this.httpUrlConnection.getErrorStream();
        if (errorStream != null) {
            return new InstrHttpInputStream(errorStream, this.networkMetricBuilder, this.timer);
        }
        return errorStream;
    }

    public long getIfModifiedSince() {
        return this.httpUrlConnection.getIfModifiedSince();
    }

    public boolean getInstanceFollowRedirects() {
        return this.httpUrlConnection.getInstanceFollowRedirects();
    }

    public int getReadTimeout() {
        return this.httpUrlConnection.getReadTimeout();
    }

    public String getRequestMethod() {
        return this.httpUrlConnection.getRequestMethod();
    }

    public Map<String, List<String>> getRequestProperties() {
        return this.httpUrlConnection.getRequestProperties();
    }

    public String getRequestProperty(String key) {
        return this.httpUrlConnection.getRequestProperty(key);
    }

    public URL getURL() {
        return this.httpUrlConnection.getURL();
    }

    public boolean getUseCaches() {
        return this.httpUrlConnection.getUseCaches();
    }

    public int hashCode() {
        return this.httpUrlConnection.hashCode();
    }

    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.httpUrlConnection.setAllowUserInteraction(allowuserinteraction);
    }

    public void setChunkedStreamingMode(int chunklen) {
        this.httpUrlConnection.setChunkedStreamingMode(chunklen);
    }

    public void setConnectTimeout(int timeout) {
        this.httpUrlConnection.setConnectTimeout(timeout);
    }

    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.httpUrlConnection.setDefaultUseCaches(defaultusecaches);
    }

    public void setDoInput(boolean doinput) {
        this.httpUrlConnection.setDoInput(doinput);
    }

    public void setDoOutput(boolean dooutput) {
        this.httpUrlConnection.setDoOutput(dooutput);
    }

    public void setFixedLengthStreamingMode(int contentLength) {
        this.httpUrlConnection.setFixedLengthStreamingMode(contentLength);
    }

    public void setFixedLengthStreamingMode(long contentLength) {
        this.httpUrlConnection.setFixedLengthStreamingMode(contentLength);
    }

    public void setIfModifiedSince(long ifmodifiedsince) {
        this.httpUrlConnection.setIfModifiedSince(ifmodifiedsince);
    }

    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.httpUrlConnection.setInstanceFollowRedirects(followRedirects);
    }

    public void setReadTimeout(int timeout) {
        this.httpUrlConnection.setReadTimeout(timeout);
    }

    public void setRequestMethod(String method) throws ProtocolException {
        this.httpUrlConnection.setRequestMethod(method);
    }

    public void setRequestProperty(String key, String value) {
        if (USER_AGENT_PROPERTY.equalsIgnoreCase(key)) {
            this.networkMetricBuilder.setUserAgent(value);
        }
        this.httpUrlConnection.setRequestProperty(key, value);
    }

    public void setUseCaches(boolean usecaches) {
        this.httpUrlConnection.setUseCaches(usecaches);
    }

    public String toString() {
        return this.httpUrlConnection.toString();
    }

    public boolean usingProxy() {
        return this.httpUrlConnection.usingProxy();
    }

    private void updateRequestInfo() {
        String method;
        if (this.timeRequestedInMicros == -1L) {
            this.timer.reset();
            this.timeRequestedInMicros = this.timer.getMicros();
            this.networkMetricBuilder.setRequestStartTimeMicros(this.timeRequestedInMicros);
        }
        if ((method = this.getRequestMethod()) != null) {
            this.networkMetricBuilder.setHttpMethod(method);
        } else if (this.getDoOutput()) {
            this.networkMetricBuilder.setHttpMethod("POST");
        } else {
            this.networkMetricBuilder.setHttpMethod("GET");
        }
    }
}

