/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.content.Context;
import androidx.datastore.core.DataStore;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.sessions.ApplicationInfo;
import com.google.firebase.sessions.EventGDTLogger;
import com.google.firebase.sessions.EventGDTLogger_Factory;
import com.google.firebase.sessions.FirebaseSessions;
import com.google.firebase.sessions.FirebaseSessionsComponent;
import com.google.firebase.sessions.FirebaseSessionsComponent_MainModule_Companion_ApplicationInfoFactory;
import com.google.firebase.sessions.FirebaseSessionsComponent_MainModule_Companion_SessionConfigsDataStoreFactory;
import com.google.firebase.sessions.FirebaseSessionsComponent_MainModule_Companion_SessionDataStoreFactory;
import com.google.firebase.sessions.FirebaseSessionsComponent_MainModule_Companion_TimeProviderFactory;
import com.google.firebase.sessions.FirebaseSessionsComponent_MainModule_Companion_UuidGeneratorFactory;
import com.google.firebase.sessions.FirebaseSessions_Factory;
import com.google.firebase.sessions.ProcessDataManagerImpl;
import com.google.firebase.sessions.ProcessDataManagerImpl_Factory;
import com.google.firebase.sessions.SessionData;
import com.google.firebase.sessions.SessionDataSerializer;
import com.google.firebase.sessions.SessionDataSerializer_Factory;
import com.google.firebase.sessions.SessionFirelogPublisher;
import com.google.firebase.sessions.SessionFirelogPublisherImpl;
import com.google.firebase.sessions.SessionFirelogPublisherImpl_Factory;
import com.google.firebase.sessions.SessionGenerator;
import com.google.firebase.sessions.SessionGenerator_Factory;
import com.google.firebase.sessions.SessionsActivityLifecycleCallbacks;
import com.google.firebase.sessions.SessionsActivityLifecycleCallbacks_Factory;
import com.google.firebase.sessions.SharedSessionRepository;
import com.google.firebase.sessions.SharedSessionRepositoryImpl;
import com.google.firebase.sessions.SharedSessionRepositoryImpl_Factory;
import com.google.firebase.sessions.TimeProvider;
import com.google.firebase.sessions.UuidGenerator;
import com.google.firebase.sessions.dagger.internal.DaggerGenerated;
import com.google.firebase.sessions.dagger.internal.DoubleCheck;
import com.google.firebase.sessions.dagger.internal.InstanceFactory;
import com.google.firebase.sessions.dagger.internal.Preconditions;
import com.google.firebase.sessions.dagger.internal.Provider;
import com.google.firebase.sessions.settings.LocalOverrideSettings;
import com.google.firebase.sessions.settings.LocalOverrideSettings_Factory;
import com.google.firebase.sessions.settings.RemoteSettings;
import com.google.firebase.sessions.settings.RemoteSettingsFetcher;
import com.google.firebase.sessions.settings.RemoteSettingsFetcher_Factory;
import com.google.firebase.sessions.settings.RemoteSettings_Factory;
import com.google.firebase.sessions.settings.SessionConfigs;
import com.google.firebase.sessions.settings.SessionsSettings;
import com.google.firebase.sessions.settings.SessionsSettings_Factory;
import com.google.firebase.sessions.settings.SettingsCacheImpl;
import com.google.firebase.sessions.settings.SettingsCacheImpl_Factory;
import kotlin.coroutines.CoroutineContext;

@DaggerGenerated
public final class DaggerFirebaseSessionsComponent {
    private DaggerFirebaseSessionsComponent() {
    }

    public static FirebaseSessionsComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements FirebaseSessionsComponent.Builder {
        private Context appContext;
        private CoroutineContext backgroundDispatcher;
        private CoroutineContext blockingDispatcher;
        private FirebaseApp firebaseApp;
        private FirebaseInstallationsApi firebaseInstallationsApi;
        private com.google.firebase.inject.Provider<TransportFactory> transportFactoryProvider;

        private Builder() {
        }

        @Override
        public Builder appContext(Context appContext) {
            this.appContext = Preconditions.checkNotNull(appContext);
            return this;
        }

        @Override
        public Builder backgroundDispatcher(CoroutineContext backgroundDispatcher) {
            this.backgroundDispatcher = Preconditions.checkNotNull(backgroundDispatcher);
            return this;
        }

        @Override
        public Builder blockingDispatcher(CoroutineContext blockingDispatcher) {
            this.blockingDispatcher = Preconditions.checkNotNull(blockingDispatcher);
            return this;
        }

        @Override
        public Builder firebaseApp(FirebaseApp firebaseApp) {
            this.firebaseApp = Preconditions.checkNotNull(firebaseApp);
            return this;
        }

        @Override
        public Builder firebaseInstallationsApi(FirebaseInstallationsApi firebaseInstallationsApi) {
            this.firebaseInstallationsApi = Preconditions.checkNotNull(firebaseInstallationsApi);
            return this;
        }

        @Override
        public Builder transportFactoryProvider(com.google.firebase.inject.Provider<TransportFactory> transportFactoryProvider) {
            this.transportFactoryProvider = Preconditions.checkNotNull(transportFactoryProvider);
            return this;
        }

        @Override
        public FirebaseSessionsComponent build() {
            Preconditions.checkBuilderRequirement(this.appContext, Context.class);
            Preconditions.checkBuilderRequirement(this.backgroundDispatcher, CoroutineContext.class);
            Preconditions.checkBuilderRequirement(this.blockingDispatcher, CoroutineContext.class);
            Preconditions.checkBuilderRequirement(this.firebaseApp, FirebaseApp.class);
            Preconditions.checkBuilderRequirement(this.firebaseInstallationsApi, FirebaseInstallationsApi.class);
            Preconditions.checkBuilderRequirement(this.transportFactoryProvider, com.google.firebase.inject.Provider.class);
            return new FirebaseSessionsComponentImpl(this.appContext, this.backgroundDispatcher, this.blockingDispatcher, this.firebaseApp, this.firebaseInstallationsApi, this.transportFactoryProvider);
        }
    }

    private static final class FirebaseSessionsComponentImpl
    implements FirebaseSessionsComponent {
        private final FirebaseSessionsComponentImpl firebaseSessionsComponentImpl = this;
        private Provider<FirebaseApp> firebaseAppProvider;
        private Provider<Context> appContextProvider;
        private Provider<LocalOverrideSettings> localOverrideSettingsProvider;
        private Provider<TimeProvider> timeProvider;
        private Provider<FirebaseInstallationsApi> firebaseInstallationsApiProvider;
        private Provider<ApplicationInfo> applicationInfoProvider;
        private Provider<CoroutineContext> blockingDispatcherProvider;
        private Provider<RemoteSettingsFetcher> remoteSettingsFetcherProvider;
        private Provider<CoroutineContext> backgroundDispatcherProvider;
        private Provider<DataStore<SessionConfigs>> sessionConfigsDataStoreProvider;
        private Provider<SettingsCacheImpl> settingsCacheImplProvider;
        private Provider<RemoteSettings> remoteSettingsProvider;
        private Provider<SessionsSettings> sessionsSettingsProvider;
        private Provider<UuidGenerator> uuidGeneratorProvider;
        private Provider<SessionGenerator> sessionGeneratorProvider;
        private Provider<com.google.firebase.inject.Provider<TransportFactory>> transportFactoryProvider;
        private Provider<EventGDTLogger> eventGDTLoggerProvider;
        private Provider<SessionFirelogPublisherImpl> sessionFirelogPublisherImplProvider;
        private Provider<SessionDataSerializer> sessionDataSerializerProvider;
        private Provider<DataStore<SessionData>> sessionDataStoreProvider;
        private Provider<ProcessDataManagerImpl> processDataManagerImplProvider;
        private Provider<SharedSessionRepositoryImpl> sharedSessionRepositoryImplProvider;
        private Provider<SessionsActivityLifecycleCallbacks> sessionsActivityLifecycleCallbacksProvider;
        private Provider<FirebaseSessions> firebaseSessionsProvider;

        private FirebaseSessionsComponentImpl(Context appContextParam, CoroutineContext backgroundDispatcherParam, CoroutineContext blockingDispatcherParam, FirebaseApp firebaseAppParam, FirebaseInstallationsApi firebaseInstallationsApiParam, com.google.firebase.inject.Provider<TransportFactory> transportFactoryProviderParam) {
            this.initialize(appContextParam, backgroundDispatcherParam, blockingDispatcherParam, firebaseAppParam, firebaseInstallationsApiParam, transportFactoryProviderParam);
        }

        private void initialize(Context appContextParam, CoroutineContext backgroundDispatcherParam, CoroutineContext blockingDispatcherParam, FirebaseApp firebaseAppParam, FirebaseInstallationsApi firebaseInstallationsApiParam, com.google.firebase.inject.Provider<TransportFactory> transportFactoryProviderParam) {
            this.firebaseAppProvider = InstanceFactory.create(firebaseAppParam);
            this.appContextProvider = InstanceFactory.create(appContextParam);
            this.localOverrideSettingsProvider = DoubleCheck.provider(LocalOverrideSettings_Factory.create(this.appContextProvider));
            this.timeProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_TimeProviderFactory.create());
            this.firebaseInstallationsApiProvider = InstanceFactory.create(firebaseInstallationsApiParam);
            this.applicationInfoProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_ApplicationInfoFactory.create(this.firebaseAppProvider));
            this.blockingDispatcherProvider = InstanceFactory.create(blockingDispatcherParam);
            this.remoteSettingsFetcherProvider = DoubleCheck.provider(RemoteSettingsFetcher_Factory.create(this.applicationInfoProvider, this.blockingDispatcherProvider));
            this.backgroundDispatcherProvider = InstanceFactory.create(backgroundDispatcherParam);
            this.sessionConfigsDataStoreProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_SessionConfigsDataStoreFactory.create(this.appContextProvider, this.blockingDispatcherProvider));
            this.settingsCacheImplProvider = DoubleCheck.provider(SettingsCacheImpl_Factory.create(this.backgroundDispatcherProvider, this.timeProvider, this.sessionConfigsDataStoreProvider));
            this.remoteSettingsProvider = DoubleCheck.provider(RemoteSettings_Factory.create(this.timeProvider, this.firebaseInstallationsApiProvider, this.applicationInfoProvider, this.remoteSettingsFetcherProvider, this.settingsCacheImplProvider));
            this.sessionsSettingsProvider = DoubleCheck.provider(SessionsSettings_Factory.create(this.localOverrideSettingsProvider, this.remoteSettingsProvider));
            this.uuidGeneratorProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_UuidGeneratorFactory.create());
            this.sessionGeneratorProvider = DoubleCheck.provider(SessionGenerator_Factory.create(this.timeProvider, this.uuidGeneratorProvider));
            this.transportFactoryProvider = InstanceFactory.create(transportFactoryProviderParam);
            this.eventGDTLoggerProvider = DoubleCheck.provider(EventGDTLogger_Factory.create(this.transportFactoryProvider));
            this.sessionFirelogPublisherImplProvider = DoubleCheck.provider(SessionFirelogPublisherImpl_Factory.create(this.firebaseAppProvider, this.firebaseInstallationsApiProvider, this.sessionsSettingsProvider, this.eventGDTLoggerProvider, this.backgroundDispatcherProvider));
            this.sessionDataSerializerProvider = DoubleCheck.provider(SessionDataSerializer_Factory.create(this.sessionGeneratorProvider));
            this.sessionDataStoreProvider = DoubleCheck.provider(FirebaseSessionsComponent_MainModule_Companion_SessionDataStoreFactory.create(this.appContextProvider, this.blockingDispatcherProvider, this.sessionDataSerializerProvider));
            this.processDataManagerImplProvider = DoubleCheck.provider(ProcessDataManagerImpl_Factory.create(this.appContextProvider, this.uuidGeneratorProvider));
            this.sharedSessionRepositoryImplProvider = DoubleCheck.provider(SharedSessionRepositoryImpl_Factory.create(this.sessionsSettingsProvider, this.sessionGeneratorProvider, this.sessionFirelogPublisherImplProvider, this.timeProvider, this.sessionDataStoreProvider, this.processDataManagerImplProvider, this.backgroundDispatcherProvider));
            this.sessionsActivityLifecycleCallbacksProvider = DoubleCheck.provider(SessionsActivityLifecycleCallbacks_Factory.create(this.sharedSessionRepositoryImplProvider));
            this.firebaseSessionsProvider = DoubleCheck.provider(FirebaseSessions_Factory.create(this.firebaseAppProvider, this.sessionsSettingsProvider, this.backgroundDispatcherProvider, this.sessionsActivityLifecycleCallbacksProvider));
        }

        @Override
        public FirebaseSessions getFirebaseSessions() {
            return (FirebaseSessions)this.firebaseSessionsProvider.get();
        }

        @Override
        public SessionFirelogPublisher getSessionFirelogPublisher() {
            return (SessionFirelogPublisher)this.sessionFirelogPublisherImplProvider.get();
        }

        @Override
        public SessionGenerator getSessionGenerator() {
            return (SessionGenerator)this.sessionGeneratorProvider.get();
        }

        @Override
        public SessionsSettings getSessionsSettings() {
            return (SessionsSettings)this.sessionsSettingsProvider.get();
        }

        @Override
        public SharedSessionRepository getSharedSessionRepository() {
            return (SharedSessionRepository)this.sharedSessionRepositoryImplProvider.get();
        }
    }
}

